/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbank.dbmodel.api.NearbyStarDto;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NearbyStarsRepository {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IObjektnamenRepository objektnamenRepository;
    private final IIdCacheDAO idCache;

    @Inject
    public NearbyStarsRepository(IDatenbankverbinder iDatenbankverbinder, IObjektnamenRepository iObjektnamenRepository, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.objektnamenRepository = iObjektnamenRepository;
        this.idCache = iIdCacheDAO;
    }

    public List<NearbyStarDto> getStarsWithin34ly() {
        ArrayList<NearbyStarDto> arrayList = new ArrayList<NearbyStarDto>();
        try {
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.entfernung, qObjekttypen.typ}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qObjekttypen)).on((Predicate)qDaten.objektid.eq(qObjekttypen.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.entfernung.between(1.0, 34.0)))).orderBy((OrderSpecifier<?>)qDaten.entfernung.asc())).fetch();
            for (Tuple tuple : list) {
                int n = tuple.get(qDaten.id);
                double d = tuple.get(qDaten.entfernung);
                String string = tuple.get(qObjekttypen.typ);
                String string2 = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.BEKANNTHEIT).get(0);
                arrayList.add(new NearbyStarDto(string2, string, d));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("getStarsWithin34ly()", runtimeException);
        }
        return arrayList;
    }
}

