/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.datenbank.dbmodel.api.IFilterDAO;
import de.planetensuche.datenbank.dbmodel.api.IObjektnamenFilterDAO;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class ObjektnamenGefiltertDAO
implements IObjektnamenFilterDAO {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IFilterDAO filterService;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankService datenbankService;

    @Inject
    public ObjektnamenGefiltertDAO(IFilterDAO iFilterDAO, IKategorienRepository iKategorienRepository, IDatenbankService iDatenbankService) {
        this.filterService = iFilterDAO;
        this.kategorienRepository = iKategorienRepository;
        this.datenbankService = iDatenbankService;
    }

    @Override
    public List<String> getNamenFuerKategorie(int n, boolean bl, FilterkonfigurationDto filterkonfigurationDto) {
        try {
            List<String> list = this.kategorienRepository.getKategorien();
            if (list.size() < n || n < 0) {
                return new ArrayList<String>();
            }
            String string = list.get(n);
            this.logging.debug("gewaehlte Kategorie: " + string + " (index " + n + ")");
            List<String> list2 = n == 9 ? this.datenbankService.getSternbilderNamen(this.datenbankService.getSternbildsprache()) : (!bl ? this.datenbankService.getListeMitStrings("SELECT N.Namen FROM namen AS N, daten AS D, objekttypen AS O, kategorie AS K WHERE N.datenid=D.id AND O.id=D.objektid AND O.kategorieid=K.id AND K.Name='" + string + "' ORDER BY N.Namen;", "Namen") : (!"".equals(filterkonfigurationDto.getParameterWert(n, 8)) && !"false".equals(filterkonfigurationDto.getParameterWert(n, 8)) ? this.datenbankService.getListeMitStrings("SELECT N.Namen FROM namen AS N JOIN (SELECT datenid AS did FROM zt WHERE bildid>0 INTERSECT SELECT D.id FROM daten AS D, objekttypen AS O, kategorie AS K WHERE O.id=D.objektid AND O.kategorieid=K.id AND K.Name='" + string + "'" + this.filterService.erzeugeSQLBedingungen(n, filterkonfigurationDto) + ") ON N.datenid=did ORDER BY N.Namen;", "Namen") : this.datenbankService.getListeMitStrings("SELECT N.Namen FROM namen AS N, daten AS D, objekttypen AS O, kategorie AS K WHERE N.datenid=D.id AND O.id=D.objektid AND O.kategorieid=K.id AND K.Name='" + string + "'" + this.filterService.erzeugeSQLBedingungen(n, filterkonfigurationDto) + " ORDER BY N.Namen;", "Namen")));
            return list2;
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in getNamenFuerKategorie(" + n + "," + bl + "): " + sQLException.toString(), sQLException);
            return new ArrayList<String>(0);
        }
    }
}

