/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.common.io.Files;
import de.planetensuche.datenbank.dbmodel.api.IReparaturDialog;
import de.planetensuche.datenbank.dbmodel.api.ISQLScript;
import de.planetensuche.datenbank.importierer.api.IImportDialog;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;

public final class SQLScript
extends Tabellenstruktur
implements ISQLScript {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());

    @Override
    public boolean loadSQLScript(File file, IReparaturDialog iReparaturDialog, IImportDialog iImportDialog) {
        try {
            List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
            if (iReparaturDialog != null) {
                iReparaturDialog.setText("importiere " + list.size() + " Zeilen aus dem SQL-Script...");
            } else if (iImportDialog != null) {
                iImportDialog.appendOutput("importiere " + list.size() + " Zeilen aus dem SQL-Script...");
            } else {
                System.out.println("importiere " + list.size() + " Zeilen aus dem SQL-Script...");
            }
            double d = 1.0;
            int n = 0;
            if (iReparaturDialog != null) {
                n = iReparaturDialog.getFortschritt();
                d = (100.0 - ((double)iReparaturDialog.getFortschritt() + 2.0)) / 100.0;
            }
            int n2 = 0;
            for (String string : list) {
                if (!string.startsWith("//") && !string.startsWith("#")) {
                    this.fuehreQueryAus(string);
                }
                double d2 = (double)(++n2) * 100.0 / (double)list.size();
                if (iReparaturDialog != null) {
                    iReparaturDialog.setFortschritt(n + (int)(d2 * d));
                    continue;
                }
                if (iImportDialog != null) {
                    iImportDialog.setStatus((int)d2);
                    continue;
                }
                System.out.println((int)d2 + "% fertig...");
            }
            return true;
        }
        catch (IOException iOException) {
            this.logging.error("Fehler beim Importieren des SQL-Scripts:\n" + iOException.toString(), iOException);
            return false;
        }
    }

    private void fuehreQueryAus(String string) {
        try {
            BeanFactory.getInstance().executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
    }
}

