/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class TimestampDAO
implements ITimestampDAO {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IdCacheDAO idCacheDAO;

    @Inject
    public TimestampDAO(IDatenbankverbinder iDatenbankverbinder, IdCacheDAO idCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDAO = idCacheDAO;
    }

    @Override
    public List<Integer> getIDsFuerTag(String string) {
        try {
            return BeanFactory.getInstance().getListeMitInt("SELECT id FROM daten WHERE stamp >= '" + string + " 00:00:00.0' AND stamp <= '" + string + " 23:59:59.999999' ORDER BY id;", "id");
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in getIDsFuerTag(" + string + ")", sQLException);
            return new ArrayList<Integer>(0);
        }
    }

    @Override
    public List<Integer> getIDsNachTag(String string) {
        try {
            return BeanFactory.getInstance().getListeMitInt("SELECT id FROM daten WHERE stamp >= '" + string + " 00:00:00.0' ORDER BY id;", "id");
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in getIDsNachTag(" + string + ")", sQLException);
            return new ArrayList<Integer>(0);
        }
    }

    @Override
    public List<String> getZeitraeume() {
        QDaten qDaten = QDaten.daten;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.stamp).from((Expression<?>)qDaten)).orderBy((OrderSpecifier<?>)qDaten.stamp.asc())).fetch();
            String string = "";
            for (Timestamp timestamp : list) {
                String string2 = timestamp.toString().substring(0, 10);
                if (string2.equals(string)) continue;
                arrayList.add(string2);
                string = string2;
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
        }
        return arrayList;
    }

    @Override
    public long countInsertedIdsAfterDate(Instant instant) {
        QDaten qDaten = QDaten.daten;
        try {
            long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.stamp.after(new Timestamp(instant.toEpochMilli())))).fetchCount();
            return l;
        }
        catch (Exception exception) {
            this.logging.error(exception);
            return 0L;
        }
    }

    @Override
    public Timestamp getZuletztAktualisiert(String string) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        try {
            return (Timestamp)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.stamp).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qNamen.namen.eq(string))).fetchFirst();
        }
        catch (Exception exception) {
            this.logging.error("Fehler in getZuletztAktualisiert(" + string + "):\n" + exception.toString(), exception);
            return null;
        }
    }

    @Override
    public long countInsertedExoplanetIdsAfterDate(Instant instant) {
        QDaten qDaten = QDaten.daten;
        try {
            long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.stamp.after(new Timestamp(instant.toEpochMilli())).and(qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten())))).fetchCount();
            return l;
        }
        catch (Exception exception) {
            this.logging.error(exception);
            return 0L;
        }
    }
}

