/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.helfer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class FileChooserHelfer {
    private FileChooserHelfer() {
    }

    public static boolean showFileChooser(List<String> list) throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Speicherort und Dateiname auswaehlen");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".sql");
            }

            @Override
            public String getDescription() {
                return "SQL-Script (.sql)";
            }
        });
        jFileChooser.setSize(250, 250);
        jFileChooser.setVisible(true);
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            Object object = jFileChooser.getSelectedFile().getName();
            if (!((String)object).endsWith(".sql")) {
                object = (String)object + ".sql";
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object, false), Charset.forName("UTF-8")));){
                for (int i = 0; i < list.size(); ++i) {
                    bufferedWriter.write(list.get(i));
                    bufferedWriter.newLine();
                }
            }
        }
        return true;
    }
}

