/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbank.KatalogService;
import de.planetensuche.datenbank.api.GrichischesAlphabet;
import de.planetensuche.datenbank.dbmodel.menuextras.IKatalogDAO;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class KatalogDAO
implements IKatalogDAO {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public KatalogDAO(IDatenbankverbinder iDatenbankverbinder, IObjektnamenRepository iObjektnamenRepository) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.objektnamenRepository = iObjektnamenRepository;
    }

    @Override
    public List<String> getNamenFuerKatalog(String string) {
        try {
            return BeanFactory.getInstance().getListeMitStrings("SELECT N.Namen FROM namen AS N, daten AS D WHERE " + this.nenneRegulaerenAusdruck(string) + " ORDER BY N.Namen;", "Namen");
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in getNamenFuerKatalog(" + string + "): " + sQLException.toString(), sQLException);
            return new ArrayList<String>();
        }
    }

    private String nenneRegulaerenAusdruck(String string) {
        String string2 = this.cutCatalogName(string);
        Object object = "";
        if ("Bayer".equals(string2)) {
            object = "(N.Namen LIKE 'Alpha %' OR N.Namen LIKE 'Beta %' OR N.Namen LIKE 'Gamma %' OR N.Namen LIKE 'Delta %' OR N.Namen LIKE 'Epsilon %' OR N.Namen LIKE 'Zeta %' OR N.Namen LIKE 'Eta %' OR N.Namen LIKE 'Theta %' OR N.Namen LIKE 'Iota %' OR N.Namen LIKE 'Kappa %' OR N.Namen LIKE 'Lambda %' OR N.Namen LIKE 'My %' OR N.Namen LIKE 'Ny %' OR N.Namen LIKE 'Xi %' OR N.Namen LIKE 'Ksi %' OR N.Namen LIKE 'Omikron %' OR N.Namen LIKE 'Omicron %' OR N.Namen LIKE 'Pi %' OR N.Namen LIKE 'Rho %' OR N.Namen LIKE 'Sigma %' OR N.Namen LIKE 'Tau %' OR N.Namen LIKE 'Ypsilon %' OR N.Namen LIKE 'Upsilon %' OR N.Namen LIKE 'Ups %' OR N.Namen LIKE 'Phi %' OR N.Namen LIKE 'Chi %' OR N.Namen LIKE 'Psi %' OR N.Namen LIKE 'Omega %') AND (N.datenid=D.Id)";
        } else if ("Flamesteed".equals(string2)) {
            object = "(N.Namen LIKE '1%' OR N.Namen LIKE '2%' OR N.Namen LIKE '3%' OR N.Namen LIKE '4%' OR N.Namen LIKE '5%' OR N.Namen LIKE '6%' OR N.Namen LIKE '7%' OR N.Namen LIKE '8%' OR N.Namen LIKE '9%') AND (N.datenid=D.Id)";
        } else if ("HR".equals(string2) || "BSC".equals(string2)) {
            object = "(N.Namen LIKE 'BSC %' OR N.Namen LIKE 'HR %') AND (N.datenid=D.Id)";
        } else if ("HIP".equals(string2) || "HIC".equals(string2)) {
            object = "(N.Namen LIKE 'HIP %' OR N.Namen LIKE 'HIC %') AND (N.datenid=D.Id)";
        } else if ("Messier Catalogue".equals(string2)) {
            object = "(N.Namen LIKE 'M %') AND (N.datenid=D.Id)";
        } else if (string2.startsWith("John")) {
            object = "(N.Namen LIKE 'h %') AND (N.datenid=D.Id)";
        } else if (string2.startsWith("William")) {
            object = "(N.Namen LIKE 'H %') AND (N.datenid=D.Id)";
        } else if ("VDB".equals(string2)) {
            object = "(N.Namen LIKE 'VDB %') AND (N.datenid=D.Id)";
        } else {
            try {
                List<String> list = new KatalogService().ladeKatalogDatei();
                string2 = string2.toLowerCase().trim();
                for (String string3 : list) {
                    String[] stringArray = string3.split(",");
                    if (!stringArray[0].toLowerCase().equals(string2) && !stringArray[1].toLowerCase().equals(string2)) continue;
                    List<String> list2 = BeanFactory.getInstance().getListeMitStrings("SELECT namen FROM namen WHERE UPPER(namen) LIKE '" + stringArray[0].toUpperCase() + "+%' OR UPPER(namen) LIKE '" + stringArray[0].toUpperCase() + "-%' LIMIT 2", "namen");
                    if (list2.size() > 0) {
                        return "(UPPER(N.Namen) LIKE '" + stringArray[0].toUpperCase() + "+%' OR UPPER(N.Namen) LIKE '" + stringArray[0].toUpperCase() + "-%') AND (N.datenid=D.Id)";
                    }
                    List<String> list3 = BeanFactory.getInstance().getListeMitStrings("SELECT namen FROM namen WHERE UPPER(namen) LIKE '" + stringArray[1].toUpperCase() + " %' LIMIT 2", "namen");
                    if (!list3.isEmpty()) {
                        return "(UPPER(N.Namen) LIKE '" + stringArray[1].toUpperCase() + " %') AND (N.datenid=D.Id)";
                    }
                    return "(UPPER(N.Namen) LIKE '" + stringArray[0].toUpperCase() + " %') AND (N.datenid=D.Id)";
                }
                object = "(N.Namen LIKE '" + string2 + "%') AND (N.datenid=D.Id)";
            }
            catch (SQLException sQLException) {
                this.logging.error("Fehler in nenneRegulaerenAusdruck(" + string2 + "): " + sQLException.toString(), sQLException);
            }
            catch (IOException iOException) {
                this.logging.error("Fehler in nenneRegulaerenAusdruck(" + string2 + "): " + iOException.toString(), iOException);
            }
        }
        return object;
    }

    private String cutCatalogName(String string) {
        String string2 = string;
        if (string.endsWith(" Katalog") || string.endsWith(" catalog")) {
            string2 = string.substring(0, string.length() - 8).trim();
        } else if (string.endsWith(" catalogue")) {
            string2 = string.substring(0, string.length() - 10).trim();
        }
        return string2;
    }

    @Override
    public int zaehleAnzahlObjekteFlamesteed() {
        try {
            int n = 0;
            List<String> list = BeanFactory.getInstance().getSternbilderNamen(SternbildSprache.LATEINISCH_GENITIV);
            for (String string : list) {
                StringBuilder stringBuilder = new StringBuilder(20);
                for (int i = 1; i < 10; ++i) {
                    stringBuilder.append("namen LIKE '").append(i).append("% ").append(string).append("%' OR ");
                }
                String string2 = stringBuilder.substring(0, stringBuilder.length() - 4);
                Integer n2 = BeanFactory.getInstance().getInt("SELECT COUNT(namen) AS c FROM namen WHERE " + string2 + ";", "c");
                if (n2 == null) continue;
                n += n2.intValue();
            }
            return n;
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in zaehleAnzahlObjekteFlamesteed(): " + sQLException.toString(), sQLException);
            return -1;
        }
    }

    @Override
    public int zaehleAnzahlObjekteBayer() {
        try {
            StringBuilder stringBuilder = new StringBuilder(24);
            for (String string : GrichischesAlphabet.getListe()) {
                stringBuilder.append("namen LIKE '").append(string).append(" %' OR ");
            }
            String string = "SELECT COUNT(namen) AS c FROM namen WHERE " + stringBuilder.substring(0, stringBuilder.length() - 4) + ";";
            return BeanFactory.getInstance().getInt(string, "c");
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in zaehleAnzahlObjekteBayer(): " + sQLException.toString(), sQLException);
            return -1;
        }
    }

    @Override
    public String getBeispielInKatalog(String string) {
        String string2 = "";
        try {
            string2 = BeanFactory.getInstance().getString("(SELECT Namen FROM namen WHERE Namen LIKE '" + string + " %') MINUS (SELECT ('" + string + " ' + latgenitiv) FROM Sternbilder) LIMIT 1;", "Namen");
            if (string2.isEmpty()) {
                string2 = BeanFactory.getInstance().getString("SELECT Namen FROM namen WHERE (Namen LIKE '" + string + "+%') OR (Namen LIKE '" + string + "-%') LIMIT 1;", "Namen");
            }
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in getBeispielInKatalog(" + string + ")", sQLException);
        }
        return string2;
    }

    @Override
    public int getAnzahlObjekteInKatalog(String string) {
        int n = 0;
        try {
            List<String> list = BeanFactory.getInstance().getListeMitStrings("(SELECT Namen FROM namen WHERE Namen LIKE '" + string + " %') MINUS (SELECT ('" + string + " ' + latgenitiv) FROM sternbilder);", "namen");
            n = list.size();
            if (n < 1) {
                Integer n2 = BeanFactory.getInstance().getInt("SELECT COUNT(Namen) AS c FROM namen WHERE (Namen LIKE '" + string + "+%') OR (Namen LIKE '" + string + "-%');", "c");
                if (n2 == null) {
                    return 0;
                }
                return n2;
            }
            return n;
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in zaehleAnzahlObjekte(" + string + "): " + sQLException.toString(), sQLException);
            return -1;
        }
    }

    @Override
    public int zaehleAnzahlGCVSCatalog() {
        try {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            List<String> list = BeanFactory.getInstance().getSternbilderNamen(SternbildSprache.LATEINISCH_GENITIV);
            QNamen qNamen = QNamen.namen1;
            Pattern pattern = Pattern.compile("^V[0-9]{1,4} [A-Z]+[a-zA-Z]{2,12}( [A-Z]+[a-z]{5,11})?");
            for (String string2 : list) {
                List<String> list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).where(qNamen.namen.startsWith("V").and(qNamen.namen.endsWith(string2)))).fetch();
                list2.forEach(string -> {
                    Matcher matcher = pattern.matcher((CharSequence)string);
                    if (matcher.matches()) {
                        atomicInteger.incrementAndGet();
                    }
                });
            }
            return atomicInteger.get();
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in zaehleAnzahlGCVSCatalog(): " + sQLException.toString(), sQLException);
            return -1;
        }
    }

    @Override
    public int zaehleAnzahlGCVS2Catalog() {
        try {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            List<String> list = BeanFactory.getInstance().getSternbilderNamen(SternbildSprache.LATEINISCH_GENITIV);
            Pattern pattern = Pattern.compile("^[A-Z]{2} [A-Z]+[a-zA-Z]{2,12}( [A-Z]+[a-z]{5,11})?( [A-D]{1,2})?");
            List<String> list2 = this.objektnamenRepository.findAllForCategory(ObjektKategorie.STERNE.getKategorienName());
            list2.forEach(string -> {
                Matcher matcher = pattern.matcher((CharSequence)string);
                if (matcher.matches()) {
                    for (String string2 : list) {
                        if (!string.toLowerCase().contains(string2.toLowerCase())) continue;
                        atomicInteger.incrementAndGet();
                    }
                }
            });
            return atomicInteger.get();
        }
        catch (SQLException sQLException) {
            this.logging.error("Fehler in zaehleAnzahlGCVS2Catalog(): " + sQLException.toString(), sQLException);
            return -1;
        }
    }
}

