/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class BrauneZwergeRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 4;
    private final List<String> ergebnis = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;

    public BrauneZwergeRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.BR_ZWERGE.getKategorienName());
            if (n <= 0) {
                return;
            }
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m341") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " " + this.i18n.getString("db_m83"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m342") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " " + this.i18n.getString("db_m83"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.masse.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.masse.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.masse.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m343") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.masse)) + " Mjup");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.masse.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.masse.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.masse.gt(0.0))))))).fetchFirst();
            Double d = tuple.get(qDaten.masse);
            this.ergebnis.add(this.i18n.getString("db_m344") + ";" + tuple.get(qNamen.namen) + ";" + d + " Mjup (" + this.i18n.toLocalisedDouble((double)Math.round(d / 1048.447 * 1000.0) / 1000.0) + " Msun)");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.umlaufszeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.umlaufszeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.umlaufszeit.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.umlaufszeit.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m345") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.umlaufszeit)) + "  " + this.i18n.getString("db_m105"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.umlaufszeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.umlaufszeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.umlaufszeit.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.umlaufszeit.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m346") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.umlaufszeit)) + "  " + this.i18n.getString("db_m105"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.temperatur, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.temperatur.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.temperatur.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.temperatur.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m347") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.temperatur)) + "  " + this.i18n.getString("db_m114"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.temperatur, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.temperatur.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.temperatur.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.temperatur.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m348") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.temperatur)) + "  " + this.i18n.getString("db_m114"));
            this.logger.debug("collect brown dwarf data needs " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.ergebnis, 4);
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

