/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class GalaxienhaufenRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 10;
    private final List<String> v = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;

    public GalaxienhaufenRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.GALAXIENHAUFEN.getKategorienName());
            if (n <= 0) {
                return;
            }
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            long l = System.currentTimeMillis();
            Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Galaxienhaufen"))).fetchOne();
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.entfernung.in(SQLExpressions.union((SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.entfernung.gt(0.0))), (SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2)))).and(qDaten.objektid.eq(n2)))).fetch();
            String string = null;
            String string2 = null;
            double d = 0.0;
            double d2 = 0.0;
            for (Tuple tuple : list) {
                String string3 = tuple.get(qNamen.namen);
                double d3 = tuple.get(qDaten.entfernung);
                if (string == null) {
                    string = string3;
                    d = d3;
                }
                if (string2 == null) {
                    string2 = string3;
                    d2 = d3;
                }
                if (d3 > d2) {
                    string2 = string3;
                    d2 = d3;
                    continue;
                }
                if (!(d3 < d)) continue;
                string = string3;
                d = d3;
            }
            this.v.add(this.i18n.getString("db_m407") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " ly");
            this.v.add(this.i18n.getString("db_m408") + ";" + string2 + ";" + this.i18n.toLocalisedDouble(d2) + " ly");
            this.logger.debug("collect galaxy cluster data needs " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.v, 10);
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

