/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class KometenRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 1;
    private final List<String> v = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;

    public KometenRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.KOMETEN.getKategorienName());
            if (n <= 0) {
                return;
            }
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsKometen()).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsKometen()).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m321") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " " + this.i18n.getString("db_m83"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsKometen()).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsKometen())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m322") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " " + this.i18n.getString("db_m83"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.umlaufszeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsKometen()).and(qDaten.umlaufszeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.umlaufszeit.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsKometen())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m323") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.umlaufszeit)) + " " + this.i18n.getString("db_m105"));
            this.logger.debug("collect comet data needs " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.v, 1);
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

