/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class PlanetenRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 3;
    private final List<String> v = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;

    public PlanetenRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.PLANETEN.getKategorienName());
            if (n <= 0) {
                return;
            }
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m327") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " " + this.i18n.getString("db_m83"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m328") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " " + this.i18n.getString("db_m83"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.masse.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m329") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.masse)) + " Mjup");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.masse.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.gt(0.0))))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m330") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.masse)) + " Mjup");
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.masse.gt(0.0)).and(qDaten.durchmesser.gt(0.0)))).fetch();
            String string = "";
            double d = 100.0;
            String string2 = "";
            double d2 = 100.0;
            for (Tuple tuple2 : list) {
                double d3 = tuple2.get(qDaten.masse);
                double d4 = tuple2.get(qDaten.durchmesser);
                String string3 = tuple2.get(qNamen.namen);
                double d5 = this.getDichteFuerPlanet(d3, d4);
                if (d5 < d) {
                    d = d5;
                    string = string3;
                    continue;
                }
                if (!(d5 > d2)) continue;
                d2 = d5;
                string2 = string3;
            }
            d = (double)Math.round(d * 10000.0) / 10000.0;
            this.v.add(this.i18n.getString("db_m331") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " g/cm\u00b3");
            d2 = (double)Math.round(d2 * 10000.0) / 10000.0;
            this.v.add(this.i18n.getString("db_m332") + ";" + string2 + ";" + this.i18n.toLocalisedDouble(d2) + " g/cm\u00b3");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.geschwindigkeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.geschwindigkeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.geschwindigkeit.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.geschwindigkeit.gt(0.0))))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m333") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.geschwindigkeit)) + " km/s");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.geschwindigkeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.geschwindigkeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.geschwindigkeit.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m334") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.geschwindigkeit)) + " km/s");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.exzentritaet, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.exzentritaet.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.exzentritaet.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.exzentritaet.gt(0.0))))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m335") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.exzentritaet)));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.exzentritaet, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.exzentritaet.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.exzentritaet.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m336") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.exzentritaet)));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.umlaufszeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.umlaufszeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.umlaufszeit.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.umlaufszeit.gt(0.0))))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m337") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.umlaufszeit)) + " " + this.i18n.getString("db_m105"));
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.umlaufszeit, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.umlaufszeit.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.umlaufszeit.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))))).fetchFirst();
            this.v.add(this.i18n.getString("db_m338") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.umlaufszeit)) + " " + this.i18n.getString("db_m105"));
            Tuple tuple3 = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.zugehoerigkeit, qDaten.zugehoerigkeit.count().as("c")}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsMonde()))).groupBy((Expression<?>)qDaten.zugehoerigkeit)).orderBy((OrderSpecifier<?>)((ComparableExpressionBase)qDaten.zugehoerigkeit.count().as("c")).desc())).fetchFirst();
            int n2 = tuple3.get(qDaten.zugehoerigkeit);
            int n3 = tuple3.get(1, Long.class).intValue();
            String string4 = (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).where(qNamen.datenid.eq(n2))).fetchFirst();
            this.v.add(this.i18n.getString("db_m339") + ";" + string4 + ";" + n3 + " " + this.i18n.getString("db_m340"));
            this.v.add(this.i18n.getString("db_m433") + ";HD 209458 b;" + this.i18n.toLocalisedDouble(10000.0) + " km/h");
            this.v.add(this.i18n.getString("db_m434") + ";Neptun;" + this.i18n.toLocalisedDouble(4200.0) + " km");
            this.logger.debug("collect planet data needs " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.v, 3);
    }

    private double getDichteFuerPlanet(double d, double d2) {
        double d3 = 0.5235987755982988 * Math.pow(d2 * 100000.0 * 142984.0, 3.0);
        return d * 1000.0 * 1.899E27 / d3;
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

