/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SonstigesRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 11;
    private final List<String> v = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;

    public SonstigesRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.objektnamenRepository = iObjektnamenRepository;
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.SONSTIGES.getKategorienName());
            if (n > 0) {
                long l = System.currentTimeMillis();
                QNamen qNamen = QNamen.namen1;
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qNamen.datenid, qNamen.datenid.count().as("c")}).from((Expression<?>)qNamen)).groupBy((Expression<?>)qNamen.datenid)).orderBy((OrderSpecifier<?>)((ComparableExpressionBase)qNamen.datenid.count().as("c")).desc())).fetchFirst();
                int n2 = tuple.get(qNamen.datenid);
                long l2 = tuple.get(1, Long.class);
                String string = this.objektnamenRepository.getNamenByDatenId(n2, ObjektnamenSortierung.BEKANNTHEIT).get(0);
                this.v.add(this.i18n.getString("db_m409") + ";" + string + ";" + l2 + " " + this.i18n.getString("db_m129"));
                this.logger.debug("collect other data needs " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.v, 11);
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

