/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.Pair;

public class SterneRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 5;
    private final List<String> ergebnis;
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IdCacheDAO cacheDao;
    private long startCalc;
    private final Map<Integer, String> sortedResult;

    public SterneRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder, IdCacheDAO idCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.cacheDao = idCacheDAO;
        this.ergebnis = new ArrayList<String>();
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.objektnamenRepository = iObjektnamenRepository;
        this.sortedResult = new TreeMap<Integer, String>();
    }

    public void run() {
        try {
            this.collectData();
        }
        catch (InterruptedException | RuntimeException | SQLException | ExecutionException exception) {
            this.logger.error(exception);
        }
    }

    private Callable<Pair<Integer, String>> createTaskNearestStar(int n) {
        return () -> {
            this.logger.debug("n\u00e4chster stern thread started");
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.entfernung.between(1.0, 5.0)))).orderBy((OrderSpecifier<?>)qDaten.entfernung.asc())).orderBy((OrderSpecifier<?>)qNamen.namen.asc())).fetchFirst();
                Double d = tuple.get(qDaten.entfernung);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("n\u00e4chster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m349") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " ly";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskAwayestStar(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("entferntester stern thread started");
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)list).and(qDaten.entfernung.gt(200000.0)))).orderBy((OrderSpecifier<?>)qDaten.entfernung.desc())).orderBy((OrderSpecifier<?>)qNamen.namen.asc())).fetchFirst();
                double d = tuple.get(qDaten.entfernung);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("entferntester stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m350") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " ly";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskBiggestStar(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfter stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.durchmesser.gt(1000.0).and(qDaten.objektid.in((Collection<Integer>)list)))).orderBy((OrderSpecifier<?>)qDaten.durchmesser.desc())).fetchFirst();
                Double d = tuple.get(qDaten.durchmesser);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("gr\u00f6\u00dfter stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m351") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " Dsun";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskSmallestStar(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("kleinster stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.durchmesser.lt(0.5).and(qDaten.durchmesser.gt(0.0)).and(qDaten.objektid.in((Collection<Integer>)list)))).orderBy((OrderSpecifier<?>)qDaten.durchmesser.asc())).fetchFirst();
                double d = tuple.get(qDaten.durchmesser);
                String string = tuple.get(qNamen.namen);
                double d2 = 9.740838135735467;
                double d3 = (double)Math.round(d * d2 * 1000.0) / 1000.0;
                this.logger.debug("kleinster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m352") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " Dsun (" + this.i18n.toLocalisedDouble(d3) + " Djup)";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskMassiveStar(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfte sternmasse thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.masse.gt(100.0).and(qDaten.objektid.in((Collection<Integer>)list)))).orderBy((OrderSpecifier<?>)qDaten.masse.desc())).fetchFirst();
                Double d = tuple.get(qDaten.masse);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("schwerster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m353") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " Msun";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskLightlyStar(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("kleinste sternmasse thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.masse, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.masse.gt(0.0).and(qDaten.masse.lt(0.5)).and(qDaten.objektid.in((Collection<Integer>)list)))).orderBy((OrderSpecifier<?>)qDaten.masse.asc())).fetchFirst();
                double d = tuple.get(qDaten.masse);
                String string = tuple.get(qNamen.namen);
                double d2 = 1048.9989462592202;
                this.logger.debug("leichtester stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m354") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " Msun (" + this.i18n.toLocalisedDouble((double)Math.round(d2 * d * 1000.0) / 1000.0) + " Mjup)";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskGloomyStar(int n) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfte visuelle helligkeit stern thread started");
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.sh.gt(-25.0))))))).fetchFirst();
                Double d = tuple.get(qDaten.sh);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("schw\u00e4chster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m355") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " mag";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskBrightestStar(int n) {
        return () -> {
            this.logger.debug("kleinste visuelle helligkeit stern thread started");
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            long l = System.currentTimeMillis();
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.max()).from((Expression<?>)qDaten)).where(qDaten.sh.gt(25.0).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()))))))).fetchFirst();
                double d = tuple.get(qDaten.sh);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("hellster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m356") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " mag";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskBrightest2Star(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfte absolute helligkeit stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)list).and(qDaten.ah.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.ah.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list).and(qDaten.ah.gt(-100.0))))))).fetchFirst();
                Double d = tuple.get(qDaten.ah);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("hellster stern (ah) needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m357") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " mag";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskGloomy2Star(int n, List<Integer> list) {
        return () -> {
            this.logger.debug("kleinste absolute helligkeit stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)list).and(qDaten.ah.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.ah.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)list)))))).fetchFirst();
                double d = tuple.get(qDaten.ah);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("schw\u00e4chster stern  (ah) needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m358") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " mag";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskBluestStar(int n) {
        return () -> {
            this.logger.debug("blauster stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
                QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
                Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qSpektraltyp.id).from((Expression<?>)qSpektraltyp)).where(qSpektraltyp.typ.eq("O"))).fetchOne();
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qNamen.namen, qSpektraltyp2.typ}).from((Expression<?>)qDaten)).join((EntityPath)qSpektraltyp2)).on((Predicate)qDaten.spektralklasse2.eq(qSpektraltyp2.id))).leftJoin((EntityPath)qNamen)).on((Predicate)qNamen.datenid.eq(qDaten.id))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.spektralklasse.eq(n2)).and(qSpektraltyp2.typ.eq((Expression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(qSpektraltyp2.typ.min()).from((Expression<?>)qDaten)).join((EntityPath)qSpektraltyp2)).on((Predicate)qDaten.spektralklasse2.eq(qSpektraltyp2.id))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.spektralklasse.eq(n2))))))).fetchFirst();
                String string = tuple.get(qNamen.namen);
                this.logger.debug("blauster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m359") + ";" + string + ";O" + String.valueOf(tuple.get(qSpektraltyp2.typ));
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskRedestStar(int n) {
        return () -> {
            this.logger.debug("r\u00f6tester stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
            String string = null;
            try {
                double d = -1.0;
                for (double d2 = 9.5; d2 > -0.5; d2 -= 0.5) {
                    string = (String)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).join((EntityPath)qDaten)).on((Predicate)qNamen.datenid.eq(qDaten.id))).join((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).join((EntityPath)qSpektraltyp2)).on((Predicate)qDaten.spektralklasse2.eq(qSpektraltyp2.id))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qSpektraltyp.typ.eq("M")).and(qSpektraltyp2.typ.eq(d2)))).fetchFirst();
                    if (!Check.isFilled(string)) continue;
                    d = d2;
                    break;
                }
                this.logger.debug("r\u00f6tester stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m360") + ";" + string + ";M" + d;
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskLowestBvStar(int n) {
        return () -> {
            this.logger.debug("kleinste b-v stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.bv, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.bv.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.bv.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.bv.gt(-100.0))))))).fetchFirst();
                Double d = tuple.get(qDaten.bv);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("kleinste bv stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m361") + ";" + string + ";" + this.i18n.toLocalisedDouble(d);
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskHighestBvStar(int n) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfte b-v stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.bv, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.bv.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.bv.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))))).fetchFirst();
                double d = tuple.get(qDaten.bv);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("gr\u00f6\u00dfte bv stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m362") + ";" + string + ";" + this.i18n.toLocalisedDouble(d);
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskMetalPoorStar(int n) {
        return () -> {
            this.logger.debug("kleinste metallizit\u00e4t stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.metallizitaet.gt(-100.0).and(qDaten.metallizitaet.lt(-4.0)).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).orderBy((OrderSpecifier<?>)qDaten.metallizitaet.asc())).fetchFirst();
                Double d = tuple.get(qDaten.metallizitaet);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("metall\u00e4rmster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m365") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " Fe/H";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskMetalRichStar(int n) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfte metallizit\u00e4t stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.metallizitaet, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.metallizitaet.gt(2.0).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).orderBy((OrderSpecifier<?>)qDaten.metallizitaet.desc())).fetchFirst();
                double d = tuple.get(qDaten.metallizitaet);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("metallreichster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m366") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " Fe/H";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskLowestRadialVelocityStar(int n) {
        return () -> {
            this.logger.debug("kleinste radialgeschwindigkeit stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.geschwindigkeit, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.geschwindigkeit.lt(-300.0).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).orderBy((OrderSpecifier<?>)qDaten.geschwindigkeit.asc())).fetchFirst();
                Double d = tuple.get(qDaten.geschwindigkeit);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("kl. radialg. stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m368") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " km/s";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskHighestRadialVelocityStar(int n) {
        return () -> {
            this.logger.debug("gr\u00f6\u00dfte radialgeschwindigkeit stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.geschwindigkeit, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.geschwindigkeit.gt(600.0).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).orderBy((OrderSpecifier<?>)qDaten.geschwindigkeit.desc())).fetchFirst();
                double d = tuple.get(qDaten.geschwindigkeit);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("gr\u00f6\u00dfte radialg. stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m367") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " km/s";
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskJungestStar(int n) {
        return () -> {
            this.logger.debug("j\u00fcngster stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                QObjektalter qObjektalter = QObjektalter.objektalter;
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qObjektalter.alter, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qObjektalter)).on((Predicate)qDaten.id.eq(qObjektalter.datenid))).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qObjektalter.alter.eq((Expression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(qObjektalter.alter.min()).from((Expression<?>)qObjektalter)).join((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qObjektalter.alter.gt(0.0).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).fetchFirst();
                Double d = tuple.get(qObjektalter.alter);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("j\u00fcngster stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m369") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " " + this.i18n.getString("db_m125");
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskOldestStar(int n) {
        return () -> {
            this.logger.debug("\u00e4ltester stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            QObjektalter qObjektalter = QObjektalter.objektalter;
            try {
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qObjektalter.alter, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qObjektalter)).on((Predicate)qDaten.id.eq(qObjektalter.datenid))).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qObjektalter.alter.eq((Expression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(qObjektalter.alter.max()).from((Expression<?>)qObjektalter)).join((EntityPath)qDaten)).on((Predicate)qObjektalter.datenid.eq(qDaten.id))).where(qObjektalter.alter.gt(0.0).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).fetchFirst();
                Double d = tuple.get(qObjektalter.alter);
                String string = tuple.get(qNamen.namen);
                this.logger.debug("\u00e4ltester stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m370") + ";" + string + ";" + this.i18n.toLocalisedDouble(d) + " " + this.i18n.getString("db_m125");
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskStarWithMostPlanets(int n) {
        return () -> {
            this.logger.debug("stern mit meisten planeten thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                NumberPath<Long> numberPath = Expressions.numberPath(Long.class, "anzahl");
                Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.zugehoerigkeit, qDaten.zugehoerigkeit.count().as(numberPath)}).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsPlaneten()).and(qDaten.zugehoerigkeit.ne((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne")))))).groupBy((Expression<?>)qDaten.zugehoerigkeit)).orderBy((OrderSpecifier<?>)numberPath.desc())).fetchFirst();
                int n2 = tuple.get(qDaten.zugehoerigkeit);
                long l2 = tuple.get(numberPath);
                this.logger.debug(" stern mit meisten planeten needs " + (System.currentTimeMillis() - l) + " ms");
                String string = this.i18n.getString("db_m371") + ";" + this.objektnamenRepository.getNamenByDatenId(n2, ObjektnamenSortierung.BEKANNTHEIT).get(0) + ";" + l2 + " " + this.i18n.getString("db_m340");
                this.addErgebnis(n, string);
                return Pair.of(n, string);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskStarWithMostComponents(int n) {
        return () -> {
            this.logger.debug("stern mit meisten komponenten thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            try {
                String[] stringArray = new String[]{"L", "K", "J", "I", "H", "G"};
                int n2 = 0;
                String string = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).where(qNamen.namen.like("CCDM J%" + stringArray[i]))).fetchFirst();
                    if (!Check.isFilled(string)) continue;
                    n2 = 12 - i;
                    break;
                }
                this.logger.debug("mehrfach stern needs " + (System.currentTimeMillis() - l) + " ms");
                String string2 = this.i18n.getString("db_m372") + ";" + string + ";" + n2 + " " + this.i18n.getString("db_m305");
                this.addErgebnis(n, string2);
                return Pair.of(n, string2);
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                return Pair.of(n, "");
            }
        };
    }

    private Callable<Pair<Integer, String>> createTaskColdestAndHottestStar(int n, int n2) {
        return () -> {
            this.logger.debug("kleinste&gr\u00f6\u00dfte temperatur stern thread started");
            long l = System.currentTimeMillis();
            QNamen qNamen = QNamen.namen1;
            QDaten qDaten = QDaten.daten;
            try {
                List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.temperatur, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.temperatur.in(SQLExpressions.union((SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.temperatur.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.temperatur.gt(0.0))), (SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.temperatur.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne()).and(qDaten.temperatur.gt(0.0))))).and(qDaten.objektid.in((Collection<Integer>)this.cacheDao.getObjekttypenidsSterne())))).fetch();
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                for (Tuple tuple : list) {
                    Double d = tuple.get(qDaten.temperatur);
                    String string3 = tuple.get(qNamen.namen);
                    if (d > 100000.0 && !bl) {
                        string = this.i18n.getString("db_m364") + ";" + string3 + ";" + this.i18n.toLocalisedDouble(d) + " " + this.i18n.getString("db_m114");
                        bl = true;
                    } else if (d < 5000.0 && !bl2) {
                        string2 = this.i18n.getString("db_m363") + ";" + string3 + ";" + this.i18n.toLocalisedDouble(d) + " " + this.i18n.getString("db_m114");
                        bl2 = true;
                    }
                    if (!bl || !bl2) continue;
                    break;
                }
                this.addErgebnis(n, string2);
                this.addErgebnis(n2, string);
                this.logger.debug("k\u00fchlster&hei\u00dftester stern needs " + (System.currentTimeMillis() - l) + " ms");
                return Pair.of(n, "");
            }
            catch (RuntimeException runtimeException) {
                this.logger.error(runtimeException);
                this.addErgebnis(n, "");
                this.addErgebnis(n2, "");
                return Pair.of(n, "");
            }
        };
    }

    private void collectData() throws SQLException, InterruptedException, ExecutionException {
        this.startCalc = System.currentTimeMillis();
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.in("Supernova Typ Ia", "Supernova Typ II"))).fetch();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.cacheDao.getObjekttypenidsSterne());
        arrayList.removeAll(list);
        ArrayList<Callable<Pair<Integer, String>>> arrayList2 = new ArrayList<Callable<Pair<Integer, String>>>();
        arrayList2.add(this.createTaskNearestStar(1));
        arrayList2.add(this.createTaskAwayestStar(2, arrayList));
        arrayList2.add(this.createTaskBiggestStar(3, arrayList));
        arrayList2.add(this.createTaskSmallestStar(4, arrayList));
        arrayList2.add(this.createTaskMassiveStar(5, arrayList));
        arrayList2.add(this.createTaskLightlyStar(6, arrayList));
        arrayList2.add(this.createTaskGloomyStar(7));
        arrayList2.add(this.createTaskBrightestStar(8));
        arrayList2.add(this.createTaskBrightest2Star(9, arrayList));
        arrayList2.add(this.createTaskGloomy2Star(10, arrayList));
        arrayList2.add(this.createTaskBluestStar(11));
        arrayList2.add(this.createTaskRedestStar(12));
        arrayList2.add(this.createTaskLowestBvStar(13));
        arrayList2.add(this.createTaskHighestBvStar(14));
        arrayList2.add(this.createTaskColdestAndHottestStar(15, 16));
        arrayList2.add(this.createTaskMetalPoorStar(17));
        arrayList2.add(this.createTaskMetalRichStar(18));
        arrayList2.add(this.createTaskLowestRadialVelocityStar(19));
        arrayList2.add(this.createTaskHighestRadialVelocityStar(20));
        arrayList2.add(this.createTaskJungestStar(21));
        arrayList2.add(this.createTaskOldestStar(22));
        arrayList2.add(this.createTaskStarWithMostPlanets(23));
        arrayList2.add(this.createTaskStarWithMostComponents(24));
        arrayList2.forEach(callable -> {
            try {
                callable.call();
            }
            catch (Exception exception) {
                this.logger.error(exception);
            }
        });
        this.logger.debug("sterne threads finished");
    }

    private void addErgebnis(int n, String string) {
        this.sortedResult.put(n, string);
        this.logger.trace("id: " + n);
        if (this.sortedResult.size() >= 24) {
            this.sortedResult.entrySet().forEach(entry -> this.ergebnis.add((String)entry.getValue()));
            this.logger.debug("collect star data needs " + (System.currentTimeMillis() - this.startCalc) + " ms");
            this.observer.addErgebnis(this.ergebnis, 5);
        }
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

