/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SternhaufenRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 7;
    private final List<String> ergebnis = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;

    public SternhaufenRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.STERNHAUFEN.getKategorienName());
            if (n <= 0) {
                return;
            }
            long l = System.currentTimeMillis();
            QDaten qDaten = QDaten.daten;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QNamen qNamen = QNamen.namen1;
            Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Offener Sternhaufen"))).fetchOne();
            Integer n3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Kugelsternhaufen"))).fetchOne();
            long l2 = System.currentTimeMillis();
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n2).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.logger.debug("n\u00e4hster OS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m379") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " ly");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n2).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.logger.debug("entferntester OS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m380") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " ly");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n2).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.durchmesser.gt(0.0))))))).fetchFirst();
            this.logger.debug("kleinster OS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m381") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.durchmesser)) + "'");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n2).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.durchmesser.gt(0.0))))))).fetchFirst();
            this.logger.debug("gr\u00f6\u00dfter OS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m382") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.durchmesser)) + "'");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n2).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.sh.gt(-100.0))))))).fetchFirst();
            this.logger.debug("hellster OS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m383") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.sh)) + " mag");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n2).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n2).and(qDaten.sh.gt(-100.0))))))).fetchFirst();
            this.logger.debug("dunkelster OS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m384") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.sh)) + " mag");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n3).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.logger.debug("n\u00e4hster KS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m385") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " ly");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n3).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.logger.debug("entferntester KS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m386") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " ly");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n3).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.durchmesser.gt(0.0))))))).fetchFirst();
            this.logger.debug("kleinster KS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m387") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.durchmesser)) + "'");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.durchmesser, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n3).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.durchmesser.gt(0.0))))))).fetchFirst();
            this.logger.debug("gr\u00f6\u00dfter KS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m388") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.durchmesser)) + "'");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n3).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.sh.gt(-100.0))))))).fetchFirst();
            this.logger.debug("hellster KS: " + (System.currentTimeMillis() - l2) + " ms");
            l2 = System.currentTimeMillis();
            this.ergebnis.add(this.i18n.getString("db_m389") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.sh)) + " mag");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.eq(n3).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.eq(n3).and(qDaten.sh.gt(-100.0))))))).fetchFirst();
            this.logger.debug("dunkelster KS: " + (System.currentTimeMillis() - l2) + " ms");
            this.ergebnis.add(this.i18n.getString("db_m390") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.sh)) + " mag");
            this.logger.debug("collect star cluster data needs " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.ergebnis, 7);
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

