/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.menuextras.rekorde;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class SupernovaRekordeDAOThread
implements Callable<Void> {
    private static final int AUFRUFER_ID = 6;
    private final List<String> ergebnis = new ArrayList<String>();
    private final ILogging logger;
    private final IRekordeDAOObserver observer;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;

    public SupernovaRekordeDAOThread(ISprachcontainer iSprachcontainer, IRekordeDAOObserver iRekordeDAOObserver, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder) {
        this.observer = iRekordeDAOObserver;
        this.i18n = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = iKategorienRepository;
        this.datenbankverbinder = iDatenbankverbinder;
    }

    public void run() {
        try {
            int n = this.kategorienRepository.getAnzahl(ObjektKategorie.STERNE.getKategorienName());
            if (n <= 0) {
                return;
            }
            long l = System.currentTimeMillis();
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.in("Supernova Typ Ia", "Supernova Typ II"))).fetch();
            QDaten qDaten = QDaten.daten;
            QNamen qNamen = QNamen.namen1;
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in(list).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list).and(qDaten.entfernung.gt(0.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m373") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " ly");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.entfernung, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in(list).and(qDaten.entfernung.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.entfernung.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list)))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m374") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.entfernung)) + " ly");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in(list).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list).and(qDaten.sh.gt(-100.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m375") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.sh)) + " mag");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.sh, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in(list).and(qDaten.sh.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.sh.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list)))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m376") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.sh)) + " mag");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in(list).and(qDaten.ah.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.ah.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list).and(qDaten.ah.gt(-100.0))))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m377") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.ah)) + " mag");
            tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qNamen.namen}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in(list).and(qDaten.ah.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.ah.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list)))))).fetchFirst();
            this.ergebnis.add(this.i18n.getString("db_m378") + ";" + tuple.get(qNamen.namen) + ";" + this.i18n.toLocalisedDouble(tuple.get(qDaten.ah)) + " mag");
            this.logger.debug("collect supernova data needs " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
        }
        this.observer.addErgebnis(this.ergebnis, 6);
    }

    @Override
    public Void call() throws Exception {
        this.run();
        return null;
    }
}

