/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.notizen;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.INotizenRepository;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class NotizenService
implements INotizenService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final INotizenRepository notizenRepo;

    @Inject
    public NotizenService(IDatenbankverbinder iDatenbankverbinder, INotizenRepository iNotizenRepository) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.notizenRepo = iNotizenRepository;
    }

    @Override
    public List<String> findObjekteMitNotiz(String string) {
        try {
            QNotizen qNotizen = QNotizen.notizen;
            QNamen qNamen = QNamen.namen1;
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).rightJoin((EntityPath)qNotizen)).on((Predicate)qNamen.datenid.eq(qNotizen.datenid))).where(qNotizen.notiz.contains(string))).fetch();
        }
        catch (Exception exception) {
            this.logger.error(exception);
            return new ArrayList<String>();
        }
    }

    @Override
    public void saveNotiz(IPlanetensucheObjekt iPlanetensucheObjekt, String string) {
        if (iPlanetensucheObjekt == null || iPlanetensucheObjekt.getDatenid() == null) {
            throw new IllegalArgumentException("datenid is required");
        }
        if (Check.isEmpty(string)) {
            return;
        }
        try {
            this.notizenRepo.save(iPlanetensucheObjekt.getDatenid(), string);
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
    }

    @Override
    public long countNotizen() {
        try {
            return this.notizenRepo.countAll();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return -1L;
        }
    }

    @Override
    public String getByDatenid(Integer n) {
        try {
            String string = this.notizenRepo.getByDatenid(n);
            return string != null ? string : "";
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            return "";
        }
    }
}

