/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QGaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GaiaRvDataAnalysisService {
    private final QDaten qDaten = QDaten.daten;
    private final QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
    private final QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDAO;

    public GaiaRvDataAnalysisService(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDAO = iIdCacheDAO;
    }

    public int getPercentOfEbsWithHigherRvError(double d) {
        List<Double> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qGaiaStars.rvError).from((Expression<?>)this.qGaiaStars)).join((EntityPath)this.qDaten)).on((Predicate)this.qDaten.id.eq(this.qGaiaStars.datenid))).where(this.qGaiaStars.rvError.isNotNull().and(this.qDaten.objektid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.typ.eq(StarObjectType.ECLIPSING_BINARY.getTypeName())))))).fetch();
        if (list.isEmpty()) {
            return -1;
        }
        return this.percentWithHigherValue(d, list);
    }

    public int getPercentOfStarsWithExoplanetsWithHigherRvError(double d) {
        List<Double> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qGaiaStars.rvError).from((Expression<?>)this.qGaiaStars)).where(this.qGaiaStars.rvError.isNotNull().and(this.qGaiaStars.datenid.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDAO.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.isNotNull())))))).fetch();
        if (list.isEmpty()) {
            return -1;
        }
        return this.percentWithHigherValue(d, list);
    }

    private int percentWithHigherValue(double d, List<Double> list) {
        Collections.sort(list);
        int n = 0;
        for (Double d2 : list) {
            if (d2 > d) break;
            ++n;
        }
        if (n == 0) {
            return 100;
        }
        double d3 = (double)(list.size() - n) * 100.0 / (double)list.size();
        return (int)Math.round(d3);
    }
}

