/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.datenbank.doublestar.queries.EclipsingBinaryCatalogDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.util.List;

public class KeplerEbCatalogService {
    private final String baseUrl = "https://keplerebs.villanova.edu/overview/?k=";
    private final int timeoutInMs = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public EclipsingBinaryCatalogDto findEntry(String string) {
        EclipsingBinaryCatalogDto eclipsingBinaryCatalogDto = new EclipsingBinaryCatalogDto();
        try {
            String string2 = string.startsWith("KIC ") ? string.substring(4).trim() : string.trim();
            String string3 = "https://keplerebs.villanova.edu/overview/?k=" + string2;
            eclipsingBinaryCatalogDto.setLink(string3);
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string3, 10000);
            for (String string4 : list) {
                if (string4.contains("1 ephemeris in the catalog:") || string4.contains("2 ephemeris in the catalog:") || string4.contains("3 ephemeris in the catalog:")) {
                    eclipsingBinaryCatalogDto.setEntryStatus(IconPoolCustom.AMPEL_GRUEN);
                    return eclipsingBinaryCatalogDto;
                }
                if (string4.contains("This entry is not currently in the EB Catalog") || string4.contains("No entries found.") || string4.contains("0 ephemerides in the catalog:") || string4.contains("0 ephemeris in the catalog:") || string4.contains("This entry is not currently in the EB Catalog")) {
                    eclipsingBinaryCatalogDto.setEntryStatus(IconPoolCustom.AMPEL_ROT);
                    return eclipsingBinaryCatalogDto;
                }
                if (!string4.contains("ephemeris in the catalog:")) continue;
                this.logger.warn("found unexpected result in Kepler EB catalog for " + string);
                eclipsingBinaryCatalogDto.setEntryStatus(IconPoolCustom.AMPEL_GELB);
                return eclipsingBinaryCatalogDto;
            }
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error("input=" + string, exception);
        }
        this.logger.warn("error or found nothing in the Kepler EB result page for " + string);
        eclipsingBinaryCatalogDto.setEntryStatus(IconPoolCustom.AMPEL_GELB);
        return eclipsingBinaryCatalogDto;
    }
}

