/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbank.doublestar.queries.PlanetensucheResponseDto;
import de.planetensuche.datenbank.doublestar.queries.SesameResponseDto;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;

public class PlanetensucheSearchService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IObjekttypenRepository objekttypenRepository;
    private final IObjektnamenRepository objektnamenRepository;

    public PlanetensucheSearchService(IObjekttypenRepository iObjekttypenRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.objekttypenRepository = iObjekttypenRepository;
        this.objektnamenRepository = iObjektnamenRepository;
    }

    public Optional<PlanetensucheResponseDto> queryPlanetensuche(String string, Optional<SesameResponseDto> optional) {
        try {
            Object object;
            Object object2;
            Object object3;
            String string2 = null;
            String string3 = this.objekttypenRepository.getObjekttypFuerObjekt(string);
            if (string3 == null) {
                if (optional.isEmpty()) {
                    return Optional.empty();
                }
                object3 = optional.get().getNames();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    string3 = this.objekttypenRepository.getObjekttypFuerObjekt((String)object);
                    if (string3 == null) continue;
                    string2 = object;
                    break;
                }
                if (string3 == null) {
                    return Optional.empty();
                }
            } else {
                string2 = string;
            }
            object3 = new PlanetensucheResponseDto();
            ((PlanetensucheResponseDto)object3).setObjectType(string3);
            object2 = StarObjectType.parse(string3);
            if (((Optional)object2).isEmpty()) {
                this.logger.warn("no star type detected for input '" + string3 + "'");
                ((PlanetensucheResponseDto)object3).setIsDoubleStar(IconPoolCustom.AMPEL_ROT);
            } else {
                switch ((StarObjectType)((Object)((Optional)object2).get())) {
                    case DOUBLE_STAR_REAL: 
                    case MULTI_STAR_SYSTEM: 
                    case ECLIPSING_BINARY: {
                        ((PlanetensucheResponseDto)object3).setIsDoubleStar(IconPoolCustom.AMPEL_GRUEN);
                        break;
                    }
                    case SINGLE_STAR: {
                        ((PlanetensucheResponseDto)object3).setIsDoubleStar(IconPoolCustom.AMPEL_GELB);
                        break;
                    }
                    default: {
                        ((PlanetensucheResponseDto)object3).setIsDoubleStar(IconPoolCustom.AMPEL_ROT);
                    }
                }
            }
            object = this.objektnamenRepository.readDatenid(string2);
            HashSet<String> hashSet = new HashSet<String>(this.objektnamenRepository.getNamenByDatenId((Integer)object, ObjektnamenSortierung.KEINE_SORTIERUNG));
            ((PlanetensucheResponseDto)object3).setPlanetensucheStarNames(hashSet);
            return Optional.of(object3);
        }
        catch (SQLException sQLException) {
            this.logger.error("error while fetching object type for TIC " + string + " from Planetensuche", sQLException);
            return Optional.empty();
        }
    }
}

