/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.SesameResponseDto;
import de.planetensuche.datenbank.doublestar.queries.SimbadObjectType2ReadableNameMapper;
import de.planetensuche.datenbank.tic.VizierTicCatalogDto;
import de.planetensuche.datenbank.tic.VizierTicCatalogQueryService;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class SesameService {
    private final String baseUrl = "https://cds.unistra.fr/cgi-bin/nph-sesame/-oI/SV?";
    private final int timeoutInMs = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final VizierTicCatalogQueryService vizierTicService = new VizierTicCatalogQueryService();

    public Optional<SesameResponseDto> querySesame(String string) throws UnknownHostException {
        try {
            String string2 = "https://cds.unistra.fr/cgi-bin/nph-sesame/-oI/SV?" + string.replaceAll(" ", "%20");
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string2, 10000);
            if (Check.isFilled(list)) {
                SesameResponseDto sesameResponseDto = this.createSesameResultDto(list, string);
                return Optional.of(sesameResponseDto);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
        }
        return Optional.empty();
    }

    public Optional<SesameResponseDto> querySesame(long l) throws UnknownHostException {
        try {
            Object object;
            String string = "https://cds.unistra.fr/cgi-bin/nph-sesame/-oI/SV?TIC%20" + l;
            SesameResponseDto sesameResponseDto = new SesameResponseDto();
            try {
                object = UrlQueryUtil.getListResponseFromUrlQuery(string, 10000);
                if (Check.isFilled(object)) {
                    sesameResponseDto = this.createSesameResultDto((List<String>)object, "TIC " + l);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            try {
                List<String> list;
                object = this.vizierTicService.findByTicId(l);
                if (Check.isEmpty(sesameResponseDto.getSimbadObjectType()) && ((Optional)object).isPresent() && Check.isFilled(((VizierTicCatalogDto)((Optional)object).get()).getGaiaDr2Id()) && Check.isFilled(list = UrlQueryUtil.getListResponseFromUrlQuery(string = "https://cds.unistra.fr/cgi-bin/nph-sesame/-oI/SV?Gaia%20DR2%20" + ((VizierTicCatalogDto)((Optional)object).get()).getGaiaDr2Id(), 10000))) {
                    sesameResponseDto = this.createSesameResultDto(list, "Gaia DR2 " + ((VizierTicCatalogDto)((Optional)object).get()).getGaiaDr2Id());
                }
                sesameResponseDto = this.mergeSesameAndVizier(sesameResponseDto, (Optional<VizierTicCatalogDto>)object);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            return Optional.ofNullable(sesameResponseDto);
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }

    private SesameResponseDto createSesameResultDto(List<String> list, String string) {
        SesameResponseDto sesameResponseDto = new SesameResponseDto();
        sesameResponseDto.setNames(new HashSet<String>());
        for (String string2 : list) {
            try {
                if (string2.startsWith("%I ")) {
                    sesameResponseDto.getNames().add(string2.substring(3).trim());
                    continue;
                }
                if (!string2.startsWith("%C.0 ")) continue;
                this.setSimbadObjectType(string2, sesameResponseDto);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.logger.error("Simbad result: '" + string2 + "'", indexOutOfBoundsException);
            }
        }
        if (Check.isFilled(sesameResponseDto.getNames())) {
            sesameResponseDto.setSimbadLink("https://simbad.u-strasbg.fr/simbad/sim-id?Ident=" + string.replaceAll(" ", "%20"));
            for (String string2 : sesameResponseDto.getNames()) {
                if (!string2.startsWith("Gaia DR2 ")) continue;
                sesameResponseDto.setGaiaName(string2);
                break;
            }
            if (Check.isEmpty(sesameResponseDto.getGaiaName())) {
                for (String string2 : sesameResponseDto.getNames()) {
                    if (!string2.startsWith("Gaia DR3 ")) continue;
                    sesameResponseDto.setGaiaName(string2);
                    break;
                }
            }
        }
        return sesameResponseDto;
    }

    private void setSimbadObjectType(String string, SesameResponseDto sesameResponseDto) {
        String string2 = string.substring(5).trim();
        sesameResponseDto.setSimbadObjectTypeShort(string2);
        try {
            sesameResponseDto.setSimbadObjectType(SimbadObjectType2ReadableNameMapper.getStarTypeName(string2));
        }
        catch (IOException iOException) {
            this.logger.error("Simbad result: '" + string + "'", iOException);
            sesameResponseDto.setSimbadObjectType(string2);
        }
    }

    private SesameResponseDto mergeSesameAndVizier(SesameResponseDto sesameResponseDto, Optional<VizierTicCatalogDto> optional) {
        SesameResponseDto sesameResponseDto2;
        if (sesameResponseDto == null && optional.isEmpty()) {
            return null;
        }
        SesameResponseDto sesameResponseDto3 = sesameResponseDto2 = sesameResponseDto != null ? sesameResponseDto : new SesameResponseDto();
        if (sesameResponseDto2.getNames() == null) {
            sesameResponseDto2.setNames(new HashSet<String>());
        }
        if (optional.isPresent()) {
            VizierTicCatalogDto vizierTicCatalogDto = optional.get();
            sesameResponseDto2.getNames().add("TIC " + vizierTicCatalogDto.getTicId());
            if (vizierTicCatalogDto.getGaiaDr2Id() != null) {
                String string = "Gaia DR2 " + vizierTicCatalogDto.getGaiaDr2Id();
                sesameResponseDto2.setGaiaName(string);
                sesameResponseDto2.getNames().add(string);
            }
            if (vizierTicCatalogDto.getHipId() != null) {
                sesameResponseDto2.getNames().add("HIP " + vizierTicCatalogDto.getHipId());
            }
            if (vizierTicCatalogDto.getKicId() != null) {
                sesameResponseDto2.getNames().add("KIC " + vizierTicCatalogDto.getKicId());
            }
            if (vizierTicCatalogDto.getSdssDr9Id() != null) {
                sesameResponseDto2.getNames().add("SDSS DR9 " + vizierTicCatalogDto.getSdssDr9Id());
            }
            if (vizierTicCatalogDto.getTwoMassId() != null) {
                sesameResponseDto2.getNames().add("2MASS " + vizierTicCatalogDto.getTwoMassId());
            }
            if (vizierTicCatalogDto.getTyc2Id() != null) {
                sesameResponseDto2.getNames().add("TYC " + vizierTicCatalogDto.getTyc2Id());
            }
            if (vizierTicCatalogDto.getUcac4Id() != null) {
                sesameResponseDto2.getNames().add("UCAC4 " + vizierTicCatalogDto.getUcac4Id());
            }
            if (vizierTicCatalogDto.getWiseaId() != null) {
                sesameResponseDto2.getNames().add("WISE " + vizierTicCatalogDto.getWiseaId());
            }
        }
        return sesameResponseDto2;
    }
}

