/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.CorotBinaryDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierCorotBinariesService {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20%22CoRoT-ID%22,Per%20FROM%20%22J/A%2bA/602/A117/table1%22%20WHERE%20%22CoRoT-ID%22=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/A%2bA/602/A117/table1&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<CorotBinaryDto> query(String string) {
        if (Check.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            String string2 = BASE_URL + string;
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string2, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            CorotBinaryDto corotBinaryDto = new CorotBinaryDto();
            if (!Check.isFilled(map.get("CoRoT-ID"))) {
                this.logger.warn("query Vizier for CoRoT binary catalog ok but no id found for '" + string + "'?");
                return Optional.empty();
            }
            corotBinaryDto.setCorotId(Long.parseLong(map.get("CoRoT-ID")));
            if (Check.isFilled(map.get("Per"))) {
                corotBinaryDto.setPeriodInDays(Double.valueOf(map.get("Per")));
            }
            corotBinaryDto.setLink(LINK_URL);
            corotBinaryDto.setStatus(IconPoolCustom.AMPEL_GRUEN);
            return Optional.of(corotBinaryDto);
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }
}

