/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.GalahSurveyDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierGalahSurveySb2Service {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20spectID,ruwe%20FROM%20%22J/A%2bA/638/A145/catalog%22%20WHERE%20gaiadr2=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/A%2bA/638/A145/catalog&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<GalahSurveyDto> query(String string) {
        try {
            String string2 = string.split(" ")[2];
            String string3 = BASE_URL + string2;
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string3, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            GalahSurveyDto galahSurveyDto = new GalahSurveyDto();
            if (!Check.isFilled(map.get("spectID"))) {
                this.logger.warn("query Vizier for GALAH survey ok but no id found for '" + string + "'?");
                return Optional.empty();
            }
            galahSurveyDto.setId(map.get("spectID"));
            galahSurveyDto.setRuwe(map.get("RUWE"));
            galahSurveyDto.setLink(LINK_URL);
            galahSurveyDto.setStatus(IconPoolCustom.AMPEL_GRUEN);
            return Optional.of(galahSurveyDto);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }
}

