/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.KeltFalsePositiveDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierKeltFalsePositiveService {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20KELT,FName,Per%20FROM%20%22J/AJ/156/234/table4%22%20WHERE%20TIC=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/AJ/156/234/table4&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<KeltFalsePositiveDto> query(String string) {
        if (Check.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            String string2 = BASE_URL + string;
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string2, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            KeltFalsePositiveDto keltFalsePositiveDto = new KeltFalsePositiveDto();
            if (!Check.isFilled(map.get("KELT"))) {
                this.logger.warn("query Vizier for KELT false-positive catalog ok but no KELT id found for 'TIC " + string + "'?");
                return Optional.empty();
            }
            keltFalsePositiveDto.setKeltName(map.get("KELT"));
            String string3 = map.get("FName");
            keltFalsePositiveDto.setType(this.mapToName(string3));
            if (Check.isFilled(map.get("Per"))) {
                keltFalsePositiveDto.setPeriodInDays(Double.valueOf(map.get("Per")));
            }
            keltFalsePositiveDto.setLink(LINK_URL);
            if (this.isTypeEclipsingBinary(string3)) {
                keltFalsePositiveDto.setStatus(IconPoolCustom.AMPEL_GRUEN);
            } else {
                keltFalsePositiveDto.setStatus(IconPoolCustom.AMPEL_GELB);
            }
            return Optional.of(keltFalsePositiveDto);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }

    private String mapToName(String string) {
        switch (string) {
            case "SB1": {
                return "Single-lined binary (RV>1km/s)";
            }
            case "SB2": {
                return "Multi-lined binary";
            }
            case "RV0": {
                return "No significant RV detected";
            }
            case "Giant": {
                return "Spectroscopic Giant";
            }
            case "EB1": {
                return "Too deep in follow-up";
            }
            case "EB2": {
                return "Different primary and secondary depths";
            }
            case "BEB": {
                return "Blend in follow-up aper. (chromaticity)";
            }
            case "Variable": {
                return "Variable star caused KELT detection";
            }
            case "NEB": {
                return "Nearby EB (blend in KELT aperture)";
            }
        }
        return string;
    }

    private boolean isTypeEclipsingBinary(String string) {
        switch (string) {
            case "SB1": 
            case "SB2": 
            case "EB1": 
            case "EB2": {
                return true;
            }
        }
        return false;
    }
}

