/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.SuperWaspFalsePositiveDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierSuperWaspFalsePositiveService {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20swasp,flag,ffollowup%20FROM%20%22J/MNRAS/488/4905/table2%22%20WHERE%20tess=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/MNRAS/488/4905/table2&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<SuperWaspFalsePositiveDto> querySuperWasp(long l) {
        try {
            String string = BASE_URL + l + ".0";
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            SuperWaspFalsePositiveDto superWaspFalsePositiveDto = new SuperWaspFalsePositiveDto();
            if (!Check.isFilled(map.get("SWASP"))) {
                this.logger.warn("query Vizier for SuperWasp catalog ok but no id found for TIC " + l + "?");
                return Optional.empty();
            }
            superWaspFalsePositiveDto.setSuperWaspName(map.get("SWASP"));
            if (Check.isFilled(map.get("Flag"))) {
                superWaspFalsePositiveDto.setFlag(this.mapToFlagText(map.get("Flag")));
            }
            if (Check.isFilled(map.get("Ffollowup"))) {
                superWaspFalsePositiveDto.setFollowupFlag(this.mapToFollowUpFlagText(map.get("Ffollowup")));
            } else {
                superWaspFalsePositiveDto.setFollowupFlag("");
            }
            superWaspFalsePositiveDto.setLink(LINK_URL);
            if (this.isEclipsingBinary(map.get("Flag"), map.get("Ffollowup"))) {
                superWaspFalsePositiveDto.setFlagStatus(IconPoolCustom.AMPEL_GRUEN);
            } else {
                superWaspFalsePositiveDto.setFlagStatus(IconPoolCustom.AMPEL_GELB);
            }
            return Optional.of(superWaspFalsePositiveDto);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }

    private String mapToFlagText(String string) {
        switch (string) {
            case "EB": {
                return "Eclipsing binary";
            }
            case "Blend": {
                return "Blend with nearby Star(s)";
            }
            case "EBLM": {
                return "Low Mass Companion";
            }
            case "V": {
                return "Variable Star";
            }
            case "X": {
                return "False Detection";
            }
            case "RAF": {
                return "Rejected after follow-up";
            }
        }
        return string;
    }

    private String mapToFollowUpFlagText(String string) {
        return switch (string) {
            case "SB1" -> "Single lines eclipsing binary (spectral)";
            case "SB2" -> "Double lined eclipsing binary (spectral)";
            case "LB" -> "Line bissector variations (spectral)";
            case "RR" -> "Rapid rotator, generally FWHM > 8km^s";
            case "G" -> "Giant star";
            case "BEB" -> "blended eclipsing binary";
            case "FP" -> "Non-astrophysical false positive";
            case "O" -> "Other";
            default -> string;
        };
    }

    private boolean isEclipsingBinary(String string, String string2) {
        if ("EB".equals(string) || "EBLM".equals(string)) {
            return true;
        }
        return "SB1".equals(string2) || "SB2".equals(string2);
    }
}

