/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.EclipsingBinaryCatalogDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierTessEbCatalogService {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20TIC,Per%20FROM%20%22J/ApJS/258/16/tess-ebs%22%20WHERE%20TIC=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/ApJS/258/16&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<EclipsingBinaryCatalogDto> query(String string) {
        if (Check.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            String string2 = BASE_URL + string;
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string2, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            EclipsingBinaryCatalogDto eclipsingBinaryCatalogDto = new EclipsingBinaryCatalogDto();
            if (Check.isEmpty(map.get("TIC"))) {
                this.logger.warn("query Vizier for TESS EB catalog ok but no id found for 'TIC " + string + "'?");
                return Optional.empty();
            }
            if (Check.isFilled(map.get("Per"))) {
                eclipsingBinaryCatalogDto.setPeriodInDays(Double.valueOf(map.get("Per")));
            }
            eclipsingBinaryCatalogDto.setLink(LINK_URL);
            eclipsingBinaryCatalogDto.setEntryStatus(IconPoolCustom.AMPEL_GRUEN);
            return Optional.of(eclipsingBinaryCatalogDto);
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }
}

