/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.EclipsingBinaryCatalogDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierTessOBAtypeEbCatalogService {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20TIC,eclPer%20FROM%20%22J/A%2bA/652/A120/eb-cat%22%20WHERE%20TIC=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/A%2bA/652/A120/eb-cat&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<EclipsingBinaryCatalogDto> query(String string) {
        if (Check.isEmpty(string)) {
            return Optional.empty();
        }
        try {
            double d;
            String string2 = BASE_URL + string;
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string2, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                this.logger.debug("no data found for TIC " + string);
                return Optional.empty();
            }
            EclipsingBinaryCatalogDto eclipsingBinaryCatalogDto = new EclipsingBinaryCatalogDto();
            if (Check.isEmpty(map.get("TIC"))) {
                this.logger.warn("query Vizier for TESS EB catalog ok but no id found for 'TIC " + string + "'?");
                return Optional.empty();
            }
            if (Check.isFilled(map.get("eclPer")) && (d = Double.parseDouble(map.get("eclPer"))) > 0.0) {
                eclipsingBinaryCatalogDto.setPeriodInDays(d);
            }
            eclipsingBinaryCatalogDto.setLink(LINK_URL);
            eclipsingBinaryCatalogDto.setEntryStatus(IconPoolCustom.AMPEL_GRUEN);
            return Optional.of(eclipsingBinaryCatalogDto);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }
}

