/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.doublestar.queries;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.doublestar.queries.VivaceDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.datenbank.vizier.VotTableParser;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VizierVivaceCatalogService {
    private static final String BASE_URL = "https://tapvizier.u-strasbg.fr/TAPVizieR/tap/sync?request=doQuery&lang=ADQL&query=SELECT%20VIVACE,Class,Period%20FROM%20%22J/MNRAS/509/2566/vivace%22%20WHERE%20GaiaEDR3=";
    private static final String LINK_URL = "https://vizier.cds.unistra.fr/viz-bin/VizieR-3?-source=J/MNRAS/509/2566/vivace&-out.max=50&-out.form=HTML%20Table&-out.add=_r&-out.add=_RAJ,_DEJ&-sort=_r&-oc.form=sexa";
    private static final int TIMEOUT_IN_MS = 10000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<VivaceDto> query(long l) {
        if (l <= 0L) {
            return Optional.empty();
        }
        try {
            String string = BASE_URL + l;
            List<String> list = UrlQueryUtil.getListResponseFromUrlQuery(string, 10000);
            VotTableParser votTableParser = new VotTableParser();
            Map<String, String> map = votTableParser.parseKeysAndValues(list);
            if (map.isEmpty()) {
                return Optional.empty();
            }
            VivaceDto vivaceDto = new VivaceDto();
            if (!Check.isFilled(map.get("VIVACE"))) {
                this.logger.warn("query Vizier for VIVACE catalog ok but no VIVACE id found for 'Gaia EDR3 " + l + "'?");
                return Optional.empty();
            }
            vivaceDto.setVivaceId(Integer.parseInt(map.get("VIVACE")));
            String string2 = map.get("Class");
            vivaceDto.setType(this.mapToName(string2));
            if (Check.isFilled(map.get("Period"))) {
                vivaceDto.setPeriodInDays(Double.valueOf(map.get("Period")));
            }
            vivaceDto.setLink(LINK_URL);
            if (this.isTypeEclipsingBinary(string2)) {
                vivaceDto.setStatus(IconPoolCustom.AMPEL_GRUEN);
            } else {
                vivaceDto.setStatus(IconPoolCustom.AMPEL_GELB);
            }
            return Optional.of(vivaceDto);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error(exception);
            return Optional.empty();
        }
    }

    private String mapToName(String string) {
        return switch (string) {
            case "RRab" -> "RR Lyrae ab (RRab)";
            case "RRcd" -> "RR Lyrae c/d (RRcd)";
            case "CEP" -> "Classical Cepheid (CEP)";
            case "T2CEP" -> "Type II Cepheid (T2CEP)";
            case "LPV" -> "Long period Binary (LPV)";
            case "EA/EB" -> "Detached Eclipsing Binary (EA/EB)";
            case "EW" -> "Contact Eclipsing Binary (EW)";
            case "Ell" -> "Ellipsoidal Binary (Ell)";
            case "DSCT" -> "Delta Scuti (DSCT)";
            default -> "? (" + string + ")";
        };
    }

    private boolean isTypeEclipsingBinary(String string) {
        return switch (string) {
            case "RRab", "RRcd", "CEP", "T2CEP", "LPV", "EA/EB", "EW", "Ell", "DSCT" -> true;
            default -> false;
        };
    }
}

