/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.exportierer.guis;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.api.IExportDialog;
import de.planetensuche.datenbank.exportierer.threads.ExportthreadCSV;
import de.planetensuche.datenbank.exportierer.threads.ExportthreadHTML;
import de.planetensuche.datenbank.exportierer.threads.ExportthreadXML;
import de.planetensuche.datenbank.util.ProgressbarImportExportHelper;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public final class ExportDialog
extends Basisdialog
implements IExportDialog {
    private final ParameterDto parameter;
    private final IDatenbankService datenbankService;
    private final ProgressbarImportExportHelper importExportHelper;
    private String auswahlObjekt;
    private String auswahlKategorie;
    private String auswahlAutor;
    private String auswahlZeitraum;
    private String auswahlTag;
    private IPlanetensucheObjekt[] umgeleitet;
    private final ITimestampDAO timestampDAO;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final InjectionDto injectionDto;
    private final KonfigurationDTO globaleKonfig;
    private boolean withoutOpenFileDialog = false;
    private JTextField ausgabe;
    private JRadioButton autor;
    private JCheckBox bilder;
    private ButtonGroup buttonGroup1;
    private JList dateityp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JRadioButton kategorie;
    private JCheckBox notiz;
    private JRadioButton objekt;
    private JButton okButton;
    private JLabel prozent;
    private JLabel restzeitLabel;
    private JProgressBar status;
    private JRadioButton tag;
    private JRadioButton zeitraum;

    public ExportDialog(ParameterDto parameterDto, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        super(BasisdialogId.DATENBANK_EXPORT_DIALOG);
        this.parameter = parameterDto;
        this.datenbankService = injectionDto.getDatenbankService();
        this.timestampDAO = injectionDto.getTimestampDAO();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.kategorienRepository = injectionDto.getKategorienRepository();
        this.injectionDto = injectionDto;
        this.globaleKonfig = konfigurationDTO;
        this.initComponents();
        this.importExportHelper = new ProgressbarImportExportHelper(this.restzeitLabel, this.i18n);
        this.setTitle(this.i18n.getString("db_fenster6"));
        this.jLabel1.setText(this.i18n.getString("db_gui36"));
        this.jLabel2.setText(this.i18n.getString("db_gui37"));
        this.objekt.setText(this.i18n.getString("db_gui38"));
        this.kategorie.setText(this.i18n.getString("db_gui39"));
        this.autor.setText(this.i18n.getString("db_gui40"));
        this.zeitraum.setText(this.i18n.getString("db_gui114"));
        this.tag.setText(this.i18n.getString("db_gui41"));
        this.jLabel3.setText(this.i18n.getString("db_gui42"));
        this.bilder.setText(this.i18n.getString("db_gui43"));
        this.notiz.setText(this.i18n.getString("db_gui44"));
        this.ausgabe.setText(this.i18n.getString("db_gui45"));
        this.okButton.setText(this.i18n.getString("db_gui46"));
        String[] stringArray = new String[]{this.i18n.getString("db_m167"), this.i18n.getString("db_m247"), this.i18n.getString("db_m169")};
        this.dateityp = new JList<String>(stringArray);
        this.dateityp.setSelectionMode(0);
        this.dateityp.setToolTipText(this.i18n.getString("db_m248"));
        this.dateityp.setVisible(true);
        this.jScrollPane1.setViewportView(this.dateityp);
        this.dateityp.setSelectedIndex(0);
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        this.getGuiDesigner().addComponent(this.dateityp, false);
        if (this.isVisible()) {
            JOptionPane.showMessageDialog(null, this.i18n.getString("db_m11"), this.i18n.getString("db_m191_titel"), 1);
        }
    }

    @Override
    public Component getDialog() {
        return this;
    }

    @Override
    public boolean ergebnisAnzeigen() {
        return !this.withoutOpenFileDialog;
    }

    public void setWithoutOpenFileDialog(boolean bl) {
        this.withoutOpenFileDialog = bl;
    }

    @Override
    public void exportEnde(boolean bl, String string, File file) {
        try {
            if (bl) {
                int n;
                this.setAusgabe(this.i18n.getString("db_m255"));
                this.setStatus(100);
                if (this.ergebnisAnzeigen() && Desktop.isDesktopSupported() && (n = JOptionPane.showConfirmDialog(this, this.i18n.getString("db_m257") + file.getName() + this.i18n.getString("db_m256_2"), this.i18n.getString("db_m256_titel"), 0)) == 0) {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException iOException) {
                        this.getLogger().warn(iOException);
                        Desktop.getDesktop().browse(file.toURI());
                    }
                }
            } else {
                this.setAusgabe(this.i18n.getString("db_f96_titel"));
                this.setStatus(0);
                JOptionPane.showMessageDialog(this, this.i18n.getString("db_f96"), this.i18n.getString("db_f96_titel"), 0);
            }
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException exception) {
            this.setAusgabe(this.i18n.getString("db_f96_titel"));
            this.getLogger().error(exception);
        }
    }

    private List<String> getZeitraeume() {
        List<String> list = this.timestampDAO.getZeitraeume();
        return list;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.okButton = new JButton();
        this.status = new JProgressBar();
        this.ausgabe = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.dateityp = new JList();
        this.kategorie = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.autor = new JRadioButton();
        this.zeitraum = new JRadioButton();
        this.prozent = new JLabel();
        this.jLabel3 = new JLabel();
        this.bilder = new JCheckBox();
        this.notiz = new JCheckBox();
        this.restzeitLabel = new JLabel();
        this.objekt = new JRadioButton();
        this.tag = new JRadioButton();
        this.setTitle("Exportieren");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.okButton.setText("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.okButton);
        this.okButton.setBounds(420, 410, 80, 24);
        this.getContentPane().add(this.status);
        this.status.setBounds(20, 380, 320, 20);
        this.ausgabe.setEditable(false);
        this.ausgabe.setText("klicken Sie auf ok");
        this.getContentPane().add(this.ausgabe);
        this.ausgabe.setBounds(20, 350, 380, 24);
        this.jLabel1.setText("Art des Exports:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 10, 190, 24);
        this.dateityp.setSelectionMode(1);
        this.jScrollPane1.setViewportView(this.dateityp);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(20, 30, 390, 90);
        this.buttonGroup1.add(this.kategorie);
        this.kategorie.setText("einer bestimmten Kategorie / alle Kategorien");
        this.kategorie.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.kategorie);
        this.kategorie.setBounds(20, 170, 420, 24);
        this.jLabel2.setText("exportieren von Objekten ...");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(20, 130, 230, 24);
        this.buttonGroup1.add(this.autor);
        this.autor.setText("eines bestimmten Autors");
        this.autor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.autor);
        this.autor.setBounds(20, 190, 380, 24);
        this.buttonGroup1.add(this.zeitraum);
        this.zeitraum.setText("die in einem bestimmten Zeitraum erstellt / geaendert wurden");
        this.zeitraum.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.zeitraum);
        this.zeitraum.setBounds(20, 230, 470, 24);
        this.prozent.setText("0 %");
        this.getContentPane().add(this.prozent);
        this.prozent.setBounds(350, 380, 50, 24);
        this.jLabel3.setText("Optionen:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(20, 270, 220, 24);
        this.bilder.setText("Bilder exportieren");
        this.bilder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.bilder);
        this.bilder.setBounds(20, 290, 290, 24);
        this.notiz.setText("Beschreibungen exportieren");
        this.notiz.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.notiz);
        this.notiz.setBounds(20, 310, 320, 24);
        this.restzeitLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(this.restzeitLabel);
        this.restzeitLabel.setBounds(20, 410, 320, 24);
        this.buttonGroup1.add(this.objekt);
        this.objekt.setSelected(true);
        this.objekt.setText("einzelnes Objekt");
        this.objekt.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.objekt);
        this.objekt.setBounds(20, 150, 280, 24);
        this.buttonGroup1.add(this.tag);
        this.tag.setText("die an einem bestimmten Tag erstellt / geaendert wurden");
        this.tag.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.tag);
        this.tag.setBounds(20, 210, 460, 24);
        this.setSize(new Dimension(519, 479));
        this.setLocationRelativeTo(null);
    }

    @Override
    public boolean objektIsSelected() {
        return this.objekt.isSelected();
    }

    @Override
    public boolean zeitraumIsSelected() {
        return this.zeitraum.isSelected();
    }

    @Override
    public void setZeitraum(boolean bl) {
        this.zeitraum.setSelected(bl);
    }

    @Override
    public void setAuswahlZeitraum(String string) {
        this.auswahlZeitraum = string;
    }

    @Override
    public boolean autorIsSelected() {
        return this.autor.isSelected();
    }

    @Override
    public boolean kategorieIsSelected() {
        return this.kategorie.isSelected();
    }

    @Override
    public boolean tagIsSelected() {
        return this.tag.isSelected();
    }

    @Override
    public String getAuswahlAutor() {
        return this.auswahlAutor;
    }

    @Override
    public String getAuswahlKategorie() {
        return this.auswahlKategorie;
    }

    public void setAuswahlKategorie(String string) {
        this.auswahlKategorie = string;
        this.kategorie.setSelected(true);
    }

    public void setAuswahlObjekt(String string) {
        this.auswahlObjekt = string;
        this.objekt.setSelected(true);
    }

    @Override
    public String getAuswahlObjekt() {
        return this.auswahlObjekt;
    }

    @Override
    public String getAuswahlZeitraum() {
        return this.auswahlZeitraum;
    }

    @Override
    public String getAuswahlTag() {
        return this.auswahlTag;
    }

    @Override
    public IPlanetensucheObjekt[] getUmgeleitetVonImport() {
        if (this.umgeleitet != null) {
            return (IPlanetensucheObjekt[])this.umgeleitet.clone();
        }
        return null;
    }

    @Override
    public void setUmgeleitetVonImport(IPlanetensucheObjekt[] iPlanetensucheObjektArray) {
        this.umgeleitet = (IPlanetensucheObjekt[])iPlanetensucheObjektArray.clone();
        this.objekt.setSelected(false);
        this.bilder.setSelected(true);
        this.notiz.setSelected(true);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        try {
            Object object;
            Object[] objectArray;
            Object object2;
            this.auswahlObjekt = "";
            this.auswahlKategorie = "";
            this.auswahlAutor = "";
            this.auswahlZeitraum = "";
            this.auswahlTag = "";
            if (this.objekt.isSelected()) {
                object2 = this.objektnamenRepository.getAllNames(true);
                objectArray = new String[object2.size()];
                for (int i = 0; i < object2.size(); ++i) {
                    objectArray[i] = object2.get(i);
                }
                object = JOptionPane.showInputDialog(this, this.i18n.getString("db_m249"), this.i18n.getString("db_m249_titel"), 3, null, objectArray, 0);
                if (object != null) {
                    this.auswahlObjekt = object.toString();
                }
            } else if (this.kategorie.isSelected()) {
                object2 = this.kategorienRepository.getKategorien();
                objectArray = new String[object2.size() + 1];
                for (int i = 0; i < object2.size(); ++i) {
                    objectArray[i] = object2.get(i);
                }
                objectArray[object2.size()] = this.i18n.getString("db_m250");
                object = JOptionPane.showInputDialog(this, this.i18n.getString("db_m251"), this.i18n.getString("db_m251_titel"), 3, null, objectArray, objectArray[object2.size()]);
                if (object != null) {
                    this.auswahlKategorie = object.toString();
                }
            } else if (this.autor.isSelected()) {
                object2 = this.datenbankService.getAutoren();
                objectArray = new String[object2.size()];
                for (int i = 0; i < object2.size(); ++i) {
                    objectArray[i] = (String)object2.get(i);
                }
                object = JOptionPane.showInputDialog(this, this.i18n.getString("db_m252"), this.i18n.getString("db_m252_titel"), 3, null, objectArray, objectArray[0]);
                if (object != null) {
                    this.auswahlAutor = object.toString();
                }
            } else if (this.tag.isSelected()) {
                object2 = this.getZeitraeume();
                objectArray = new String[object2.size()];
                for (int i = 0; i < object2.size(); ++i) {
                    objectArray[i] = (String)object2.get(object2.size() - 1 - i);
                }
                object = JOptionPane.showInputDialog(this, this.i18n.getString("db_m425"), this.i18n.getString("db_m425_titel"), 3, null, objectArray, objectArray[0]);
                if (object != null) {
                    this.auswahlTag = object.toString();
                }
            } else if (this.zeitraum.isSelected()) {
                object2 = this.getZeitraeume();
                objectArray = new String[object2.size()];
                for (int i = 0; i < object2.size(); ++i) {
                    objectArray[i] = (String)object2.get(object2.size() - 1 - i);
                }
                object = JOptionPane.showInputDialog(this, this.i18n.getString("db_m253"), this.i18n.getString("db_m253_titel"), 3, null, objectArray, objectArray[0]);
                if (object != null) {
                    this.auswahlZeitraum = object.toString();
                }
            }
            if (!(this.auswahlAutor.isEmpty() && this.auswahlKategorie.isEmpty() && this.auswahlZeitraum.isEmpty() && this.auswahlObjekt.isEmpty() && this.auswahlTag.isEmpty())) {
                int n;
                object2 = new JFileChooser();
                ((JFileChooser)object2).setDialogTitle(this.i18n.getString("db_m195"));
                objectArray = new File("");
                ((JFileChooser)object2).setCurrentDirectory((File)objectArray);
                ((JFileChooser)object2).setFileSelectionMode(2);
                ((JFileChooser)object2).setMultiSelectionEnabled(false);
                object = null;
                if (this.dateityp.getSelectedValue().toString().equals(this.i18n.getString("db_m247"))) {
                    ((JFileChooser)object2).setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".html");
                        }

                        @Override
                        public String getDescription() {
                            return ExportDialog.this.i18n.getString("db_m247");
                        }
                    });
                    ((Component)object2).setSize(250, 250);
                    n = ((JFileChooser)object2).showSaveDialog(this);
                    if (n == 0 && !((File)(object = ((JFileChooser)object2).getSelectedFile())).getName().endsWith(".html")) {
                        object = new File(((File)object).getAbsolutePath() + ".html");
                    }
                } else if (this.dateityp.getSelectedValue().toString().equals(this.i18n.getString("db_m167"))) {
                    ((JFileChooser)object2).setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                        }

                        @Override
                        public String getDescription() {
                            return ExportDialog.this.i18n.getString("db_m167");
                        }
                    });
                    ((Component)object2).setSize(250, 250);
                    n = ((JFileChooser)object2).showSaveDialog(this);
                    if (n == 0 && !((File)(object = ((JFileChooser)object2).getSelectedFile())).getName().endsWith(".xml")) {
                        object = new File(((File)object).getAbsolutePath() + ".xml");
                    }
                } else if (this.dateityp.getSelectedValue().toString().equals(this.i18n.getString("db_m169"))) {
                    ((JFileChooser)object2).setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv");
                        }

                        @Override
                        public String getDescription() {
                            return ExportDialog.this.i18n.getString("db_m169");
                        }
                    });
                    ((Component)object2).setSize(250, 250);
                    n = ((JFileChooser)object2).showSaveDialog(this);
                    if (n == 0 && !((File)(object = ((JFileChooser)object2).getSelectedFile())).getName().endsWith(".csv")) {
                        object = new File(((File)object).getAbsolutePath() + ".csv");
                    }
                }
                if (object != null) {
                    n = 0;
                    if (((File)object).exists()) {
                        n = JOptionPane.showConfirmDialog(this, this.i18n.getString("db_m254"), this.i18n.getString("db_m254_titel"), 0);
                    }
                    if (n == 0) {
                        if (this.dateityp.getSelectedValue().toString().equals(this.i18n.getString("db_m247"))) {
                            ExportthreadHTML exportthreadHTML = new ExportthreadHTML((File)object, this, this.parameter, this.injectionDto, this.globaleKonfig);
                            exportthreadHTML.start();
                        } else if (this.dateityp.getSelectedValue().toString().equals(this.i18n.getString("db_m167"))) {
                            ExportthreadXML exportthreadXML = new ExportthreadXML((File)object, this, this.parameter, this.injectionDto, this.globaleKonfig);
                            exportthreadXML.start();
                        } else if (this.dateityp.getSelectedValue().toString().equals(this.i18n.getString("db_m169"))) {
                            ExportthreadCSV exportthreadCSV = new ExportthreadCSV((File)object, this, this.parameter, this.injectionDto, this.globaleKonfig);
                            exportthreadCSV.start();
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            this.getLogger().error(sQLException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f16") + "\n" + sQLException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    @Override
    public void setCursurWait(boolean bl) {
        if (bl) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public boolean isBilderExportieren() {
        return this.bilder.isSelected();
    }

    @Override
    public boolean isNotizenExportieren() {
        return this.notiz.isSelected();
    }

    @Override
    public void setButtonEnable(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    @Override
    public String getAusgabe() {
        return this.ausgabe.getText();
    }

    @Override
    public void setAusgabe(String string) {
        this.ausgabe.setText(string);
    }

    @Override
    public int getStatus() {
        return this.status.getValue();
    }

    @Override
    public void setStatus(int n) {
        this.status.setValue(n);
        this.prozent.setText(n + " %");
    }

    @Override
    public void setRestzeit(long l) {
        this.importExportHelper.setRestzeit(l);
    }
}

