/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.exportierer.threads;

import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.exportierer.threads.ExportOption;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DatenIdSammler {
    private final ITimestampDAO timestampDAO;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankService datenbankService;

    public DatenIdSammler(ITimestampDAO iTimestampDAO, IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, IDatenbankService iDatenbankService) {
        this.timestampDAO = iTimestampDAO;
        this.objektnamenRepository = iObjektnamenRepository;
        this.kategorienRepository = iKategorienRepository;
        this.datenbankService = iDatenbankService;
    }

    public List<Integer> getDatenIdsForExportOption(ExportOption exportOption, String string) throws SQLException {
        List<Integer> list;
        switch (exportOption.getOption()) {
            case 1: {
                list = new ArrayList<Integer>(1);
                list.add(this.objektnamenRepository.getIDFuerNamen(string, true));
                break;
            }
            case 2: {
                list = this.kategorienRepository.getDatenidsFuerKategorie(string);
                break;
            }
            case 3: {
                list = this.datenbankService.getAllDatenids();
                break;
            }
            case 4: {
                list = this.datenbankService.getDatenIdsFuerAutor(string);
                break;
            }
            case 5: {
                list = this.timestampDAO.getIDsFuerTag(string);
                break;
            }
            case 7: {
                list = this.timestampDAO.getIDsNachTag(string);
                break;
            }
            default: {
                list = new ArrayList<Integer>(0);
            }
        }
        return list;
    }
}

