/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.exportierer.threads;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.api.IExportDialog;
import de.planetensuche.datenbank.exportierer.threads.DatenIdSammler;
import de.planetensuche.datenbank.exportierer.threads.ExportOption;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public final class ExportthreadCSV
extends Thread {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final File datei;
    private final IExportDialog ijf;
    private final ITimestampDAO timestampDAO;
    private final INotizenService notizService;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankService datenbankService;
    private final KonfigurationDTO globaleKonfig;

    public ExportthreadCSV(File file, IExportDialog iExportDialog, ParameterDto parameterDto, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        this.datei = file;
        this.ijf = iExportDialog;
        this.sprache = parameterDto.getSprache();
        this.timestampDAO = injectionDto.getTimestampDAO();
        this.notizService = injectionDto.getNotizenService();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.kategorienRepository = injectionDto.getKategorienRepository();
        this.datenbankService = injectionDto.getDatenbankService();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.globaleKonfig = konfigurationDTO;
    }

    @Override
    public void run() {
        if (this.datei != null && this.ijf != null) {
            this.ijf.setButtonEnable(false);
            this.ijf.setCursurWait(true);
            try {
                boolean bl = false;
                if (this.ijf.objektIsSelected()) {
                    bl = this.exportiereCSV(ExportOption.EINZELNES_OBJEKT, this.ijf.getAuswahlObjekt());
                } else if (this.ijf.kategorieIsSelected()) {
                    bl = !this.ijf.getAuswahlKategorie().equals(this.sprache.getString("db_m250")) ? this.exportiereCSV(ExportOption.KATEGORIE, this.ijf.getAuswahlKategorie()) : this.exportiereCSV(ExportOption.ALLE_OBJEKTE, "");
                } else if (this.ijf.autorIsSelected()) {
                    bl = this.exportiereCSV(ExportOption.OBJEKTE_VON_AUTOR, this.ijf.getAuswahlAutor());
                } else if (this.ijf.tagIsSelected()) {
                    bl = this.exportiereCSV(ExportOption.OBJEKTE_FUER_DATUM, this.ijf.getAuswahlTag());
                } else if (this.ijf.zeitraumIsSelected()) {
                    bl = this.exportiereCSV(ExportOption.OBJEKTE_NACH_DATUM, this.ijf.getAuswahlZeitraum());
                }
                this.ijf.exportEnde(bl, this.sprache.getString("db_m258"), this.datei);
            }
            catch (RuntimeException runtimeException) {
                this.loggAndShowException(runtimeException);
            }
            this.ijf.setButtonEnable(true);
            this.ijf.setCursurWait(false);
        }
    }

    private void loggAndShowException(Exception exception) {
        this.ijf.setAusgabe(this.sprache.getString("db_f96_titel"));
        this.logging.error(exception);
    }

    public boolean exportiereCSV(ExportOption exportOption, String string) {
        try {
            DatenIdSammler datenIdSammler = new DatenIdSammler(this.timestampDAO, this.objektnamenRepository, this.kategorienRepository, this.datenbankService);
            List<Integer> list = datenIdSammler.getDatenIdsForExportOption(exportOption, string);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.datei, false), Charset.forName("UTF-8")));){
                bufferedWriter.write("//Planetensuche CSV Export Version 1.3");
                bufferedWriter.newLine();
                bufferedWriter.write("//" + this.sprache.getString("autor"));
                bufferedWriter.newLine();
                bufferedWriter.write("//Homepage: https://www." + this.globaleKonfig.getHomepageHostname());
                bufferedWriter.newLine();
                bufferedWriter.write("//");
                bufferedWriter.newLine();
                bufferedWriter.write("//[Name1, Name2, ...];" + this.sprache.getString("db_m16") + ";" + this.sprache.getString("db_m71") + ";" + this.sprache.getString("sim_gui79") + ";" + this.sprache.getString("db_m97") + ";" + this.sprache.getString("db_m100") + ";" + this.sprache.getString("db_m103") + ";" + this.sprache.getString("db_m104") + ";" + this.sprache.getString("db_m111") + ";" + this.sprache.getString("db_m115") + ";" + this.sprache.getString("db_m112") + ";" + this.sprache.getString("db_m116") + "/" + this.sprache.getString("db_m117") + ";" + this.sprache.getString("db_m108") + ";" + this.sprache.getString("db_m127") + ";" + this.sprache.getString("db_m126") + ";" + this.sprache.getString("db_m451") + ";" + this.sprache.getString("db_m54") + ";" + this.sprache.getString("sim_m26") + ";" + this.sprache.getString("db_m120") + ";" + this.sprache.getString("db_m110") + ";" + this.sprache.getString("db_m412") + ";" + this.sprache.getString("db_m238") + ";" + this.sprache.getString("db_m238") + ";" + this.sprache.getString("sim_m62") + ";" + this.sprache.getString("sim_m64") + ";" + this.sprache.getString("db_m122") + ";" + this.sprache.getString("db_m123") + ";" + this.sprache.getString("db_m124") + ";" + this.sprache.getString("db_m288") + ";RA;DECL;" + this.sprache.getString("db_m109") + ";" + this.sprache.getString("db_m128") + ";" + this.sprache.getString("db_m421") + ";" + this.sprache.getString("db_m138") + ";" + this.sprache.getString("db_m139") + ";[" + this.sprache.getString("db_m284") + "];[" + this.sprache.getString("db_m210") + "];");
                bufferedWriter.newLine();
                bufferedWriter.write("//");
                bufferedWriter.newLine();
                long l = System.currentTimeMillis();
                for (int i = 0; i < list.size(); ++i) {
                    CharSequence charSequence;
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(list.get(i));
                    String string2 = iPlanetensucheObjekt.getKategorie();
                    if (this.ijf != null) {
                        this.ijf.setAusgabe(this.sprache.getString("db_m259") + " " + iPlanetensucheObjekt.getObjektNamen().get(0) + " ...");
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(iPlanetensucheObjekt.getObjektNamen().toString());
                    stringBuilder.append(";");
                    stringBuilder.append(iPlanetensucheObjekt.getKategorie());
                    stringBuilder.append(";");
                    stringBuilder.append(iPlanetensucheObjekt.getObjekttyp());
                    stringBuilder.append(";");
                    String string3 = "Monde".equals(string2) ? "Km" : ("Planeten".equals(string2) || "Asteroiden".equals(string2) || "Kometen".equals(string2) || "Braune Zwerge".equals(string2) ? this.sprache.getString("db_m83") : "Ly");
                    if (iPlanetensucheObjekt.getEntfernung() > 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getEntfernung());
                        stringBuilder.append(" ");
                        stringBuilder.append(string3);
                    }
                    stringBuilder.append(";");
                    String string4 = "";
                    string4 = "Monde".equals(string2) || "Asteroiden".equals(string2) || "Kometen".equals(string2) || "Meteoriten und Krater".equals(string2) ? "Km" : ("Planeten".equals(string2) || "Braune Zwerge".equals(string2) ? this.sprache.getString("db_m99") : ("Sterne".equals(string2) ? this.sprache.getString("db_m98") : "'"));
                    if (iPlanetensucheObjekt.getDurchmesser() > 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getDurchmesser());
                        stringBuilder.append(" ");
                        stringBuilder.append(string4);
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getGalaxienDurchmesserInLy() > 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getGalaxienDurchmesserInLy());
                        stringBuilder.append(" ly");
                    }
                    stringBuilder.append(";");
                    String string5 = "";
                    string5 = "Planeten".equals(string2) || "Braune Zwerge".equals(string2) ? this.sprache.getString("db_m102") : ("Sterne".equals(string2) || "Sternhaufen".equals(string2) || "Galaxien und Nebel".equals(string2) || "Galaxienhaufen".equals(string2) || "Sonstiges".equals(string2) ? this.sprache.getString("db_m101") : "Kg");
                    if (iPlanetensucheObjekt.getMasse() > 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getMasse());
                        stringBuilder.append(" ");
                        stringBuilder.append(string5);
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getUmlaufszeit() > 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getUmlaufszeit());
                        stringBuilder.append(" Tage");
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getExzentritaet() > 0.0) {
                        stringBuilder.append(Double.toString(iPlanetensucheObjekt.getExzentritaet()));
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getAlbedo() > 0.0) {
                        stringBuilder.append(Double.toString(iPlanetensucheObjekt.getAlbedo()));
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getTemperatur() > -273.15) {
                        charSequence = "";
                        charSequence = "Sterne".equals(string2) || "Braune Zwerge".equals(string2) ? "Kelvin" : "\u00b0C";
                        stringBuilder.append(iPlanetensucheObjekt.getTemperatur());
                        stringBuilder.append(" ");
                        stringBuilder.append((String)charSequence);
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getGeschwindigkeit() != 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getGeschwindigkeit());
                        stringBuilder.append(" km/s");
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getScheinbareHelligkeit() > -100.0) {
                        stringBuilder.append(Double.toString(iPlanetensucheObjekt.getScheinbareHelligkeit()));
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getEntdeckungsdatum().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getEntdeckungsdatum());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getEntdeckungsmethode().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getEntdeckungsmethode());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getEntdeckungsmethode().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.isEntdeckungBestaetigt());
                    }
                    stringBuilder.append(";");
                    if (!"unbekannt".equals(iPlanetensucheObjekt.getSpektralklasse())) {
                        stringBuilder.append(iPlanetensucheObjekt.getSpektralklasse());
                        stringBuilder.append(" ");
                        stringBuilder.append(iPlanetensucheObjekt.getSpektralklasse2());
                    }
                    stringBuilder.append(";");
                    if (!"unbekannt".equals(iPlanetensucheObjekt.getLeuchtkraftklasse())) {
                        stringBuilder.append(iPlanetensucheObjekt.getLeuchtkraftklasse());
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getMetallizitaet() > -100.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getMetallizitaet());
                        stringBuilder.append(" Fe/H");
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getAbsoluteHelligkeit() > -100.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getAbsoluteHelligkeit());
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getBV() > -100.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getBV());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getSternhaufenform().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getSternhaufenform());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getNebelform().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getNebelform());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getGalaxienart().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getGalaxienart());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getGalaxienform().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getGalaxienform());
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getSternentstehung() > 0) {
                        stringBuilder.append(iPlanetensucheObjekt.getSternentstehung());
                        stringBuilder.append(" Sterne pro Jahr");
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getRotverschiebung() > -10.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getRotverschiebung());
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getAlterInMrdJahre() > 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getAlterInMrdJahre());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getSternbildDTBezeichnung().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getSternbildDTBezeichnung());
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getRA() != 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getRA());
                        stringBuilder.append(" in Stunden");
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getDECL() != 0.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getDECL());
                        stringBuilder.append(" in Grad");
                    }
                    stringBuilder.append(";");
                    if (iPlanetensucheObjekt.getFlaechenhelligkeit() > -100.0) {
                        stringBuilder.append(iPlanetensucheObjekt.getFlaechenhelligkeit());
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().isEmpty()) {
                        charSequence = new StringBuilder(iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().size());
                        for (String string6 : iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().keySet()) {
                            ((StringBuilder)charSequence).append(string6);
                            ((StringBuilder)charSequence).append(", ");
                        }
                        stringBuilder.append(((StringBuilder)charSequence).substring(0, ((StringBuilder)charSequence).length() - 2));
                    }
                    stringBuilder.append(";");
                    if (!iPlanetensucheObjekt.getUmkreistObjekt().isEmpty()) {
                        stringBuilder.append(iPlanetensucheObjekt.getUmkreistObjekt());
                    }
                    stringBuilder.append(";");
                    stringBuilder.append(iPlanetensucheObjekt.getAutor());
                    stringBuilder.append(";");
                    stringBuilder.append(iPlanetensucheObjekt.getStamp().toString());
                    stringBuilder.append(";");
                    if ((this.ijf == null || this.ijf.isNotizenExportieren()) && !iPlanetensucheObjekt.getNotiz().isEmpty()) {
                        charSequence = this.notizService.getByDatenid(iPlanetensucheObjekt.getDatenid());
                        stringBuilder.append("[");
                        stringBuilder.append((String)charSequence);
                        stringBuilder.append("]");
                    }
                    stringBuilder.append(";");
                    if (this.ijf == null || this.ijf.isBilderExportieren()) {
                        charSequence = this.datei.getAbsolutePath().substring(0, this.datei.getAbsolutePath().length() - 5);
                        File file = new File((String)charSequence);
                        stringBuilder.append("[");
                        StringBuilder stringBuilder2 = new StringBuilder(iPlanetensucheObjekt.getBilder().size());
                        int n = 0;
                        for (String string7 : iPlanetensucheObjekt.getBilder()) {
                            if (file.exists() || file.mkdir()) {
                                FileUtils.copyFile(new File("pics" + File.separator + string7), new File((String)charSequence + File.separator + string7));
                                stringBuilder2.append(string7);
                                if (n < iPlanetensucheObjekt.getBilder().size() - 1) {
                                    stringBuilder2.append(", ");
                                }
                            } else {
                                this.logging.warn("Bild '" + string7 + "' konnte nicht in Ordner '" + file.getName() + "' kopiert werden, da dieser nicht erstellt werden konnte!");
                            }
                            ++n;
                        }
                        stringBuilder.append(stringBuilder2.toString());
                        stringBuilder.append("]");
                    }
                    stringBuilder.append(";");
                    bufferedWriter.write(stringBuilder.toString());
                    bufferedWriter.newLine();
                    if (this.ijf == null) continue;
                    this.ijf.setStatus(i * 100 / list.size());
                    this.ijf.setRestzeit((System.currentTimeMillis() - l) / (long)(i + 1) * (long)(list.size() - (i + 1)) / 1000L);
                }
            }
            return true;
        }
        catch (IOException iOException) {
            this.logging.error("exportiereCSV(" + String.valueOf((Object)exportOption) + "," + string + ")", iOException);
            return false;
        }
        catch (SQLException sQLException) {
            this.logging.error("exportiereCSV(" + String.valueOf((Object)exportOption) + "," + string + ")", sQLException);
            return false;
        }
    }
}

