/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.exportierer.threads;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.api.IExportDialog;
import de.planetensuche.datenbank.exportierer.threads.DatenIdSammler;
import de.planetensuche.datenbank.exportierer.threads.ExportOption;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ExportthreadHTML
extends Thread {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final File datei;
    private final IExportDialog ijf;
    private final ITimestampDAO timestampDAO;
    private final INotizenService notizRepository;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankService datenbankService;
    private final KonfigurationDTO globaleKonfig;

    public ExportthreadHTML(File file, IExportDialog iExportDialog, ParameterDto parameterDto, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        this.datei = file;
        this.ijf = iExportDialog;
        this.sprache = parameterDto.getSprache();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.timestampDAO = injectionDto.getTimestampDAO();
        this.notizRepository = injectionDto.getNotizenService();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.kategorienRepository = injectionDto.getKategorienRepository();
        this.datenbankService = injectionDto.getDatenbankService();
        this.globaleKonfig = konfigurationDTO;
    }

    @Override
    public void run() {
        if (this.datei != null && this.ijf != null) {
            this.ijf.setButtonEnable(false);
            this.ijf.setCursurWait(true);
            try {
                boolean bl = false;
                if (this.ijf.objektIsSelected()) {
                    bl = this.exportiereHTML(ExportOption.EINZELNES_OBJEKT, this.ijf.getAuswahlObjekt());
                } else if (this.ijf.kategorieIsSelected()) {
                    bl = !this.ijf.getAuswahlKategorie().equals(this.sprache.getString("db_m250")) ? this.exportiereHTML(ExportOption.KATEGORIE, this.ijf.getAuswahlKategorie()) : this.exportiereHTML(ExportOption.ALLE_OBJEKTE, "");
                } else if (this.ijf.autorIsSelected()) {
                    bl = this.exportiereHTML(ExportOption.OBJEKTE_VON_AUTOR, this.ijf.getAuswahlAutor());
                } else if (this.ijf.tagIsSelected()) {
                    bl = this.exportiereHTML(ExportOption.OBJEKTE_FUER_DATUM, this.ijf.getAuswahlTag());
                } else if (this.ijf.zeitraumIsSelected()) {
                    bl = this.exportiereHTML(ExportOption.OBJEKTE_NACH_DATUM, this.ijf.getAuswahlZeitraum());
                }
                this.ijf.exportEnde(bl, this.sprache.getString("db_m256_1"), this.datei);
            }
            catch (RuntimeException runtimeException) {
                this.loggAndShowException(runtimeException);
            }
            this.ijf.setButtonEnable(true);
            this.ijf.setCursurWait(false);
        }
    }

    private void loggAndShowException(Exception exception) {
        this.ijf.setAusgabe(this.sprache.getString("db_f96_titel"));
        this.logging.error(exception);
    }

    public boolean exportiereHTML(ExportOption exportOption, String string) {
        try {
            DatenIdSammler datenIdSammler = new DatenIdSammler(this.timestampDAO, this.objektnamenRepository, this.kategorienRepository, this.datenbankService);
            List<Integer> list = datenIdSammler.getDatenIdsForExportOption(exportOption, string);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.datei, false), Charset.forName("UTF-8")));){
                bufferedWriter.write("<html>");
                bufferedWriter.newLine();
                bufferedWriter.write("<b>Planetensuche HTML Export Version 1.3<b><br><br>");
                bufferedWriter.newLine();
                bufferedWriter.write(this.sprache.getString("autor") + "<br>");
                bufferedWriter.newLine();
                bufferedWriter.write("Homepage: <a href=\"https://www." + this.globaleKonfig.getHomepageHostname() + "\">https://www." + this.globaleKonfig.getHomepageHostname() + "</a><br><br>");
                bufferedWriter.newLine();
                bufferedWriter.write("Beachten Sie die Urheberrechte des Autors und der Fotografen!<br><br><br>");
                bufferedWriter.newLine();
                long l = System.currentTimeMillis();
                for (int i = 0; i < list.size(); ++i) {
                    Object object;
                    String string222;
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(list.get(i));
                    String string3 = iPlanetensucheObjekt.getKategorie();
                    if (this.ijf != null) {
                        this.ijf.setAusgabe(this.sprache.getString("db_m259") + " " + iPlanetensucheObjekt.getObjektNamen().get(0) + " ...");
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(100);
                    StringBuilder stringBuilder = new StringBuilder(iPlanetensucheObjekt.getObjektNamen().size());
                    for (String string222 : iPlanetensucheObjekt.getObjektNamen()) {
                        stringBuilder.append(string222);
                        stringBuilder.append(", ");
                    }
                    arrayList.add(this.sprache.getString("db_m129"));
                    arrayList.add(stringBuilder.substring(0, stringBuilder.length() - 2));
                    arrayList.add(this.sprache.getString("db_m70"));
                    arrayList.add(string3);
                    arrayList.add(this.sprache.getString("db_m71"));
                    arrayList.add(iPlanetensucheObjekt.getObjekttyp());
                    if (!"".equals(iPlanetensucheObjekt.getSternbildDTBezeichnung())) {
                        arrayList.add(this.sprache.getString("db_m288"));
                        arrayList.add(iPlanetensucheObjekt.getSternbildDTBezeichnung());
                    }
                    if (iPlanetensucheObjekt.getRA() != 0.0) {
                        arrayList.add(this.sprache.getString("db_m286"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getRA()));
                    }
                    if (iPlanetensucheObjekt.getDECL() != 0.0) {
                        arrayList.add(this.sprache.getString("db_m287"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getDECL()));
                    }
                    if (!"unbekannt".equals(iPlanetensucheObjekt.getSpektralklasse())) {
                        arrayList.add(this.sprache.getString("db_m54"));
                        arrayList.add(iPlanetensucheObjekt.getSpektralklasse() + " " + iPlanetensucheObjekt.getSpektralklasse2());
                    }
                    if (!"unbekannt".equals(iPlanetensucheObjekt.getLeuchtkraftklasse())) {
                        arrayList.add(this.sprache.getString("sim_m26"));
                        arrayList.add(iPlanetensucheObjekt.getLeuchtkraftklasse());
                    }
                    if (!iPlanetensucheObjekt.getSternhaufenform().isEmpty()) {
                        arrayList.add(this.sprache.getString("db_m238"));
                        arrayList.add(iPlanetensucheObjekt.getSternhaufenform());
                    }
                    if (!iPlanetensucheObjekt.getNebelform().isEmpty()) {
                        arrayList.add(this.sprache.getString("db_m238"));
                        arrayList.add(iPlanetensucheObjekt.getNebelform());
                    }
                    if (!iPlanetensucheObjekt.getGalaxienart().isEmpty()) {
                        arrayList.add(this.sprache.getString("sim_m62"));
                        arrayList.add(iPlanetensucheObjekt.getGalaxienart());
                    }
                    if (!iPlanetensucheObjekt.getGalaxienform().isEmpty()) {
                        arrayList.add(this.sprache.getString("sim_m64"));
                        arrayList.add(iPlanetensucheObjekt.getGalaxienform());
                    }
                    String string4 = "Monde".equals(string3) ? "Km" : ("Planeten".equals(string3) || "Asteroiden".equals(string3) || "Kometen".equals(string3) || "Braune Zwerge".equals(string3) ? this.sprache.getString("db_m83") : "Ly");
                    if (iPlanetensucheObjekt.getEntfernung() > 0.0) {
                        arrayList.add(this.sprache.getString("db_m85") + (String)string4);
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getEntfernung()));
                    }
                    if (iPlanetensucheObjekt.getScheinbareHelligkeit() > -100.0) {
                        arrayList.add(this.sprache.getString("sim_m69"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getScheinbareHelligkeit()));
                    }
                    if (iPlanetensucheObjekt.getAbsoluteHelligkeit() > -100.0) {
                        arrayList.add(this.sprache.getString("db_m110"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getAbsoluteHelligkeit()));
                    }
                    if (iPlanetensucheObjekt.getBV() > -100.0) {
                        arrayList.add(this.sprache.getString("db_m412"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getBV()));
                    }
                    if (iPlanetensucheObjekt.getFlaechenhelligkeit() > -100.0) {
                        arrayList.add(this.sprache.getString("db_m109"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getFlaechenhelligkeit()));
                    }
                    string222 = "";
                    string222 = "Monde".equals(string3) || "Asteroiden".equals(string3) || "Kometen".equals(string3) || "Meteoriten und Krater".equals(string3) ? "Km" : ("Planeten".equals(string3) || "Braune Zwerge".equals(string3) ? this.sprache.getString("db_m99") : ("Sterne".equals(string3) ? this.sprache.getString("db_m98") : "'"));
                    if (iPlanetensucheObjekt.getDurchmesser() > 0.0) {
                        arrayList.add(this.sprache.getString("sim_m14") + " in " + string222);
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getDurchmesser()));
                    }
                    if (iPlanetensucheObjekt.getGalaxienDurchmesserInLy() > 0.0) {
                        arrayList.add(this.sprache.getString("sim_m14") + " in Ly (" + this.sprache.getString("db_m100") + ")");
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getGalaxienDurchmesserInLy()));
                    }
                    String string5 = "";
                    string5 = "Planeten".equals(string3) || "Braune Zwerge".equals(string3) ? this.sprache.getString("db_m102") : ("Sterne".equals(string3) || "Sternhaufen".equals(string3) || "Galaxien und Nebel".equals(string3) || "Galaxienhaufen".equals(string3) || "Sonstiges".equals(string3) ? this.sprache.getString("db_m101") : "Kg");
                    if (iPlanetensucheObjekt.getMasse() > 0.0) {
                        arrayList.add(this.sprache.getString("db_m103") + " in " + string5);
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getMasse()));
                    }
                    if (iPlanetensucheObjekt.getUmlaufszeit() > 0.0) {
                        arrayList.add(this.sprache.getString("db_m220"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getUmlaufszeit()));
                    }
                    if (iPlanetensucheObjekt.getExzentritaet() > 0.0) {
                        arrayList.add(this.sprache.getString("db_m111"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getExzentritaet()));
                    }
                    if (iPlanetensucheObjekt.getAlbedo() > 0.0) {
                        arrayList.add(this.sprache.getString("db_m115"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getAlbedo()));
                    }
                    if (iPlanetensucheObjekt.getTemperatur() > -273.15) {
                        object = "";
                        object = "Sterne".equals(string3) || "Braune Zwerge".equals(string3) ? "Kelvin" : "\u00b0C";
                        arrayList.add(this.sprache.getString("db_m112") + " in " + (String)object);
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getTemperatur()));
                    }
                    if (iPlanetensucheObjekt.getGeschwindigkeit() != 0.0) {
                        arrayList.add(this.sprache.getString("db_m236"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getGeschwindigkeit()));
                    }
                    if (iPlanetensucheObjekt.getMetallizitaet() > -100.0) {
                        arrayList.add(this.sprache.getString("sim_m124"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getMetallizitaet()));
                    }
                    if (iPlanetensucheObjekt.getAlterInMrdJahre() > 0.0) {
                        arrayList.add(this.sprache.getString("sim_m86"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getAlterInMrdJahre()));
                    }
                    if (iPlanetensucheObjekt.getSternentstehung() > 0) {
                        arrayList.add(this.sprache.getString("db_m122"));
                        arrayList.add(Integer.toString(iPlanetensucheObjekt.getSternentstehung()));
                    }
                    if (iPlanetensucheObjekt.getRotverschiebung() > -10.0) {
                        arrayList.add(this.sprache.getString("db_m123"));
                        arrayList.add(Double.toString(iPlanetensucheObjekt.getRotverschiebung()));
                    }
                    if (!iPlanetensucheObjekt.getEntdeckungsdatum().isEmpty()) {
                        arrayList.add(this.sprache.getString("db_m127"));
                        arrayList.add(iPlanetensucheObjekt.getEntdeckungsdatum());
                    }
                    if (!iPlanetensucheObjekt.getEntdeckungsmethode().isEmpty()) {
                        arrayList.add(this.sprache.getString("db_m126"));
                        arrayList.add(iPlanetensucheObjekt.getEntdeckungsmethode());
                        arrayList.add(this.sprache.getString("db_m451"));
                        arrayList.add(this.sprache.getString("" + iPlanetensucheObjekt.isEntdeckungBestaetigt()));
                    }
                    if (!iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().isEmpty()) {
                        stringBuilder = new StringBuilder(iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().size());
                        for (String string2 : iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().keySet()) {
                            stringBuilder.append(string2);
                            stringBuilder.append(", ");
                        }
                        arrayList.add(this.sprache.getString("db_m128"));
                        arrayList.add(stringBuilder.substring(0, stringBuilder.length() - 2));
                    }
                    if (!iPlanetensucheObjekt.getUmkreistObjekt().isEmpty()) {
                        arrayList.add(this.sprache.getString("db_m421"));
                        arrayList.add(iPlanetensucheObjekt.getUmkreistObjekt());
                    }
                    arrayList.add(this.sprache.getString("db_m138"));
                    arrayList.add(iPlanetensucheObjekt.getAutor());
                    arrayList.add(this.sprache.getString("db_m139"));
                    arrayList.add(iPlanetensucheObjekt.getStamp().toString());
                    if ((this.ijf == null || this.ijf.isNotizenExportieren()) && !iPlanetensucheObjekt.getNotiz().isEmpty()) {
                        object = this.notizRepository.getByDatenid(iPlanetensucheObjekt.getDatenid());
                        arrayList.add(this.sprache.getString("db_m284"));
                        arrayList.add(object);
                    }
                    bufferedWriter.write("<table border=\"1\">");
                    bufferedWriter.newLine();
                    for (int j = 0; j < arrayList.size(); j += 2) {
                        bufferedWriter.write("<tr>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("<td>" + (String)arrayList.get(j) + "</td>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("<td>" + (String)arrayList.get(j + 1) + "</td>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("</tr>");
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.write("</table>");
                    bufferedWriter.newLine();
                    if (this.ijf == null || this.ijf.isBilderExportieren()) {
                        String string6 = this.datei.getAbsolutePath().substring(0, this.datei.getAbsolutePath().length() - 5);
                        File file = new File(string6);
                        for (String string7 : iPlanetensucheObjekt.getBilder()) {
                            if (file.exists() || file.mkdir()) {
                                FileUtils.copyFile(new File("pics" + File.separator + string7), new File(string6 + File.separator + string7));
                                bufferedWriter.write("<img src=\"" + file.getName() + File.separator + string7 + "\" alt=\"\" border=0><br>");
                                continue;
                            }
                            this.logging.warn("Bild '" + string7 + "' konnte nicht in Ordner '" + file.getName() + "' kopiert werden, da dieser nicht erstellt werden konnte!");
                        }
                    }
                    bufferedWriter.write("<br><br>");
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                    if (this.ijf == null) continue;
                    this.ijf.setStatus(i * 100 / list.size());
                    this.ijf.setRestzeit((System.currentTimeMillis() - l) / (long)(i + 1) * (long)(list.size() - (i + 1)) / 1000L);
                }
                bufferedWriter.write("</html>");
                bufferedWriter.newLine();
            }
            return true;
        }
        catch (IOException iOException) {
            this.logging.error("exportiereHTML(" + String.valueOf((Object)exportOption) + "," + string + ")", iOException);
            return false;
        }
        catch (SQLException sQLException) {
            this.logging.error("exportiereHTML(" + String.valueOf((Object)exportOption) + "," + string + ")", sQLException);
            return false;
        }
    }
}

