/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.exportierer.threads;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.api.IExportDialog;
import de.planetensuche.datenbank.xmlschema.XMLSchemaGenerator;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ExportthreadXML
extends Thread {
    private final String homepageUrl;
    private final ISprachcontainer i18n;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankService datenbankService;
    private final ILogging logger;
    private final File datei;
    private final IExportDialog ijf;
    private final ITimestampDAO timestampDAO;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final KonfigurationDTO globaleKonfig;

    public ExportthreadXML(File file, IExportDialog iExportDialog, ParameterDto parameterDto, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        this.datei = file;
        this.ijf = iExportDialog;
        this.i18n = parameterDto.getSprache();
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.kategorienRepository = injectionDto.getKategorienRepository();
        this.datenbankService = injectionDto.getDatenbankService();
        this.timestampDAO = injectionDto.getTimestampDAO();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.globaleKonfig = konfigurationDTO;
        this.homepageUrl = "https://www." + konfigurationDTO.getHomepageHostname();
    }

    @Override
    public void run() {
        if (this.datei != null && this.ijf != null) {
            this.ijf.setButtonEnable(false);
            this.ijf.setCursurWait(true);
            try {
                boolean bl = false;
                if (this.ijf.getUmgeleitetVonImport() != null) {
                    bl = this.exportiereXMLMitJDOM(6, "");
                } else if (this.ijf.objektIsSelected()) {
                    bl = this.exportiereXMLMitJDOM(1, this.ijf.getAuswahlObjekt());
                } else if (this.ijf.kategorieIsSelected()) {
                    bl = !this.ijf.getAuswahlKategorie().equals(this.i18n.getString("db_m250")) ? this.exportiereXMLMitJDOM(2, this.ijf.getAuswahlKategorie()) : this.exportiereXMLMitJDOM(3, "");
                } else if (this.ijf.autorIsSelected()) {
                    bl = this.exportiereXMLMitJDOM(4, this.ijf.getAuswahlAutor());
                } else if (this.ijf.tagIsSelected()) {
                    bl = this.exportiereXMLMitJDOM(5, this.ijf.getAuswahlTag());
                } else if (this.ijf.zeitraumIsSelected()) {
                    bl = this.exportiereXMLMitJDOM(7, this.ijf.getAuswahlZeitraum());
                }
                this.ijf.exportEnde(bl, this.i18n.getString("db_m257"), this.datei);
            }
            catch (RuntimeException runtimeException) {
                this.loggAndShowException(runtimeException);
            }
            this.ijf.setButtonEnable(true);
            this.ijf.setCursurWait(false);
        }
    }

    private void aktualisiereStatus(int n, List<Integer> list, long l) {
        this.ijf.setStatus((n + 1) * 100 / list.size());
        long l2 = (System.currentTimeMillis() - l) / (long)(n + 1) * (long)(list.size() - (n + 1));
        this.ijf.setRestzeit(l2 / 1000L);
    }

    private XMLOutputter erzeugeXmlOutputter() {
        Format format = Format.getPrettyFormat();
        format.setEncoding("utf8");
        XMLOutputter xMLOutputter = new XMLOutputter(format);
        return xMLOutputter;
    }

    private List<Integer> getDatenidsVonZuExportierendenObjekten(int n, String string, IPlanetensucheObjekt[] iPlanetensucheObjektArray) throws SQLException {
        List<Integer> list;
        switch (n) {
            case 1: {
                list = new ArrayList<Integer>(1);
                list.add(this.objektnamenRepository.getIDFuerNamen(string, true));
                break;
            }
            case 2: {
                list = this.kategorienRepository.getDatenidsFuerKategorie(string);
                break;
            }
            case 3: {
                list = this.datenbankService.getAllDatenids();
                break;
            }
            case 4: {
                list = this.datenbankService.getDatenIdsFuerAutor(string);
                break;
            }
            case 5: {
                list = this.timestampDAO.getIDsFuerTag(string);
                break;
            }
            case 6: {
                list = new ArrayList<Integer>(iPlanetensucheObjektArray.length);
                for (int i = 0; i < iPlanetensucheObjektArray.length; ++i) {
                    list.add(i);
                }
                this.logger.debug("ids: " + list.size());
                break;
            }
            case 7: {
                list = this.timestampDAO.getIDsNachTag(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option '" + n + "'");
            }
        }
        return list;
    }

    private String getDurchmesserEinheit(String string) {
        String string2 = "Monde".equals(string) || "Asteroiden".equals(string) || "Kometen".equals(string) || "Meteoriten und Krater".equals(string) ? "Km" : ("Planeten".equals(string) || "Braune Zwerge".equals(string) ? "Jupiterdurchmesser" : ("Sterne".equals(string) ? "Sonnendurchmesser" : "'"));
        return string2;
    }

    private String getEntfernungseinheit(String string) {
        String string2 = "Monde".equals(string) ? "Km" : ("Planeten".equals(string) || "Asteroiden".equals(string) || "Kometen".equals(string) || "Braune Zwerge".equals(string) ? "AE" : "Ly");
        return string2;
    }

    private Document getExportiertesDokument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.datei);
        return document;
    }

    private String getMasseEinheit(String string) {
        boolean bl;
        boolean bl2 = bl = "Sternhaufen".equals(string) || "Galaxien und Nebel".equals(string) || "Galaxienhaufen".equals(string) || "Sonstiges".equals(string);
        String string2 = "Planeten".equals(string) || "Braune Zwerge".equals(string) ? "Jupitermassen" : ("Sterne".equals(string) || bl ? "Sonnenmassen" : "Kg");
        return string2;
    }

    private Validator getValidator() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        StreamSource streamSource = new StreamSource(new File(new File("").getAbsolutePath() + "/database" + File.separator + "planetensuche_schema.xsd"));
        Schema schema = schemaFactory.newSchema(streamSource);
        Validator validator = schema.newValidator();
        return validator;
    }

    private void kopiereBilderInZielordner(String string, String string2, File file) {
        try {
            FileUtils.copyFile(new File(new File("").getAbsolutePath() + "/pics" + File.separator + string), new File(string2 + File.separator + string));
        }
        catch (IOException iOException) {
            this.logger.warn("Bild '" + string + "' konnte nicht in Ordner '" + file.getName() + "' kopiert werden!", iOException);
        }
    }

    private void loggAndShowException(Exception exception) {
        this.logger.error(exception);
        this.ijf.setAusgabe(this.i18n.getString("db_f96_titel"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportiereXMLMitJDOM(int n, String string) {
        if (n < 1) throw new IllegalArgumentException("option = " + n);
        if (n > 7) {
            throw new IllegalArgumentException("option = " + n);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.datei);
            try {
                Object object;
                IPlanetensucheObjekt[] iPlanetensucheObjektArray = null;
                if (n == 6) {
                    iPlanetensucheObjektArray = this.ijf.getUmgeleitetVonImport();
                }
                this.logger.debug("notizen exportieren aktiviert? " + this.isNotizenExportierenAktiviert());
                List<Integer> list = this.getDatenidsVonZuExportierendenObjekten(n, string, iPlanetensucheObjektArray);
                this.logger.debug("found " + list.size() + " object(s) for xml export");
                XMLSchemaGenerator xMLSchemaGenerator = new XMLSchemaGenerator(this.logger, this.globaleKonfig);
                Namespace namespace = Namespace.getNamespace("", "https://www." + this.globaleKonfig.getHomepageHostname());
                XMLOutputter xMLOutputter = this.erzeugeXmlOutputter();
                this.schreibeXmlKopf(fileOutputStream, xMLSchemaGenerator);
                HashSet<Integer> hashSet = new HashSet<Integer>();
                long l = System.currentTimeMillis();
                for (int i = 0; i < list.size(); ++i) {
                    IPlanetensucheObjekt iPlanetensucheObjekt = n == 6 ? iPlanetensucheObjektArray[i] : this.planetensucheObjektRepository.read(list.get(i));
                    if (iPlanetensucheObjekt.getUmkreistDatenId() != null || Check.isFilled(iPlanetensucheObjekt.getUmkreistObjekt())) {
                        object = iPlanetensucheObjekt.getUmkreistDatenId();
                        if (object == null) {
                            object = this.objektnamenRepository.getIDFuerNamen(iPlanetensucheObjekt.getUmkreistObjekt(), true);
                        }
                        if (object == null) {
                            this.logger.warn(iPlanetensucheObjekt.getObjekttyp() + " " + String.valueOf(iPlanetensucheObjekt.getObjektNamen()) + " refer to parent object " + iPlanetensucheObjekt.getUmkreistObjekt() + " but it's not in the DB!!!");
                        } else {
                            this.exportParentObject(list, (Integer)object, hashSet, namespace, xMLOutputter, fileOutputStream);
                        }
                    }
                    object = this.createSingleXmlObject(iPlanetensucheObjekt, namespace);
                    xMLOutputter.output((Element)object, (OutputStream)fileOutputStream);
                    fileOutputStream.write("\n".getBytes("utf8"));
                    if (this.ijf == null) continue;
                    this.aktualisiereStatus(i, list, l);
                }
                long l2 = System.currentTimeMillis() - l;
                this.logger.debug(l2 + " ms export duration for " + list.size() + " object(s)");
                fileOutputStream.write("</objektliste>".getBytes("utf8"));
                fileOutputStream.flush();
                fileOutputStream.close();
                if (n == 6 && this.ijf != null) {
                    this.ijf.setStatus(100);
                }
                if (list.size() < 10000) {
                    try {
                        object = this.getExportiertesDokument();
                        Validator validator = this.getValidator();
                        if (this.ijf != null) {
                            this.ijf.setAusgabe(this.i18n.getString("db_m178"));
                        }
                        try {
                            validator.validate(new DOMSource((Node)object));
                            if (this.ijf != null) {
                                this.ijf.setAusgabe(this.i18n.getString("db_m179"));
                            }
                        }
                        catch (SAXException sAXException) {
                            this.logger.error(sAXException);
                            if (this.ijf != null) {
                                this.logger.showErrorMessageBox(this.ijf.getDialog(), this.i18n.getString("db_f37"), this.i18n.getString("db_f4_titel"));
                                this.ijf.setAusgabe(this.i18n.getString("db_f37"));
                                this.ijf.setButtonEnable(true);
                                this.ijf.setCursurWait(false);
                            }
                            boolean bl = false;
                            fileOutputStream.close();
                            return bl;
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException exception) {
                        this.logger.error(exception);
                        if (this.ijf != null) {
                            this.logger.showErrorMessageBox(this.ijf.getDialog(), this.i18n.getString("db_f38"), this.i18n.getString("db_f4_titel"));
                            this.ijf.setAusgabe(this.i18n.getString("db_f38"));
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException | SQLException exception) {
            this.logger.error("exportiereXMLMitJDOM(" + n + "," + string + ")", exception);
            return false;
        }
    }

    private void exportParentObject(List<Integer> list, Integer n, Set<Integer> set, Namespace namespace, XMLOutputter xMLOutputter, FileOutputStream fileOutputStream) throws IOException, SQLException {
        if (!list.contains(n) && !set.contains(n)) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
            Element element = this.createSingleXmlObject(iPlanetensucheObjekt, namespace);
            xMLOutputter.output(element, (OutputStream)fileOutputStream);
            fileOutputStream.write("\n".getBytes("utf8"));
            set.add(n);
            if (iPlanetensucheObjekt.getUmkreistDatenId() != null) {
                this.exportParentObject(list, iPlanetensucheObjekt.getUmkreistDatenId(), set, namespace, xMLOutputter, fileOutputStream);
            }
        }
    }

    Element createSingleXmlObject(IPlanetensucheObjekt iPlanetensucheObjekt, Namespace namespace) throws SQLException {
        boolean bl;
        String string = iPlanetensucheObjekt.getKategorie();
        List<String> list = iPlanetensucheObjekt.getObjektNamen();
        if (this.ijf != null) {
            this.ijf.setAusgabe(this.i18n.getString("db_m259") + " " + list.get(0) + " ...");
        }
        Element element = new Element("objekt", namespace);
        this.writeObjectNames(list, element, namespace);
        this.writeDistance(string, iPlanetensucheObjekt, namespace, element);
        this.writeDiameter(string, iPlanetensucheObjekt, namespace, element);
        this.writeMass(string, iPlanetensucheObjekt, namespace, element);
        String string2 = string.toLowerCase().replaceAll(" ", "_");
        Element element2 = new Element(string2, namespace);
        boolean bl2 = bl = "Planeten".equals(string) || "Monde".equals(string) || "Asteroiden".equals(string) || "Kometen".equals(string);
        if (bl || "Braune Zwerge".equals(string)) {
            if (iPlanetensucheObjekt.getUmlaufszeit() > 0.0) {
                element2.addContent(new Element("umlaufszeit", namespace).setAttribute("wert", Double.toString(iPlanetensucheObjekt.getUmlaufszeit())).setAttribute("einheit", "Tage"));
            }
            if (iPlanetensucheObjekt.getExzentritaet() > 0.0) {
                element2.addContent(new Element("exzentritaet", namespace).addContent(Double.toString(iPlanetensucheObjekt.getExzentritaet())));
            }
            if (iPlanetensucheObjekt.getAlbedo() > 0.0) {
                element2.addContent(new Element("albedo", namespace).addContent(Double.toString(iPlanetensucheObjekt.getAlbedo())));
            }
        }
        this.writeTemperature(bl, string, iPlanetensucheObjekt, element2, namespace);
        boolean bl3 = ObjektKategorie.STERNHAUFEN.getKategorienName().equals(string) || ObjektKategorie.GALAXIE_NEBEL.getKategorienName().equals(string);
        boolean bl4 = ObjektKategorie.PLANETEN.getKategorienName().equals(string) || ObjektKategorie.MONDE.getKategorienName().equals(string) || ObjektKategorie.ASTEROIDEN.getKategorienName().equals(string) || ObjektKategorie.KOMETEN.getKategorienName().equals(string);
        this.writeVelocity(bl4, string, bl3, iPlanetensucheObjekt, element2, namespace);
        if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
            this.writeGaiaData(iPlanetensucheObjekt, element2, namespace);
        }
        if (!"Meteoriten und Krater".equals(string)) {
            this.writeVisualMag(iPlanetensucheObjekt, element2, namespace);
            this.writeDiscoveryDate(iPlanetensucheObjekt, element2, namespace);
        }
        if ("Planeten".equals(string) || "Braune Zwerge".equals(string)) {
            this.writeDiscoveryMethod(iPlanetensucheObjekt, element2, namespace);
            element2.addContent(new Element("entdeckungBestaetigt", namespace).addContent("" + iPlanetensucheObjekt.isEntdeckungBestaetigt()));
        }
        if ("Asteroiden".equals(string)) {
            element2.addContent(new Element("spektraltyp_asteroiden", namespace).setAttribute("typ", iPlanetensucheObjekt.getSpektralklasse()));
        }
        this.writeSpectralClass(string, element2, namespace, iPlanetensucheObjekt);
        this.writeAge(string, bl3, iPlanetensucheObjekt, element2, namespace);
        this.writeLuminClass(string, element2, namespace, iPlanetensucheObjekt);
        if (string.equals(ObjektKategorie.STERNE.getKategorienName()) || bl3) {
            this.writeMetalicity(iPlanetensucheObjekt, element2, namespace);
            this.writeAbsoluteMag(iPlanetensucheObjekt, element2, namespace);
            this.writeBVIndex(iPlanetensucheObjekt, element2, namespace);
        }
        if (string.equals(ObjektKategorie.STERNHAUFEN.getKategorienName())) {
            element2.addContent(new Element("sternhaufenform", namespace).setAttribute("form", iPlanetensucheObjekt.getSternhaufenform()));
        }
        if (string.equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName())) {
            if (!iPlanetensucheObjekt.getNebelform().isEmpty()) {
                element2.addContent(new Element("nebelform", namespace).setAttribute("form", iPlanetensucheObjekt.getNebelform()));
            }
            if (!iPlanetensucheObjekt.getGalaxienart().isEmpty()) {
                element2.addContent(new Element("galaxienart", namespace).setAttribute("art", iPlanetensucheObjekt.getGalaxienart()));
            }
            if (!iPlanetensucheObjekt.getGalaxienform().isEmpty()) {
                element2.addContent(new Element("galaxienform", namespace).setAttribute("form", iPlanetensucheObjekt.getGalaxienform()));
            }
            if (iPlanetensucheObjekt.getSternentstehung() > 0) {
                element2.addContent(new Element("sternentstehung", namespace).addContent(Integer.toString(iPlanetensucheObjekt.getSternentstehung())));
            }
        }
        this.writeRedshift(string, iPlanetensucheObjekt, element2, namespace);
        if (string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName()) || string.equals(ObjektKategorie.STERNE.getKategorienName()) || bl3 || string.equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName()) || string.equals(ObjektKategorie.SONSTIGES.getKategorienName())) {
            this.writeConstellationName(iPlanetensucheObjekt, element2, namespace);
            this.writeRaDecl(iPlanetensucheObjekt, element2, namespace);
        }
        if ((bl3 || "Galaxienhaufen".equals(string) || "Sonstiges".equals(string)) && iPlanetensucheObjekt.getFlaechenhelligkeit() > -100.0) {
            element2.addContent(new Element("flaechenhelligkeit", namespace).addContent(Double.toString(iPlanetensucheObjekt.getFlaechenhelligkeit())));
        }
        element2.setAttribute("objekttyp", iPlanetensucheObjekt.getObjekttyp());
        element.addContent(element2);
        this.writeDiscoverer(iPlanetensucheObjekt, element, namespace);
        if (Check.isFilled(iPlanetensucheObjekt.getUmkreistObjekt())) {
            element.addContent(new Element("referenz", namespace).addContent(iPlanetensucheObjekt.getUmkreistObjekt()));
        }
        this.writeNotes(iPlanetensucheObjekt, element, namespace);
        this.writeAndExportPictures(iPlanetensucheObjekt, element, namespace);
        element.addContent(new Element("autor", namespace).addContent(iPlanetensucheObjekt.getAutor()));
        element.addContent(new Element("timestamp", namespace).addContent(iPlanetensucheObjekt.getStamp().toString()));
        return element;
    }

    private void writeAndExportPictures(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (this.ijf == null || this.ijf.isBilderExportieren()) {
            String string = this.datei.getAbsolutePath().substring(0, this.datei.getAbsolutePath().length() - 4);
            File file = new File(string);
            if (!(file.exists() || iPlanetensucheObjekt.getBilder().isEmpty() || file.mkdir())) {
                this.logger.warn("Ordner '" + file.getName() + "' konnte nicht erstellt werden!");
            }
            for (String string2 : iPlanetensucheObjekt.getBilder()) {
                element.addContent(new Element("bilder", namespace).addContent(string2));
                if (!file.exists()) continue;
                this.kopiereBilderInZielordner(string2, string, file);
            }
        }
    }

    private void writeNotes(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (this.isNotizenExportierenAktiviert() && iPlanetensucheObjekt.getNotiz() != null && !iPlanetensucheObjekt.getNotiz().isEmpty()) {
            element.addContent(new Element("notiz", namespace).addContent(iPlanetensucheObjekt.getNotiz()));
        }
    }

    private void writeDiscoverer(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (!iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().isEmpty()) {
            for (String string : iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().keySet()) {
                String string2 = iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().get(string);
                element.addContent(new Element("entdecker", namespace).addContent(string2 + ";" + string));
            }
        }
    }

    private void writeRaDecl(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (iPlanetensucheObjekt.getRA() != 0.0) {
            element.addContent(new Element("ra", namespace).addContent(Double.toString(iPlanetensucheObjekt.getRA())));
        }
        if (iPlanetensucheObjekt.getDECL() != 0.0) {
            element.addContent(new Element("decl", namespace).addContent(Double.toString(iPlanetensucheObjekt.getDECL())));
        }
    }

    private void writeConstellationName(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (iPlanetensucheObjekt.getSternbildDTBezeichnung().isEmpty()) {
            element.addContent(new Element("sternbild", namespace).setAttribute("bezeichnung", "unbekannt"));
        } else {
            element.addContent(new Element("sternbild", namespace).setAttribute("bezeichnung", iPlanetensucheObjekt.getSternbildLATBezeichnung()));
        }
    }

    private void writeRedshift(String string, IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if ((string.equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || string.equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName())) && iPlanetensucheObjekt.getRotverschiebung() > -10.0) {
            element.addContent(new Element("rotverschiebung", namespace).addContent(Double.toString(iPlanetensucheObjekt.getRotverschiebung())));
        }
    }

    private void writeBVIndex(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (iPlanetensucheObjekt.getBV() > -100.0) {
            element.addContent(new Element("B-V", namespace).addContent(Double.toString(iPlanetensucheObjekt.getBV())));
        }
    }

    private void writeAbsoluteMag(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (iPlanetensucheObjekt.getAbsoluteHelligkeit() > -100.0) {
            element.addContent(new Element("ah", namespace).addContent(Double.toString(iPlanetensucheObjekt.getAbsoluteHelligkeit())));
        }
    }

    private void writeMetalicity(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (iPlanetensucheObjekt.getMetallizitaet() > -100.0) {
            element.addContent(new Element("metallizitaet", namespace).addContent(Double.toString(iPlanetensucheObjekt.getMetallizitaet())));
        }
    }

    private void writeLuminClass(String string, Element element, Namespace namespace, IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
            element.addContent(new Element("leuchtkraftklasse", namespace).setAttribute("klasse", iPlanetensucheObjekt.getLeuchtkraftklasse()));
        }
    }

    private void writeAge(String string, boolean bl, IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if ((string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName()) || string.equals(ObjektKategorie.STERNE.getKategorienName()) || bl) && iPlanetensucheObjekt.getAlterInMrdJahre() > 0.0) {
            element.addContent(new Element("alter", namespace).addContent(Double.toString(iPlanetensucheObjekt.getAlterInMrdJahre())));
        }
    }

    private void writeSpectralClass(String string, Element element, Namespace namespace, IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName()) || string.equals(ObjektKategorie.STERNE.getKategorienName())) {
            element.addContent(new Element("spektraltyp_sterne_brzwerge", namespace).setAttribute("klasse1", iPlanetensucheObjekt.getSpektralklasse()).setAttribute("klasse2", Double.toString(iPlanetensucheObjekt.getSpektralklasse2())));
        }
    }

    private void writeDiscoveryMethod(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (!iPlanetensucheObjekt.getEntdeckungsmethode().isEmpty()) {
            element.addContent(new Element("entdeckungsmethode", namespace).setAttribute("methode", iPlanetensucheObjekt.getEntdeckungsmethode()));
        }
    }

    private void writeDiscoveryDate(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (!iPlanetensucheObjekt.getEntdeckungsdatum().isEmpty()) {
            element.addContent(new Element("entdeckungsdatum", namespace).addContent(iPlanetensucheObjekt.getEntdeckungsdatum()));
        }
    }

    private void writeVisualMag(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (iPlanetensucheObjekt.getScheinbareHelligkeit() > -100.0) {
            element.addContent(new Element("sh", namespace).addContent(Double.toString(iPlanetensucheObjekt.getScheinbareHelligkeit())));
        }
    }

    private void writeVelocity(boolean bl, String string, boolean bl2, IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if ((bl || ObjektKategorie.BR_ZWERGE.getKategorienName().equals(string) || ObjektKategorie.STERNE.getKategorienName().equals(string) || bl2) && iPlanetensucheObjekt.getGeschwindigkeit() != 0.0) {
            element.addContent(new Element("geschwindigkeit", namespace).addContent(Double.toString(iPlanetensucheObjekt.getGeschwindigkeit())));
        }
    }

    private void writeGaiaData(IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if (!iPlanetensucheObjekt.isGaiaRvErrorUnbekannt()) {
            element.addContent(new Element("rv_error", namespace).addContent(Double.toString(iPlanetensucheObjekt.getGaiaRvError())));
        }
        if (!iPlanetensucheObjekt.isGaiaRuweUnbekannt()) {
            element.addContent(new Element("ruwe", namespace).addContent(Double.toString(iPlanetensucheObjekt.getGaiaRuwe())));
        }
        if (!iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt()) {
            element.addContent(new Element("astro_ex_noise_sig", namespace).addContent(Double.toString(iPlanetensucheObjekt.getGaiaAstroExNoiseSig())));
        }
        if (!iPlanetensucheObjekt.isGaiaNonSingleUnbekannt()) {
            element.addContent(new Element("gaia_non_single", namespace).addContent(iPlanetensucheObjekt.getGaiaNonSingle().name()));
        }
    }

    private void writeTemperature(boolean bl, String string, IPlanetensucheObjekt iPlanetensucheObjekt, Element element, Namespace namespace) {
        if ((bl || "Braune Zwerge".equals(string) || "Sterne".equals(string)) && iPlanetensucheObjekt.getTemperatur() > -273.15) {
            element.addContent(new Element("temperatur", namespace).addContent(Double.toString(iPlanetensucheObjekt.getTemperatur())));
        }
    }

    private void writeMass(String string, IPlanetensucheObjekt iPlanetensucheObjekt, Namespace namespace, Element element) {
        String string2 = this.getMasseEinheit(string);
        if (iPlanetensucheObjekt.getMasse() > 0.0) {
            Element element2 = new Element("masse", namespace);
            element2.setAttribute("wert", Double.toString(iPlanetensucheObjekt.getMasse()));
            element2.setAttribute("einheit", string2);
            element.addContent(element2);
        }
    }

    private void writeDiameter(String string, IPlanetensucheObjekt iPlanetensucheObjekt, Namespace namespace, Element element) {
        Element element2;
        String string2 = this.getDurchmesserEinheit(string);
        if (iPlanetensucheObjekt.getDurchmesser() > 0.0) {
            element2 = new Element("durchmesser", namespace);
            element2.setAttribute("wert", Double.toString(iPlanetensucheObjekt.getDurchmesser()));
            element2.setAttribute("einheit", string2);
            element.addContent(element2);
        }
        if (iPlanetensucheObjekt.getGalaxienDurchmesserInLy() > 0.0) {
            element2 = new Element("durchmesser", namespace);
            element2.setAttribute("wert", Double.toString(iPlanetensucheObjekt.getGalaxienDurchmesserInLy()));
            element2.setAttribute("einheit", "Ly");
            element.addContent(element2);
        }
    }

    private void writeDistance(String string, IPlanetensucheObjekt iPlanetensucheObjekt, Namespace namespace, Element element) {
        String string2 = this.getEntfernungseinheit(string);
        if (iPlanetensucheObjekt.getEntfernung() > 0.0) {
            Element element2 = new Element("entfernung", namespace);
            element2.setAttribute("wert", Double.toString(iPlanetensucheObjekt.getEntfernung()));
            element2.setAttribute("einheit", string2);
            element.addContent(element2);
        }
    }

    private void writeObjectNames(List<String> list, Element element, Namespace namespace) {
        for (String string : list) {
            element.addContent(new Element("name", namespace).addContent(string));
        }
    }

    private boolean isNotizenExportierenAktiviert() {
        return this.ijf == null || this.ijf.isNotizenExportieren();
    }

    private void schreibeXmlKopf(FileOutputStream fileOutputStream, XMLSchemaGenerator xMLSchemaGenerator) throws IOException {
        fileOutputStream.write("<?xml version=\"1.0\" encoding=\"utf8\"?>\n".getBytes("utf8"));
        fileOutputStream.write(("<!--Planetensuche XML Export Version " + xMLSchemaGenerator.getXmlversion() + ", Autor: Gerd G\u00fchne, Homepage: " + this.homepageUrl + "-->\n").getBytes("utf8"));
        fileOutputStream.write("<objektliste xmlns=\"https://www.".getBytes("utf8"));
        fileOutputStream.write(this.globaleKonfig.getHomepageHostname().getBytes("utf8"));
        fileOutputStream.write("\"".getBytes("utf8"));
        fileOutputStream.write(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"".getBytes("utf8"));
        fileOutputStream.write((" xmlns:schemaLocation=\"https://www." + this.globaleKonfig.getHomepageHostname() + "/planetensuche_schema.xsd\">\n").getBytes("utf8"));
    }
}

