/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.filter;

import com.google.common.io.Files;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JOptionPane;

public final class FilterService {
    private static final String FILTER_DATEI = new File("").getAbsolutePath() + "/conf/filteroptionen.conf";
    private final ISprachcontainer sprache;
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());

    public FilterService(ISprachcontainer iSprachcontainer) {
        this.sprache = iSprachcontainer;
    }

    public FilterkonfigurationDto ladeFiltereinstellungen() {
        FilterkonfigurationDto filterkonfigurationDto = new FilterkonfigurationDto();
        try {
            int n = 0;
            List<String> list = Files.readLines(new File(FILTER_DATEI), Charset.forName("UTF-8"));
            for (String string : list) {
                if (string.startsWith("aktiviert=")) {
                    filterkonfigurationDto.setFilterAktiv(Boolean.parseBoolean(string.substring(10, string.length())));
                } else if (string.startsWith("[")) {
                    int n2 = string.indexOf(93);
                    int n3 = string.indexOf(61);
                    int n4 = Integer.parseInt(string.substring(1, n2));
                    int n5 = Integer.parseInt(string.substring(n2 + 2, n3 - 1));
                    filterkonfigurationDto.setParameter(n4, n5, string.substring(n3 + 1, string.length()));
                }
                ++n;
            }
            if (n == 0) {
                for (int i = 0; i < 12; ++i) {
                    filterkonfigurationDto.setParameter(i, 8, "true");
                }
                JOptionPane.showMessageDialog(null, this.sprache.getString("db_m2"), this.sprache.getString("db_m2_titel"), 1);
            }
        }
        catch (IOException iOException) {
            this.ladeFiltereinstellungenErrorFall(iOException);
        }
        return filterkonfigurationDto;
    }

    private void ladeFiltereinstellungenErrorFall(IOException iOException) {
        this.logging.error(iOException);
        JOptionPane.showMessageDialog(null, this.sprache.getString("db_f5") + "\n" + iOException.toString(), this.sprache.getString("db_f5_titel"), 0);
    }

    public void speichereFiltereinstellungen(FilterkonfigurationDto filterkonfigurationDto) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(FILTER_DATEI), false), Charset.forName("UTF-8")));){
            bufferedWriter.write("aktiviert=" + filterkonfigurationDto.isFilterAktiv());
            bufferedWriter.newLine();
            for (int i = 0; i < 12; ++i) {
                for (int j = 0; j < 10; ++j) {
                    bufferedWriter.write("[" + i + "][" + j + "]=" + filterkonfigurationDto.getParameterWert(i, j));
                    bufferedWriter.newLine();
                }
            }
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
        }
    }
}

