/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.flickr;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotosInterface;
import com.flickr4java.flickr.photos.SearchParameters;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.flickr.FlickrRestClient;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.PictureViewerDataSource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.bouncycastle.util.encoders.Base64;

public class FlickrPictureDataSource
implements PictureViewerDataSource {
    private PhotoList<Photo> results = new PhotoList();

    public FlickrPictureDataSource(Collection<String> collection, ObjektKategorie objektKategorie) {
        try {
            String string = new String(Base64.decode("ZjExYzYwODQyMGNhMjhmNzI3Y2IyYTY4ZTgyZGJlNTA="));
            String string2 = new String(Base64.decode("ZjNmZDQxZDZhYWQxYjc5Mg=="));
            FlickrRestClient flickrRestClient = new FlickrRestClient();
            flickrRestClient.setReadTimeoutMs(5000);
            Flickr flickr = new Flickr(string, string2, flickrRestClient);
            SearchParameters searchParameters = new SearchParameters();
            searchParameters.setMedia("photos");
            searchParameters.setText(this.getSearchTextFromObjectnames(collection));
            String[] stringArray = this.getTags(objektKategorie);
            searchParameters.setTags(stringArray);
            PhotosInterface photosInterface = flickr.getPhotosInterface();
            this.results = photosInterface.search(searchParameters, 5, 0);
        }
        catch (FlickrException flickrException) {
            LoggingFactory.getLoggerForClass(this.getClass()).error(flickrException);
        }
    }

    private String getSearchTextFromObjectnames(Collection<String> collection) {
        for (String string : collection) {
            if (!string.contains(" ")) {
                return string;
            }
            if (!string.startsWith("NGC ") && !string.startsWith("M ")) continue;
            return string;
        }
        return collection.iterator().next();
    }

    private String[] getTags(ObjektKategorie objektKategorie) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (objektKategorie == ObjektKategorie.STERNE) {
            arrayList.add("stars");
        } else if (objektKategorie == ObjektKategorie.ASTEROIDEN) {
            arrayList.add("asteroid");
        } else if (objektKategorie == ObjektKategorie.MONDE) {
            arrayList.add("moons");
        } else if (objektKategorie == ObjektKategorie.PLANETEN) {
            arrayList.add("planet");
        } else if (objektKategorie == ObjektKategorie.METEOR) {
            arrayList.add("crater");
        } else if (objektKategorie == ObjektKategorie.KOMETEN) {
            arrayList.add("comet");
        } else if (objektKategorie == ObjektKategorie.STERNBILDER) {
            arrayList.add("constellation");
        } else if (objektKategorie != ObjektKategorie.BR_ZWERGE) {
            arrayList.add("space");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public int numberOfPictures() {
        return this.results.size();
    }

    @Override
    public List<String> getPictureNames() {
        return this.results.stream().map(photo -> "Flickr: " + photo.getTitle()).collect(Collectors.toList());
    }

    @Override
    public String getPictureName(int n) {
        return ((Photo)this.results.get(n)).getTitle();
    }

    @Override
    public ImageIcon getPicture(int n) {
        Photo photo = (Photo)this.results.get(n);
        String string = photo.getLargeUrl();
        try {
            return new ImageIcon(new URL(string), photo.getTitle());
        }
        catch (MalformedURLException malformedURLException) {
            LoggingFactory.getLoggerForClass(this.getClass()).warn(string, malformedURLException);
            return new ImageIcon();
        }
    }
}

