/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.gaia.doublestar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datenbank.gaia.doublestar.GaiaArchiveRawResponseDto;
import de.planetensuche.datenbank.gaia.doublestar.GaiaAstrometricDto;
import de.planetensuche.datenbank.vizier.UrlQueryUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import java.io.IOException;
import java.util.Optional;

public class GaiaDoubleStarIndicatorService {
    private final String gaiaBaseUrlDr2 = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.non_single_star,dr3.ruwe,dr3.astrometric_excess_noise_sig,dr3.radial_velocity,dr3.radial_velocity_error+FROM+gaiadr3.gaia_source+AS+dr3+JOIN+gaiadr3.dr2_neighbourhood+AS+dr2+ON+dr3.source_id=dr2.dr3_source_id+WHERE+dr2.dr2_source_id=XXX+ORDER+BY+dr2.angular_distance+ASC";
    private final String gaiaBaseUrlDr3 = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.non_single_star,dr3.ruwe,dr3.astrometric_excess_noise_sig,dr3.radial_velocity,dr3.radial_velocity_error+FROM+gaiadr3.gaia_source+AS+dr3+WHERE+dr3.source_id=XXX";
    private final String gaiaBaseUrlDr3ByCoordinates = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.non_single_star,dr3.ruwe,dr3.astrometric_excess_noise_sig,dr3.radial_velocity,dr3.radial_velocity_error,DISTANCE(XXR,XXD,dr3.ra,dr3.dec)+AS+ang_sep+FROM+gaiadr3.gaia_source+AS+dr3+WHERE+DISTANCE(XXR,XXD,dr3.ra,dr3.dec)%3C0.083333333+AND+dr3.phot_g_mean_mag%3C20.0+ORDER+BY+ang_sep+ASC";
    private final int timeoutInMs = 15000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<GaiaAstrometricDto> queryGaiaByCoordinates(double d, double d2) {
        try {
            String string = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.non_single_star,dr3.ruwe,dr3.astrometric_excess_noise_sig,dr3.radial_velocity,dr3.radial_velocity_error,DISTANCE(XXR,XXD,dr3.ra,dr3.dec)+AS+ang_sep+FROM+gaiadr3.gaia_source+AS+dr3+WHERE+DISTANCE(XXR,XXD,dr3.ra,dr3.dec)%3C0.083333333+AND+dr3.phot_g_mean_mag%3C20.0+ORDER+BY+ang_sep+ASC".replaceAll("XXR", Double.toString(d * 360.0 / 24.0)).replaceAll("XXD", Double.toString(d2));
            return this.queryAndExtractData(string);
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error("query failed for coordinate search by ra '" + d + "' and decl '" + d2 + "'", exception);
            return Optional.empty();
        }
    }

    public Optional<GaiaAstrometricDto> queryGaiaByGaiaDr3(long l) {
        try {
            String string = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.non_single_star,dr3.ruwe,dr3.astrometric_excess_noise_sig,dr3.radial_velocity,dr3.radial_velocity_error+FROM+gaiadr3.gaia_source+AS+dr3+WHERE+dr3.source_id=XXX".replace("XXX", Long.toString(l));
            return this.queryAndExtractData(string);
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error("query failed for 'Gaia DR3 " + l + "'", exception);
            return Optional.empty();
        }
    }

    public Optional<GaiaAstrometricDto> queryGaiaByGaiaDr2(long l) {
        try {
            String string = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.non_single_star,dr3.ruwe,dr3.astrometric_excess_noise_sig,dr3.radial_velocity,dr3.radial_velocity_error+FROM+gaiadr3.gaia_source+AS+dr3+JOIN+gaiadr3.dr2_neighbourhood+AS+dr2+ON+dr3.source_id=dr2.dr3_source_id+WHERE+dr2.dr2_source_id=XXX+ORDER+BY+dr2.angular_distance+ASC".replace("XXX", Long.toString(l));
            return this.queryAndExtractData(string);
        }
        catch (IOException | RuntimeException exception) {
            this.logger.error("query failed for 'Gaia DR2 " + l + "'", exception);
            return Optional.empty();
        }
    }

    private Optional<GaiaAstrometricDto> queryAndExtractData(String string) throws IOException, JsonProcessingException {
        StringBuilder stringBuilder = UrlQueryUtil.getResponseFromUrlQuery(string, 15000);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto = objectMapper.readValue(stringBuilder.toString(), GaiaArchiveRawResponseDto.class);
        if (gaiaArchiveRawResponseDto.getData().length == 0) {
            return Optional.empty();
        }
        if (Check.isEmpty(gaiaArchiveRawResponseDto.getData()[0][0])) {
            this.logger.warn("Gaia Id is empty but response not?! response: " + gaiaArchiveRawResponseDto.toString());
            return Optional.empty();
        }
        GaiaAstrometricDto gaiaAstrometricDto = new GaiaAstrometricDto();
        gaiaAstrometricDto.setGaiaDr3Id(Long.parseLong(gaiaArchiveRawResponseDto.getData()[0][0].toString()));
        if (Check.isFilled(gaiaArchiveRawResponseDto.getData()[0][1])) {
            this.setNonSingleStarFields(gaiaArchiveRawResponseDto, gaiaAstrometricDto);
        }
        if (Check.isFilled(gaiaArchiveRawResponseDto.getData()[0][2])) {
            this.setRuweFields(gaiaArchiveRawResponseDto, gaiaAstrometricDto);
        }
        if (Check.isFilled(gaiaArchiveRawResponseDto.getData()[0][3])) {
            this.setAstrometricFields(gaiaArchiveRawResponseDto, gaiaAstrometricDto);
        }
        if (Check.isFilled(gaiaArchiveRawResponseDto.getData()[0][4])) {
            this.setRvFields(gaiaArchiveRawResponseDto, gaiaAstrometricDto);
        }
        if (Check.isFilled(gaiaArchiveRawResponseDto.getData()[0][5])) {
            this.setRvErrorFields(gaiaArchiveRawResponseDto, gaiaAstrometricDto);
        }
        return Optional.of(gaiaAstrometricDto);
    }

    public Optional<GaiaAstrometricDto> queryGaia(String string) {
        try {
            String[] stringArray = string.split(" ");
            String string2 = stringArray[2];
            return switch (stringArray[1]) {
                case "DR2" -> this.queryGaiaByGaiaDr2(Long.parseLong(string2));
                case "DR3" -> this.queryGaiaByGaiaDr3(Long.parseLong(string2));
                default -> throw new UnsupportedOperationException("unsupported DR for star '" + string + "'");
            };
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("query failed for '" + string + "'", runtimeException);
            return Optional.empty();
        }
    }

    private void setRvErrorFields(GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto, GaiaAstrometricDto gaiaAstrometricDto) {
        double d = Double.parseDouble(gaiaArchiveRawResponseDto.getData()[0][5].toString());
        gaiaAstrometricDto.setRvErrorInMeterPerSeconds(d * 1000.0);
        gaiaAstrometricDto.setRvErrorStatus(IconPoolCustom.AMPEL_GELB);
    }

    private void setRvFields(GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto, GaiaAstrometricDto gaiaAstrometricDto) {
        double d = Double.parseDouble(gaiaArchiveRawResponseDto.getData()[0][4].toString());
        gaiaAstrometricDto.setRvInMeterPerSeconds(d * 1000.0);
    }

    private void setAstrometricFields(GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto, GaiaAstrometricDto gaiaAstrometricDto) {
        double d = Double.parseDouble(gaiaArchiveRawResponseDto.getData()[0][3].toString());
        gaiaAstrometricDto.setAstrometricExcessNoiseSignificance(d);
        if (d >= 2.0) {
            gaiaAstrometricDto.setAstrometricStatus(IconPoolCustom.AMPEL_GELB);
        } else {
            gaiaAstrometricDto.setAstrometricStatus(IconPoolCustom.AMPEL_ROT);
        }
    }

    private void setRuweFields(GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto, GaiaAstrometricDto gaiaAstrometricDto) {
        double d = Double.parseDouble(gaiaArchiveRawResponseDto.getData()[0][2].toString());
        gaiaAstrometricDto.setRuwe(d);
        if (d > 1.4) {
            gaiaAstrometricDto.setRuweStatus(IconPoolCustom.AMPEL_GRUEN);
        } else if (d >= 1.2) {
            gaiaAstrometricDto.setRuweStatus(IconPoolCustom.AMPEL_GELB);
        } else {
            gaiaAstrometricDto.setRuweStatus(IconPoolCustom.AMPEL_ROT);
        }
    }

    private void setNonSingleStarFields(GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto, GaiaAstrometricDto gaiaAstrometricDto) {
        String string;
        switch (string = gaiaArchiveRawResponseDto.getData()[0][1].toString()) {
            case "0": {
                gaiaAstrometricDto.setIsSingleStar(true);
                gaiaAstrometricDto.setNonSingleStarType(null);
                break;
            }
            case "1": {
                gaiaAstrometricDto.setIsSingleStar(false);
                gaiaAstrometricDto.setNonSingleStarType(GaiaNonSingleStar.ASTROMETRIC_BINARY);
                break;
            }
            case "2": {
                gaiaAstrometricDto.setIsSingleStar(false);
                gaiaAstrometricDto.setNonSingleStarType(GaiaNonSingleStar.SPECTROSCOPIC_BINARY);
                break;
            }
            case "4": {
                gaiaAstrometricDto.setIsSingleStar(false);
                gaiaAstrometricDto.setNonSingleStarType(GaiaNonSingleStar.ECLIPSING_BINARY);
                break;
            }
            default: {
                gaiaAstrometricDto.setIsSingleStar(null);
                gaiaAstrometricDto.setNonSingleStarType(null);
            }
        }
        if (gaiaAstrometricDto.getIsSingleStar() == null) {
            gaiaAstrometricDto.setNonSingleStarStatus(IconPoolCustom.AMPEL_GELB);
        } else if (gaiaAstrometricDto.getIsSingleStar().booleanValue()) {
            gaiaAstrometricDto.setNonSingleStarStatus(IconPoolCustom.AMPEL_ROT);
        } else {
            gaiaAstrometricDto.setNonSingleStarStatus(IconPoolCustom.AMPEL_GRUEN);
        }
    }
}

