/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.gaia.main;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.planetensuche.datenbank.gaia.main.GaiaArchiveRawResponseDto;
import de.planetensuche.datenbank.gaia.main.GaiaDataRelease;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataDto;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataDtoBuilder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Optional;

public class GaiaStellarDataService {
    private final String queryWithDr2 = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.teff_gspphot,dr3.teff_gspphot_lower,dr3.teff_gspphot_upper,dr3.teff_gspspec,dr3.teff_gspspec_lower,dr3.teff_gspspec_upper,dr3.distance_gspphot,dr3.distance_gspphot_lower,dr3.distance_gspphot_upper,dr3.spectraltype_esphs,dr3.radius_gspphot,dr3.radius_gspphot_lower,dr3.radius_gspphot_upper,dr3.radius_flame,dr3.radius_flame_lower,dr3.radius_flame_upper,dr3.mass_flame,dr3.mass_flame_lower,dr3.mass_flame_upper+FROM+gaiadr3.astrophysical_parameters+AS+dr3+JOIN+gaiadr3.dr2_neighbourhood+AS+dr2+ON+dr3.source_id=dr2.dr3_source_id+WHERE+dr2.dr2_source_id=XXX+ORDER+BY+dr2.angular_distance+ASC";
    private final String queryWithDr3 = "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.teff_gspphot,dr3.teff_gspphot_lower,dr3.teff_gspphot_upper,dr3.teff_gspspec,dr3.teff_gspspec_lower,dr3.teff_gspspec_upper,dr3.distance_gspphot,dr3.distance_gspphot_lower,dr3.distance_gspphot_upper,dr3.spectraltype_esphs,dr3.radius_gspphot,dr3.radius_gspphot_lower,dr3.radius_gspphot_upper,dr3.radius_flame,dr3.radius_flame_lower,dr3.radius_flame_upper,dr3.mass_flame,dr3.mass_flame_lower,dr3.mass_flame_upper+FROM+gaiadr3.astrophysical_parameters+AS+dr3+WHERE+dr3.source_id=XXX";
    private final int timeoutInMs = 15000;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public Optional<GaiaStellarDataDto> queryGaia(GaiaDataRelease gaiaDataRelease, long l) throws IOException {
        try {
            String string = gaiaDataRelease.equals((Object)GaiaDataRelease.DR2) ? "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.teff_gspphot,dr3.teff_gspphot_lower,dr3.teff_gspphot_upper,dr3.teff_gspspec,dr3.teff_gspspec_lower,dr3.teff_gspspec_upper,dr3.distance_gspphot,dr3.distance_gspphot_lower,dr3.distance_gspphot_upper,dr3.spectraltype_esphs,dr3.radius_gspphot,dr3.radius_gspphot_lower,dr3.radius_gspphot_upper,dr3.radius_flame,dr3.radius_flame_lower,dr3.radius_flame_upper,dr3.mass_flame,dr3.mass_flame_lower,dr3.mass_flame_upper+FROM+gaiadr3.astrophysical_parameters+AS+dr3+JOIN+gaiadr3.dr2_neighbourhood+AS+dr2+ON+dr3.source_id=dr2.dr3_source_id+WHERE+dr2.dr2_source_id=XXX+ORDER+BY+dr2.angular_distance+ASC" : "https://gea.esac.esa.int/tap-server/tap/sync?REQUEST=doQuery&LANG=ADQL&FORMAT=json&QUERY=SELECT+dr3.source_id,dr3.teff_gspphot,dr3.teff_gspphot_lower,dr3.teff_gspphot_upper,dr3.teff_gspspec,dr3.teff_gspspec_lower,dr3.teff_gspspec_upper,dr3.distance_gspphot,dr3.distance_gspphot_lower,dr3.distance_gspphot_upper,dr3.spectraltype_esphs,dr3.radius_gspphot,dr3.radius_gspphot_lower,dr3.radius_gspphot_upper,dr3.radius_flame,dr3.radius_flame_lower,dr3.radius_flame_upper,dr3.mass_flame,dr3.mass_flame_lower,dr3.mass_flame_upper+FROM+gaiadr3.astrophysical_parameters+AS+dr3+WHERE+dr3.source_id=XXX";
            String string2 = string.replace("XXX", Long.toString(l));
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(string2)).GET().timeout(Duration.ofSeconds(15000L)).build();
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString(Charset.forName("utf8")));
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto = objectMapper.readValue(httpResponse.body(), GaiaArchiveRawResponseDto.class);
            if (gaiaArchiveRawResponseDto.getData().length == 0 || gaiaArchiveRawResponseDto.getData()[0][0] == null) {
                return Optional.empty();
            }
            GaiaStellarDataDtoBuilder gaiaStellarDataDtoBuilder = new GaiaStellarDataDtoBuilder();
            gaiaStellarDataDtoBuilder.setDr3SourceId(gaiaArchiveRawResponseDto.getData()[0][0].toString());
            gaiaStellarDataDtoBuilder.setTeffGspphot(this.parseFieldNo(gaiaArchiveRawResponseDto, 1), this.parseFieldNo(gaiaArchiveRawResponseDto, 2), this.parseFieldNo(gaiaArchiveRawResponseDto, 3));
            gaiaStellarDataDtoBuilder.setTeffGspspec(this.parseFieldNo(gaiaArchiveRawResponseDto, 4), this.parseFieldNo(gaiaArchiveRawResponseDto, 5), this.parseFieldNo(gaiaArchiveRawResponseDto, 6));
            gaiaStellarDataDtoBuilder.setDistanceInPc(this.parseFieldNo(gaiaArchiveRawResponseDto, 7), this.parseFieldNo(gaiaArchiveRawResponseDto, 8), this.parseFieldNo(gaiaArchiveRawResponseDto, 9));
            gaiaStellarDataDtoBuilder.setSptyp((String)gaiaArchiveRawResponseDto.getData()[0][10]);
            gaiaStellarDataDtoBuilder.setRadiusGspphot(this.parseFieldNo(gaiaArchiveRawResponseDto, 11), this.parseFieldNo(gaiaArchiveRawResponseDto, 12), this.parseFieldNo(gaiaArchiveRawResponseDto, 13));
            gaiaStellarDataDtoBuilder.setRadiusFlame(this.parseFieldNo(gaiaArchiveRawResponseDto, 14), this.parseFieldNo(gaiaArchiveRawResponseDto, 15), this.parseFieldNo(gaiaArchiveRawResponseDto, 16));
            gaiaStellarDataDtoBuilder.setMass(this.parseFieldNo(gaiaArchiveRawResponseDto, 17), this.parseFieldNo(gaiaArchiveRawResponseDto, 18), this.parseFieldNo(gaiaArchiveRawResponseDto, 19));
            return Optional.of(gaiaStellarDataDtoBuilder.build());
        }
        catch (InterruptedException | RuntimeException | URISyntaxException exception) {
            this.logger.error("query failed for 'Gaia " + gaiaDataRelease.name() + " " + l + "'", exception);
            return Optional.empty();
        }
    }

    private double parseFieldNo(GaiaArchiveRawResponseDto gaiaArchiveRawResponseDto, int n) {
        Object object = gaiaArchiveRawResponseDto.getData()[0][n];
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return Double.parseDouble((String)object);
    }
}

