/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;

public abstract class TabellenBasisdialog
extends Basisdialog {
    private List<String> tableHead;
    private List<List<String>> tableData;
    protected JTableExtended ausgabe;
    private String jTableToolTipText;
    private JButton druckenButton;
    private JScrollPane scrollPane;
    protected JTextField searchTextField;
    private JToolBar toolBar;

    public TabellenBasisdialog(BasisdialogId basisdialogId) {
        super(basisdialogId);
        this.initComponents();
        this.toolBar.setFloatable(false);
        this.searchTextField.setVisible(false);
        this.searchTextField.setText(this.i18n.getString("db_gui92"));
        this.searchTextField.setSelectionStart(0);
        this.searchTextField.setSelectionEnd(this.searchTextField.getText().length());
        this.druckenButton.setText(null);
        this.druckenButton.setToolTipText(this.getSprachcontainer().getString("db_menu_32"));
        this.druckenButton.setIcon(IconPoolDefault.PRINT.getImageIcon());
    }

    public void setTabellenUeberschriften(List<String> list) {
        this.tableHead = list;
    }

    public void setTabellenDaten(List<List<String>> list) {
        this.tableData = list;
    }

    public void setJTableToolTipText(String string) {
        this.jTableToolTipText = string;
    }

    public void fireTableDataChanged() {
        this.ausgabe.setTableContent(this.tableData, this.tableHead);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.ausgabe.getModel();
        defaultTableModel.fireTableDataChanged();
    }

    public void showDialog() {
        this.ausgabe = new JTableExtended(this.tableData, this.tableHead);
        this.ausgabe.disableEditMode();
        if (this.jTableToolTipText != null) {
            this.ausgabe.setToolTipText(this.jTableToolTipText);
        }
        this.ausgabe.setVisible(true);
        this.scrollPane.setViewportView(this.ausgabe);
        this.getGuiDesigner().addComponent(this.ausgabe, false);
        this.setVisible(true);
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.druckenButton = new JButton();
        this.searchTextField = new JTextField();
        this.scrollPane = new JScrollPane();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 31));
        this.druckenButton.setText("drucken");
        this.druckenButton.setFocusable(false);
        this.druckenButton.setHorizontalTextPosition(0);
        this.druckenButton.setVerticalTextPosition(3);
        this.druckenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabellenBasisdialog.this.druckenButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.druckenButton);
        this.getContentPane().add(this.toolBar);
        this.searchTextField.setText("Suchbegriff hier eingeben");
        this.searchTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 27));
        this.getContentPane().add(this.searchTextField);
        this.scrollPane.setPreferredSize(new Dimension(20, 20));
        this.getContentPane().add(this.scrollPane);
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(null);
    }

    private void druckenButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.ausgabe.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("Planetensuche - " + this.getTitle()), null);
        }
        catch (PrinterException printerException) {
            this.getLogger().error(printerException);
            this.getLogger().showErrorMessageBox(this, printerException.getMessage(), printerException.toString());
        }
    }
}

