/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.datenbank;

import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.impl.KoordinatenKonverter;
import de.planetensuche.datenbank.dbmodel.api.IKoordinatenDAO;
import de.planetensuche.datenbank.dbmodel.api.KoordinatenDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.formeln.UmrechnungGradInDezimal;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class KoordsqueryDialog
extends Basisdialog {
    private final KoordinatenFormat koordinatenFormat;
    private final IKoordinatenDAO koordinatenDAO;
    private ButtonGroup buttonGroup1;
    private JPanel dialogkopf;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JRadioButton sortiertNachDECL;
    private JRadioButton sortiertNachRA;
    private JRadioButton sortiertNachVmag;
    private JButton suchenButton;
    private JTextField textBisDecl;
    private JTextField textBisRa;
    private JTextField textVonDecl;
    private JTextField textVonRa;

    public KoordsqueryDialog(ParameterDto parameterDto, KoordinatenFormat koordinatenFormat, IKoordinatenDAO iKoordinatenDAO) {
        super(BasisdialogId.DATENBANK_KOORDINATENABFRAGE);
        this.initComponents();
        this.koordinatenFormat = koordinatenFormat;
        this.koordinatenDAO = iKoordinatenDAO;
        this.setTitle(this.i18n.getString("db_fenster14"));
        this.jLabel1.setText(this.i18n.getString("db_gui95"));
        this.jLabel4.setText(this.i18n.getString("db_gui96"));
        this.jLabel2.setText(this.i18n.getString("db_gui97"));
        this.suchenButton.setText(null);
        this.suchenButton.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.suchenButton.setSize(24, 24);
        this.suchenButton.setToolTipText(this.i18n.getString("db_gui4"));
        this.jLabel3.setText(this.i18n.getString("db_gui98"));
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
    }

    private List<KoordinatenDto> getObjekteBeiKoordinaten(double d, double d2, double d3, double d4) {
        List<KoordinatenDto> list = this.koordinatenDAO.getObjekteBeiKoords(d, d2, d3, d4, this.sortiertNachRA.isSelected(), this.sortiertNachDECL.isSelected(), this.sortiertNachVmag.isSelected());
        return list;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.dialogkopf = new JPanel();
        this.sortiertNachVmag = new JRadioButton();
        this.sortiertNachDECL = new JRadioButton();
        this.sortiertNachRA = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.suchenButton = new JButton();
        this.textBisRa = new JTextField();
        this.textBisDecl = new JTextField();
        this.jLabel3 = new JLabel();
        this.textVonDecl = new JTextField();
        this.jLabel2 = new JLabel();
        this.textVonRa = new JTextField();
        this.jLabel1 = new JLabel();
        this.setTitle("Koordinaten-Abfrage");
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 836;
        gridBagConstraints.ipady = 266;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 13, 8);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.dialogkopf.setLayout(null);
        this.buttonGroup1.add(this.sortiertNachVmag);
        this.sortiertNachVmag.setText("VMag");
        this.sortiertNachVmag.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sortiertNachVmag.setMargin(new Insets(0, 0, 0, 0));
        this.dialogkopf.add(this.sortiertNachVmag);
        this.sortiertNachVmag.setBounds(560, 40, 97, 24);
        this.buttonGroup1.add(this.sortiertNachDECL);
        this.sortiertNachDECL.setText("DECL");
        this.sortiertNachDECL.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sortiertNachDECL.setMargin(new Insets(0, 0, 0, 0));
        this.dialogkopf.add(this.sortiertNachDECL);
        this.sortiertNachDECL.setBounds(480, 40, 70, 24);
        this.buttonGroup1.add(this.sortiertNachRA);
        this.sortiertNachRA.setSelected(true);
        this.sortiertNachRA.setText("RA");
        this.sortiertNachRA.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sortiertNachRA.setMargin(new Insets(0, 0, 0, 0));
        this.dialogkopf.add(this.sortiertNachRA);
        this.sortiertNachRA.setBounds(400, 40, 60, 24);
        this.jLabel4.setText("sortieren nach");
        this.dialogkopf.add(this.jLabel4);
        this.jLabel4.setBounds(400, 10, 160, 24);
        this.suchenButton.setText("suchen");
        this.suchenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KoordsqueryDialog.this.suchenButtonActionPerformed(actionEvent);
            }
        });
        this.dialogkopf.add(this.suchenButton);
        this.suchenButton.setBounds(490, 100, 130, 24);
        this.textBisRa.setHorizontalAlignment(0);
        this.textBisRa.setText("2.0");
        this.textBisRa.setToolTipText("2.0 / 2:0:0");
        this.dialogkopf.add(this.textBisRa);
        this.textBisRa.setBounds(230, 40, 150, 24);
        this.textBisDecl.setHorizontalAlignment(0);
        this.textBisDecl.setText("65");
        this.textBisDecl.setToolTipText("65.0 / 65:0:0");
        this.dialogkopf.add(this.textBisDecl);
        this.textBisDecl.setBounds(230, 100, 150, 24);
        this.jLabel3.setText("gefundene Objekte:");
        this.dialogkopf.add(this.jLabel3);
        this.jLabel3.setBounds(10, 150, 170, 14);
        this.textVonDecl.setHorizontalAlignment(0);
        this.textVonDecl.setText("55:0:0");
        this.textVonDecl.setToolTipText("55.0 / 55:0:0");
        this.dialogkopf.add(this.textVonDecl);
        this.textVonDecl.setBounds(10, 100, 170, 24);
        this.jLabel2.setText("DECL (von bis in Grad, von < bis)");
        this.dialogkopf.add(this.jLabel2);
        this.jLabel2.setBounds(10, 70, 240, 24);
        this.textVonRa.setHorizontalAlignment(0);
        this.textVonRa.setText("0:1:1");
        this.textVonRa.setToolTipText("0.1 / 0:1:1");
        this.dialogkopf.add(this.textVonRa);
        this.textVonRa.setBounds(10, 40, 170, 24);
        this.jLabel1.setText("RA (von bis in Stunden, von < bis)");
        this.dialogkopf.add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 240, 24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 689;
        gridBagConstraints.ipady = 169;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.getContentPane().add((Component)this.dialogkopf, gridBagConstraints);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 886) / 2, (dimension.height - 510) / 2, 886, 510);
    }

    private double getDezimalZahl(String string) {
        String[] stringArray;
        if (string.indexOf(58) > 0 && (stringArray = string.split(":")).length > 0) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            double d = Double.parseDouble(stringArray[2]);
            return UmrechnungGradInDezimal.berechne(n, n2, d);
        }
        return Double.parseDouble(string);
    }

    private void suchenButtonActionPerformed(ActionEvent actionEvent) {
        try {
            double d = this.getDezimalZahl(this.textVonRa.getText());
            double d2 = this.getDezimalZahl(this.textBisRa.getText());
            double d3 = this.getDezimalZahl(this.textVonDecl.getText());
            double d4 = this.getDezimalZahl(this.textBisDecl.getText());
            boolean bl = true;
            if (d > 24.0 || d < 0.0 || d2 > 24.0 || d2 < 0.0) {
                bl = false;
                JOptionPane.showMessageDialog(this, this.i18n.getString("db_f80"), this.i18n.getString("db_f70_titel"), 0);
            }
            if (d3 > 90.0 || d3 < -90.0 || d4 > 90.0 && d3 < -90.0) {
                bl = false;
                JOptionPane.showMessageDialog(this, this.i18n.getString("db_f72"), this.i18n.getString("db_f70_titel"), 0);
            }
            if (bl) {
                this.setCursor(new Cursor(3));
                List<KoordinatenDto> list = this.getObjekteBeiKoordinaten(d, d2, d3, d4);
                if (list != null) {
                    KoordinatenKonverter koordinatenKonverter = new KoordinatenKonverter(this.i18n);
                    ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
                    for (KoordinatenDto object2 : list) {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(object2.getObjektname());
                        koordinatenKonverter.setRa(object2.getRa());
                        koordinatenKonverter.setDecl(object2.getDecl());
                        arrayList2.add(koordinatenKonverter.toString(this.koordinatenFormat, true));
                        arrayList2.add(koordinatenKonverter.toString(this.koordinatenFormat, false));
                        if ("unbekannt".equals(object2.getSternbildName()) || "unknown".equals(object2.getSternbildName())) {
                            arrayList2.add("");
                        } else {
                            arrayList2.add(object2.getSternbildName());
                        }
                        arrayList2.add(object2.getKategorie());
                        arrayList2.add(object2.getObjektTyp());
                        if (-100.0 == object2.getScheinbareHelligkeit()) {
                            arrayList2.add("");
                        } else {
                            arrayList2.add(this.i18n.toLocalisedDouble(object2.getScheinbareHelligkeit()));
                        }
                        arrayList.add(arrayList2);
                    }
                    ArrayList arrayList3 = new ArrayList();
                    arrayList3.add(this.i18n.getString("db_m129"));
                    arrayList3.add(this.i18n.getString("db_m286"));
                    arrayList3.add(this.i18n.getString("db_m287"));
                    arrayList3.add(this.i18n.getString("db_m288"));
                    arrayList3.add(this.i18n.getString("db_m70"));
                    arrayList3.add(this.i18n.getString("db_m71"));
                    arrayList3.add(this.i18n.getString("db_m108"));
                    JTableExtended jTableExtended = new JTableExtended(arrayList, arrayList3);
                    jTableExtended.disableEditMode();
                    jTableExtended.setVisible(true);
                    this.jScrollPane1.setViewportView(jTableExtended);
                    this.getGuiDesigner().addComponent(jTableExtended, false);
                    JOptionPane.showMessageDialog(this, this.i18n.getString("db_m147") + " " + list.size() + " " + this.i18n.getString("db_m148"), this.i18n.getString("db_m148_titel"), 1);
                } else {
                    JOptionPane.showMessageDialog(this, this.i18n.getString("db_m149"), this.i18n.getString("db_m148_titel"), 1);
                }
                this.setCursor(new Cursor(0));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.getLogger().error(indexOutOfBoundsException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f16") + "\n" + indexOutOfBoundsException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }
}

