/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.datenbank;

import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.ObjectChangeLogDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.guis.datenbank.ObjekthistorieDialog;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class ObjekthistorieControler {
    private final ISprachcontainer i18n;
    private final ILogging logging;
    private final IDAOhighService daoHighService;

    public ObjekthistorieControler(ParameterDto parameterDto, IDAOhighService iDAOhighService) {
        this.i18n = parameterDto.getSprache();
        this.daoHighService = iDAOhighService;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public void showDialog(JFrame jFrame) {
        try {
            String string = JOptionPane.showInputDialog(null, this.i18n.getString("db_m4"), this.i18n.getString("db_m4_titel"), 3);
            if (string != null && !"".equals(string)) {
                int n = this.getNumberFromUserInput(string);
                AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
                asyncLoadingScreenCallbackExecutor.execute(jFrame, () -> {
                    List<ObjectChangeLogDto> list = this.daoHighService.getObjectChangeLog(n);
                    ArrayList<List<String>> arrayList = new ArrayList<List<String>>(list.size());
                    for (ObjectChangeLogDto objectChangeLogDto : list) {
                        ArrayList<String> arrayList2 = new ArrayList<String>(2);
                        arrayList2.add(objectChangeLogDto.getObjectName());
                        arrayList2.add(objectChangeLogDto.getTimestampI18n());
                        arrayList.add(arrayList2);
                    }
                    ObjekthistorieDialog objekthistorieDialog = new ObjekthistorieDialog(arrayList);
                    objekthistorieDialog.showDialog();
                });
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(null, this.i18n.getString("db_f8") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private int getNumberFromUserInput(String string) {
        int n;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            n = 30;
        }
        return n;
    }
}

