/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.datenbank;

import de.planetensuche.datenbank.SternradiusMasseErgebnisDto;
import de.planetensuche.datenbank.SternradiusUndMasseBerechnenService;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SternRadiusMasseErmittelnDialog
extends Basisdialog {
    private final SternradiusUndMasseBerechnenService service;
    private JTableExtended table;
    private JButton buttonSuchen;
    private JScrollPane jScrollPane2;
    private JLabel labelAbsMag;
    private JLabel labelBoltzmann;
    private JLabel labelEntfernung;
    private JLabel labelTemperatur;
    private JLabel labelVmag;
    private JLabel outputAbsMag;
    private JLabel outputBoltzmann;
    private JTextField textfieldEntfernung;
    private JTextField textfieldTemperatur;
    private JTextField textfieldVmag;

    public SternRadiusMasseErmittelnDialog(SternradiusUndMasseBerechnenService sternradiusUndMasseBerechnenService) {
        super(BasisdialogId.DATENBANK_STERN_RADIS_MASSE_ERMITTELN);
        this.initComponents();
        this.service = sternradiusUndMasseBerechnenService;
        this.setTitle(this.i18n.getString("db_gui122"));
        this.buttonSuchen.setText(null);
        this.buttonSuchen.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.buttonSuchen.setToolTipText(this.i18n.getString("db_gui99"));
        this.labelEntfernung.setText(this.i18n.getString("db_gui123"));
        this.labelTemperatur.setText(this.i18n.getString("db_gui126"));
        this.labelVmag.setText(this.i18n.getString("db_gui127"));
        this.labelBoltzmann.setText(this.i18n.getString("db_gui128"));
        this.labelAbsMag.setText(this.i18n.getString("db_m55"));
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        this.setSize(this.getWidth(), this.getHeight() + 20);
    }

    private void initComponents() {
        this.textfieldVmag = new JTextField();
        this.labelVmag = new JLabel();
        this.labelEntfernung = new JLabel();
        this.textfieldEntfernung = new JTextField();
        this.labelTemperatur = new JLabel();
        this.textfieldTemperatur = new JTextField();
        this.buttonSuchen = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.labelBoltzmann = new JLabel();
        this.outputBoltzmann = new JLabel();
        this.labelAbsMag = new JLabel();
        this.outputAbsMag = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.getContentPane().add((Component)this.textfieldVmag, new AbsoluteConstraints(250, 20, 140, -1));
        this.labelVmag.setText("Vmag:");
        this.getContentPane().add((Component)this.labelVmag, new AbsoluteConstraints(30, 20, 210, -1));
        this.labelEntfernung.setText("entfernung pc:");
        this.getContentPane().add((Component)this.labelEntfernung, new AbsoluteConstraints(30, 60, 210, -1));
        this.getContentPane().add((Component)this.textfieldEntfernung, new AbsoluteConstraints(250, 60, 140, -1));
        this.labelTemperatur.setText("temperatur:");
        this.getContentPane().add((Component)this.labelTemperatur, new AbsoluteConstraints(30, 100, 210, -1));
        this.getContentPane().add((Component)this.textfieldTemperatur, new AbsoluteConstraints(250, 100, 140, -1));
        this.buttonSuchen.setText("suche");
        this.buttonSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SternRadiusMasseErmittelnDialog.this.buttonSuchenActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.buttonSuchen, new AbsoluteConstraints(250, 140, 140, 30));
        this.getContentPane().add((Component)this.jScrollPane2, new AbsoluteConstraints(20, 250, 960, 272));
        this.labelBoltzmann.setText("radis boltzmann");
        this.getContentPane().add((Component)this.labelBoltzmann, new AbsoluteConstraints(30, 190, 210, -1));
        this.outputBoltzmann.setText("0");
        this.getContentPane().add((Component)this.outputBoltzmann, new AbsoluteConstraints(250, 190, 320, -1));
        this.labelAbsMag.setText("abs mag");
        this.getContentPane().add((Component)this.labelAbsMag, new AbsoluteConstraints(30, 220, 210, -1));
        this.outputAbsMag.setText("0.0");
        this.getContentPane().add((Component)this.outputAbsMag, new AbsoluteConstraints(250, 220, 140, -1));
        this.pack();
    }

    private void buttonSuchenActionPerformed(ActionEvent actionEvent) {
        try {
            double d = Double.parseDouble(this.textfieldTemperatur.getText());
            double d2 = Double.parseDouble(this.textfieldVmag.getText());
            double d3 = Double.parseDouble(this.textfieldEntfernung.getText());
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            List<SternradiusMasseErgebnisDto> list = this.service.sucheRadiusUndMasse(d2, d, d3);
            this.outputBoltzmann.setText(this.i18n.toLocalisedDouble(list.get(0).getRadiusBolzmann()) + " Rsun (" + this.i18n.getString("db_m59") + ")");
            this.outputAbsMag.setText(this.i18n.toLocalisedDouble(list.get(0).getAhInput()) + " mag");
            for (SternradiusMasseErgebnisDto sternradiusMasseErgebnisDto : list) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(sternradiusMasseErgebnisDto.getName());
                arrayList2.add(this.i18n.toLocalisedDouble(sternradiusMasseErgebnisDto.getRadiusNachbar()));
                arrayList2.add(this.i18n.toLocalisedDouble(sternradiusMasseErgebnisDto.getMasse()));
                arrayList2.add(this.i18n.toLocalisedDouble(sternradiusMasseErgebnisDto.getAh()));
                arrayList2.add(this.i18n.toLocalisedDouble(sternradiusMasseErgebnisDto.getTemperatur()));
                arrayList2.add(sternradiusMasseErgebnisDto.getSptyp() != null ? sternradiusMasseErgebnisDto.getSptyp() : "");
                arrayList.add(arrayList2);
            }
            List<String> list2 = Arrays.asList(this.i18n.getString("db_m5"), this.i18n.getString("db_gui125"), this.i18n.getString("db_gui124"), this.i18n.getString("db_m110"), this.i18n.getString("db_m112"), this.i18n.getString("db_m54"));
            if (this.table == null) {
                this.table = new JTableExtended(arrayList, list2);
                this.table.disableEditMode();
                this.table.setVisible(true);
                this.jScrollPane2.setViewportView(this.table);
                this.getGuiDesigner().addComponent(this.table, false);
            } else {
                this.table.setTableContent(arrayList, list2);
            }
            this.table.getColumnModel().getColumn(0).setMinWidth(180);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f119"), "", 0);
        }
    }
}

