/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.datenbank;

import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public final class SternbildErmittelnDialog
extends Basisdialog {
    private final ISprachcontainer sprache;
    private final SternbildFinder sternbildFinder;
    private JTextField declTextfeld;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField raTextfeld;
    private JLabel sternbildLabel;
    private JButton suchenButton;

    public SternbildErmittelnDialog(SternbildFinder sternbildFinder) {
        super(BasisdialogId.DATENBANK_STERNBILD_ERMITTELN);
        this.initComponents();
        this.sternbildFinder = sternbildFinder;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.setTitle(this.sprache.getString("db_fenster16"));
        this.jLabel3.setText(this.sprache.getHtmlString("db_gui101"));
        this.jLabel1.setText(this.sprache.getString("db_m286"));
        this.jLabel2.setText(this.sprache.getString("db_m287"));
        this.jLabel4.setText(this.sprache.getString("db_gui100"));
        this.suchenButton.setText(null);
        this.suchenButton.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.suchenButton.setSize(24, 24);
        this.suchenButton.setToolTipText(this.sprache.getString("db_gui99"));
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
    }

    private void initComponents() {
        this.raTextfeld = new JTextField();
        this.declTextfeld = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.suchenButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.sternbildLabel = new JLabel();
        this.setTitle("Sternbild ermitteln");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.raTextfeld.setText("7.6");
        this.getContentPane().add(this.raTextfeld);
        this.raTextfeld.setBounds(20, 130, 110, 24);
        this.declTextfeld.setText("5.22");
        this.getContentPane().add(this.declTextfeld);
        this.declTextfeld.setBounds(160, 130, 110, 24);
        this.jLabel1.setText("RA in Stunden");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 110, 120, 24);
        this.jLabel2.setText("DECL in Grad");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(160, 110, 130, 24);
        this.suchenButton.setText("ermitteln");
        this.suchenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SternbildErmittelnDialog.this.suchenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.suchenButton);
        this.suchenButton.setBounds(300, 130, 110, 24);
        this.jLabel3.setText("<html>Es wird fuer die angegebene Koordinate ein Sternbild an Hand international<br>festgelegter Sternbildgrenzen ermittelt.</html>");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(20, 10, 390, 80);
        this.jLabel4.setText("vermutliches Sternbild:");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(20, 170, 250, 24);
        this.sternbildLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(this.sternbildLabel);
        this.sternbildLabel.setBounds(20, 200, 250, 24);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 436) / 2, (dimension.height - 269) / 2, 436, 269);
    }

    private void suchenButtonActionPerformed(ActionEvent actionEvent) {
        try {
            double d = Double.parseDouble(this.raTextfeld.getText());
            double d2 = Double.parseDouble(this.declTextfeld.getText());
            String string = this.sternbildFinder.getSternbildCodeFuerKoordinate(d, d2);
            this.sternbildLabel.setText(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.sternbildLabel.setText(this.sprache.getString("db_m289"));
            this.getLogger().error(numberFormatException);
        }
    }
}

