/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.doublestar;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.doublestar.queries.CorotBinaryDto;
import de.planetensuche.datenbank.doublestar.queries.DoubleStarCatalogService;
import de.planetensuche.datenbank.doublestar.queries.DoubleStarDto;
import de.planetensuche.datenbank.doublestar.queries.EclipsingBinaryCatalogDto;
import de.planetensuche.datenbank.doublestar.queries.GaiaRvDataAnalysisService;
import de.planetensuche.datenbank.doublestar.queries.GalahSurveyDto;
import de.planetensuche.datenbank.doublestar.queries.KeltFalsePositiveDto;
import de.planetensuche.datenbank.doublestar.queries.KeplerEbCatalogService;
import de.planetensuche.datenbank.doublestar.queries.PlanetensucheResponseDto;
import de.planetensuche.datenbank.doublestar.queries.PlanetensucheSearchService;
import de.planetensuche.datenbank.doublestar.queries.SesameResponseDto;
import de.planetensuche.datenbank.doublestar.queries.SesameService;
import de.planetensuche.datenbank.doublestar.queries.SimbadObjectTypTrafficLightService;
import de.planetensuche.datenbank.doublestar.queries.SuperWaspFalsePositiveDto;
import de.planetensuche.datenbank.doublestar.queries.VizierCorotBinariesService;
import de.planetensuche.datenbank.doublestar.queries.VizierGalahSurveySb2Service;
import de.planetensuche.datenbank.doublestar.queries.VizierKeltFalsePositiveService;
import de.planetensuche.datenbank.doublestar.queries.VizierSuperWaspFalsePositiveService;
import de.planetensuche.datenbank.doublestar.queries.VizierTessEbCatalogService;
import de.planetensuche.datenbank.doublestar.queries.VizierTessOBAtypeEbCatalogService;
import de.planetensuche.datenbank.gaia.doublestar.GaiaAstrometricDto;
import de.planetensuche.datenbank.gaia.doublestar.GaiaDoubleStarIndicatorService;
import de.planetensuche.datenbank.guis.doublestar.DoubleStarCheckDialog;
import de.planetensuche.datenbank.guis.doublestar.JLabelHtmlLinkListener;
import de.planetensuche.datenbank.guis.doublestar.JLabelPlanetensucheListener;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.tic.VizierTicCatalogDto;
import de.planetensuche.datenbank.tic.VizierTicCatalogQueryService;
import de.planetensuche.datenbank.vsx.AavsoDatabaseApiClient;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class DoubleStarCheckDialogController {
    private static final String I18N_KEY_NO_DATA = "db_m488";
    private static final String I18N_KEY_NO_ENTRY = "db_m500";
    private static final String I18N_KEY_YES = "true";
    private static final String I18N_KEY_NO = "false";
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IObjekttypenRepository objekttypenRepository;
    private final Katalogerkenner katalogerkenner;
    private final IObjektnamenRepository objektnamenRepository;
    private final DatenbankDialog datenbankDialog;
    private final DoubleStarCheckDialog dialog = new DoubleStarCheckDialog();
    private final KonfigurationDTO konfiguration;
    private final SesameService sesameService;
    private final GaiaRvDataAnalysisService gaiaRvDataAnalysisService;
    private final VizierTicCatalogQueryService vizierTicCatalogService;

    public DoubleStarCheckDialogController(IObjekttypenRepository iObjekttypenRepository, Katalogerkenner katalogerkenner, IObjektnamenRepository iObjektnamenRepository, KonfigurationDTO konfigurationDTO, DatenbankDialog datenbankDialog, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.objekttypenRepository = iObjekttypenRepository;
        this.katalogerkenner = katalogerkenner;
        this.objektnamenRepository = iObjektnamenRepository;
        this.konfiguration = konfigurationDTO;
        this.datenbankDialog = datenbankDialog;
        this.sesameService = new SesameService();
        this.gaiaRvDataAnalysisService = new GaiaRvDataAnalysisService(iDatenbankverbinder, iIdCacheDAO);
        this.vizierTicCatalogService = new VizierTicCatalogQueryService();
    }

    public void showDialog() {
        EventQueue.invokeLater(() -> {
            this.addButtonListener();
            this.addLinkListener();
            this.dialog.setVisible(true);
        });
    }

    private void addLinkListener() {
        JLabelHtmlLinkListener jLabelHtmlLinkListener = new JLabelHtmlLinkListener(this.konfiguration);
        this.dialog.getLabelSimbadLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelTessEbLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelKeplerEbLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelSuperWaspLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelGalahSurveyLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelCorotLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelKeltLink().addMouseListener(jLabelHtmlLinkListener);
        this.dialog.getLabelTessObaLink().addMouseListener(jLabelHtmlLinkListener);
        JLabelPlanetensucheListener jLabelPlanetensucheListener = new JLabelPlanetensucheListener(this.datenbankDialog);
        this.dialog.getLabelPlanetensucheLink().addMouseListener(jLabelPlanetensucheListener);
    }

    private void addButtonListener() {
        this.dialog.getButtonCheck().addActionListener(actionEvent -> Executors.newSingleThreadExecutor().submit(() -> {
            this.clearAllOutputFields();
            this.startScan(this.dialog.getInputTicId().getText().trim());
        }));
        this.dialog.getButtonCopy().addActionListener(actionEvent -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getI18n("db_gui155")).append("\n");
            stringBuilder.append("---------------------------------------------\n");
            stringBuilder.append(this.getI18n("db_gui149")).append(" ").append(this.dialog.getInputTicId().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui156")).append(" ").append(this.dialog.getOutputSimbadOtyp().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui160")).append(" ").append(this.dialog.getOutputPlanetensucheOtyp().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui158")).append(" ").append(this.dialog.getOutputDoubleStarCatalog().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui150")).append(" ").append(this.dialog.getInputGaiaId().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui151")).append(" ").append(this.dialog.getOutputGaiaNonSingle().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui152")).append(" ").append(this.dialog.getOutputRuwe().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui153")).append(" ").append(this.dialog.getOutputAstrometricNoise().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui189")).append(" ").append(this.dialog.getOutputGaiaRvError().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui157")).append(" ").append(this.dialog.getOutputTessEb().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui159")).append(" ").append(this.dialog.getOutputKeplerEb().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui184")).append(" ").append(this.dialog.getOutputSuperWasp().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui186")).append(" ").append(this.dialog.getOutputCorot().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui187")).append(" ").append(this.dialog.getOutputKelt().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui185")).append(" ").append(this.dialog.getOutputGalahSurvey().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui199")).append(" ").append(this.dialog.getOutputTessOba().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui202")).append(" ").append(this.dialog.getOutputAavso().getText()).append("\n");
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
        });
    }

    private String getI18n(String string) {
        return this.dialog.getSprachcontainer().getString(string);
    }

    public void disposeDialog() {
        this.dialog.dispose();
    }

    public DoubleStarCheckDialog getDialog() {
        return this.dialog;
    }

    boolean startScan(String string) {
        long l;
        if (Check.isEmpty(string)) {
            String string2 = this.dialog.getI18n().getString("db_m485");
            String string3 = this.dialog.getI18n().getString("db_m486");
            JOptionPane.showMessageDialog(this.dialog, string2, string3, 1);
            return false;
        }
        try {
            l = Long.parseLong(string);
            if (l < 1L) {
                String string4 = this.dialog.getI18n().getString("db_f121");
                String string5 = this.dialog.getI18n().getString("db_f121_titel");
                JOptionPane.showMessageDialog(this.dialog, string4, string5, 2);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string6 = this.dialog.getI18n().getString("db_f121");
            String string7 = this.dialog.getI18n().getString("db_f121_titel");
            JOptionPane.showMessageDialog(this.dialog, string6, string7, 2);
            return false;
        }
        this.dialog.getButtonCheck().setEnabled(false);
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Optional<VizierTicCatalogDto> optional = this.vizierTicCatalogService.findByTicId(l);
            if (optional.isEmpty()) {
                this.dialog.setCursor(Cursor.getDefaultCursor());
                this.dialog.getButtonCheck().setEnabled(true);
                String string8 = this.dialog.getI18n().getString("db_f121");
                String string9 = this.dialog.getI18n().getString("db_f121_titel");
                JOptionPane.showMessageDialog(this.dialog, string8, string9, 2);
                return false;
            }
            String string10 = null;
            if (optional.get().getGaiaDr2Id() != null) {
                string10 = "Gaia DR2 " + optional.get().getGaiaDr2Id();
            }
            Optional<SesameResponseDto> optional2 = this.sesameService.querySesame(l);
            String string11 = this.processSesameResultAndReturnGaiaName(optional2);
            long l2 = this.extractGaiaDr3IdFromSesame(optional2);
            Object object = string10 != null ? string10 : string11;
            Set<String> set = this.queryPlanetensucheReturnStarNames(string, optional2);
            this.showDoubleStarCatalogEntry(optional2, set);
            ExecutorService executorService = Executors.newWorkStealingPool();
            ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>();
            arrayList.add(() -> this.lambda$startScan$4((String)object));
            arrayList.add(() -> {
                this.queryTessEbCatalog(string);
                return null;
            });
            arrayList.add(() -> {
                this.queryKeplerEbCatalog(optional2, optional);
                return null;
            });
            arrayList.add(() -> {
                this.querySuperWaspCatalog(l);
                return null;
            });
            arrayList.add(() -> {
                this.queryCorotCatalog(optional2);
                return null;
            });
            arrayList.add(() -> {
                this.queryKeltCatalog(string);
                return null;
            });
            arrayList.add(() -> this.lambda$startScan$10((String)object));
            arrayList.add(() -> {
                this.queryTessObaEbCatalog(string);
                return null;
            });
            arrayList.add(() -> {
                this.queryAavsoVsxCatalog(optional, l2);
                return null;
            });
            executorService.invokeAll(arrayList);
            this.dialog.setCursor(Cursor.getDefaultCursor());
            this.dialog.getButtonCheck().setEnabled(true);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            this.dialog.setCursor(Cursor.getDefaultCursor());
            this.dialog.getButtonCheck().setEnabled(true);
            JOptionPane.showMessageDialog(this.getDialog(), this.getI18n("db_m450"), this.getI18n("db_m144"), 2);
            return false;
        }
        catch (InterruptedException | RuntimeException exception) {
            this.logger.error("TIC id=" + string, exception);
            this.dialog.setCursor(Cursor.getDefaultCursor());
            this.dialog.getButtonCheck().setEnabled(true);
            return false;
        }
    }

    private void showSimbadNoData() {
        this.dialog.getOutputSimbadOtyp().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
        this.dialog.getOutputSimbadOtypStatus().setIcon(null);
        this.dialog.getLabelSimbadLink().setText("");
    }

    private String processSesameResultAndReturnGaiaName(Optional<SesameResponseDto> optional) {
        if (optional.isPresent() && Check.isFilled(optional.get().getSimbadObjectType())) {
            SesameResponseDto sesameResponseDto = optional.get();
            this.dialog.getOutputSimbadOtyp().setText(sesameResponseDto.getSimbadObjectType());
            SimbadObjectTypTrafficLightService simbadObjectTypTrafficLightService = new SimbadObjectTypTrafficLightService();
            IconPoolCustom iconPoolCustom = simbadObjectTypTrafficLightService.getTrafficLightForDoubleStar(sesameResponseDto.getSimbadObjectTypeShort());
            ImageIcon imageIcon = this.getScaledTrafficLightIcon(iconPoolCustom);
            imageIcon.setDescription(iconPoolCustom.name());
            this.dialog.getOutputSimbadOtypStatus().setIcon(imageIcon);
            String string = "<html><a href=\"" + sesameResponseDto.getSimbadLink() + "\">link</a></html>";
            this.dialog.getLabelSimbadLink().setText(string);
            return sesameResponseDto.getGaiaName();
        }
        this.showSimbadNoData();
        if (optional.isPresent()) {
            return optional.get().getGaiaName();
        }
        return null;
    }

    private void queryTessEbCatalog(String string) {
        VizierTessEbCatalogService vizierTessEbCatalogService = new VizierTessEbCatalogService();
        Optional<EclipsingBinaryCatalogDto> optional = vizierTessEbCatalogService.query(string);
        if (optional.isEmpty()) {
            this.dialog.getOutputTessEb().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputTessEbStatus().setIcon(null);
            return;
        }
        EclipsingBinaryCatalogDto eclipsingBinaryCatalogDto = optional.get();
        IconPoolCustom iconPoolCustom = eclipsingBinaryCatalogDto.getEntryStatus();
        this.dialog.getOutputTessEbStatus().setIcon(this.getScaledTrafficLightIcon(iconPoolCustom));
        String string2 = "<html><a href=\"" + eclipsingBinaryCatalogDto.getLink() + "\">link</a></html>";
        this.dialog.getLabelTessEbLink().setText(string2);
        this.dialog.getOutputTessEb().setText(this.dialog.getI18n().getString(I18N_KEY_YES));
        if (eclipsingBinaryCatalogDto.getPeriodInDays() != null) {
            this.dialog.getOutputTessEb().setText(this.dialog.getOutputTessEb().getText() + " (" + eclipsingBinaryCatalogDto.getPeriodInDays() + " days)");
        }
    }

    private void queryKeplerEbCatalog(Optional<SesameResponseDto> optional, Optional<VizierTicCatalogDto> optional2) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        if (optional.isPresent()) {
            object3 = optional.get().getNames();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!((String)object).startsWith("KIC ")) continue;
                object4 = object;
                break;
            }
        }
        if (object4 == null && optional2.isPresent() && optional2.get().getKicId() != null) {
            object4 = "KIC " + optional2.get().getKicId();
        }
        if (object4 != null) {
            object3 = new KeplerEbCatalogService();
            object2 = ((KeplerEbCatalogService)object3).findEntry((String)object4);
            object = ((EclipsingBinaryCatalogDto)object2).getEntryStatus();
            this.dialog.getOutputKeplerEbStatus().setIcon(this.getScaledTrafficLightIcon((IconPoolCustom)((Object)object)));
            String string = "<html><a href=\"" + ((EclipsingBinaryCatalogDto)object2).getLink() + "\">link</a></html>";
            this.dialog.getLabelKeplerEbLink().setText(string);
            switch (1.$SwitchMap$de$planetensuche$guidesigner$icons$IconPoolCustom[((Enum)object).ordinal()]) {
                case 1: {
                    this.dialog.getOutputKeplerEb().setText(this.dialog.getI18n().getString(I18N_KEY_YES));
                    break;
                }
                case 2: {
                    this.dialog.getOutputKeplerEb().setText(this.dialog.getI18n().getString(I18N_KEY_NO));
                    break;
                }
                default: {
                    this.dialog.getOutputKeplerEb().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
                    break;
                }
            }
        } else {
            this.dialog.getOutputKeplerEb().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            this.dialog.getOutputKeplerEbStatus().setIcon(null);
        }
    }

    void queryGaia(String string) {
        if (Check.isEmpty(string)) {
            this.logger.info("found no Gaia name for TIC " + this.getDialog().getInputTicId().getText());
            this.dialog.getInputGaiaId().setText(this.dialog.getI18n().getString("db_m487"));
            this.showGaiaNoData();
            return;
        }
        this.dialog.getInputGaiaId().setText(string);
        GaiaDoubleStarIndicatorService gaiaDoubleStarIndicatorService = new GaiaDoubleStarIndicatorService();
        Optional<GaiaAstrometricDto> optional = gaiaDoubleStarIndicatorService.queryGaia(string);
        if (optional.isEmpty()) {
            this.showGaiaNoData();
            return;
        }
        GaiaAstrometricDto gaiaAstrometricDto = optional.get();
        if (gaiaAstrometricDto.getIsSingleStar() != null) {
            if (gaiaAstrometricDto.getIsSingleStar().booleanValue()) {
                this.dialog.getOutputGaiaNonSingle().setText(this.dialog.getI18n().getString(I18N_KEY_NO));
                this.dialog.getOutputGaiaNonSingleStatus().setIcon(this.getScaledTrafficLightIcon(gaiaAstrometricDto.getNonSingleStarStatus()));
            } else {
                this.dialog.getOutputGaiaNonSingle().setText(this.dialog.getI18n().getString(I18N_KEY_YES) + " (" + gaiaAstrometricDto.getNonSingleStarType().toReadableString() + ")");
                this.dialog.getOutputGaiaNonSingleStatus().setIcon(this.getScaledTrafficLightIcon(gaiaAstrometricDto.getNonSingleStarStatus()));
            }
        } else {
            this.dialog.getOutputGaiaNonSingle().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
        }
        if (gaiaAstrometricDto.getRuwe() != null) {
            this.dialog.getOutputRuwe().setText(this.dialog.getI18n().toLocalisedDouble(gaiaAstrometricDto.getRuwe()));
            this.dialog.getOutputRuweStatus().setIcon(this.getScaledTrafficLightIcon(gaiaAstrometricDto.getRuweStatus()));
        } else {
            this.dialog.getOutputRuwe().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
        }
        if (gaiaAstrometricDto.getAstrometricExcessNoiseSignificance() != null) {
            this.dialog.getOutputAstrometricNoise().setText(this.dialog.getI18n().toLocalisedDouble(gaiaAstrometricDto.getAstrometricExcessNoiseSignificance()));
            this.dialog.getOutputAstrometricNoiseStatus().setIcon(this.getScaledTrafficLightIcon(gaiaAstrometricDto.getAstrometricStatus()));
        } else {
            this.dialog.getOutputAstrometricNoise().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
        }
        if (gaiaAstrometricDto.getRvErrorInMeterPerSeconds() != null) {
            String string2 = this.dialog.getI18n().toLocalisedDouble(gaiaAstrometricDto.getRvErrorInMeterPerSeconds() / 1000.0);
            String string3 = this.dialog.getI18n().toLocalisedDouble(gaiaAstrometricDto.getRvInMeterPerSeconds() / 1000.0);
            int n = this.gaiaRvDataAnalysisService.getPercentOfEbsWithHigherRvError(gaiaAstrometricDto.getRvErrorInMeterPerSeconds() / 1000.0);
            Object object = this.dialog.getI18n().getString("db_gui200", n);
            int n2 = this.gaiaRvDataAnalysisService.getPercentOfStarsWithExoplanetsWithHigherRvError(gaiaAstrometricDto.getRvErrorInMeterPerSeconds() / 1000.0);
            object = (String)object + " " + this.dialog.getI18n().getString("db_gui201", n2);
            this.dialog.getOutputGaiaRvError().setText(string3 + " +- " + string2 + " km/s [EBs >" + n + "%; Exoplanets >" + n2 + "%]");
            this.dialog.getOutputGaiaRvError().setToolTipText((String)object);
            this.dialog.getOutputGaiaRvErrorStatus().setIcon(this.getScaledTrafficLightIcon(gaiaAstrometricDto.getRvErrorStatus()));
        } else {
            this.dialog.getOutputGaiaRvError().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
        }
    }

    private void showGaiaNoData() {
        String string = this.dialog.getI18n().getString(I18N_KEY_NO_DATA);
        this.dialog.getOutputGaiaNonSingle().setText(string);
        this.dialog.getOutputRuwe().setText(string);
        this.dialog.getOutputAstrometricNoise().setText(string);
        this.dialog.getOutputGaiaRvError().setText(string);
    }

    private Set<String> queryPlanetensucheReturnStarNames(String string, Optional<SesameResponseDto> optional) {
        PlanetensucheSearchService planetensucheSearchService = new PlanetensucheSearchService(this.objekttypenRepository, this.objektnamenRepository);
        Optional<PlanetensucheResponseDto> optional2 = planetensucheSearchService.queryPlanetensuche("TIC " + string, optional);
        if (optional2.isEmpty()) {
            this.dialog.getOutputPlanetensucheOtyp().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            this.dialog.getOutputPlanetensucheOtypStatus().setIcon(null);
            this.dialog.getLabelPlanetensucheLink().setText("");
            return null;
        }
        PlanetensucheResponseDto planetensucheResponseDto = optional2.get();
        this.dialog.getOutputPlanetensucheOtyp().setText(this.dialog.getI18n().getUebersetzungFuerAktuelleSprache(planetensucheResponseDto.getObjectType()));
        this.dialog.getOutputPlanetensucheOtypStatus().setIcon(this.getScaledTrafficLightIcon(planetensucheResponseDto.getIsDoubleStar()));
        String string2 = "<html><a href=\"" + planetensucheResponseDto.getPlanetensucheStarNames().iterator().next() + "\">link</a></html>";
        this.dialog.getLabelPlanetensucheLink().setText(string2);
        return planetensucheResponseDto.getPlanetensucheStarNames();
    }

    private void showDoubleStarCatalogEntry(Optional<SesameResponseDto> optional, Set<String> set) {
        if (optional.isEmpty() && set == null && Check.isEmpty(set)) {
            this.dialog.getOutputDoubleStarCatalog().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            this.dialog.getOutputDoubleStarCatalogStatus().setIcon(null);
            return;
        }
        DoubleStarCatalogService doubleStarCatalogService = new DoubleStarCatalogService(this.katalogerkenner);
        DoubleStarDto doubleStarDto = null;
        if (optional.isPresent()) {
            doubleStarDto = doubleStarCatalogService.getDoubleStarCatalog(optional.get().getNames());
        }
        if (Check.isFilled(set) && (doubleStarDto == null || Check.isEmpty(doubleStarDto.getStarName()))) {
            doubleStarDto = doubleStarCatalogService.getDoubleStarCatalog(set);
        }
        if (doubleStarDto != null) {
            if (Check.isEmpty(doubleStarDto.getStarName())) {
                this.dialog.getOutputDoubleStarCatalog().setText(this.dialog.getI18n().getString(I18N_KEY_NO));
            } else {
                this.dialog.getOutputDoubleStarCatalog().setText(doubleStarDto.getStarName());
            }
            this.dialog.getOutputDoubleStarCatalogStatus().setIcon(this.getScaledTrafficLightIcon(doubleStarDto.getDoubleStarStatus()));
        }
    }

    private ImageIcon getScaledTrafficLightIcon(IconPoolCustom iconPoolCustom) {
        Image image = iconPoolCustom.getImageIcon().getImage();
        Image image2 = image.getScaledInstance(12, 24, 4);
        return new ImageIcon(image2);
    }

    private void clearAllOutputFields() {
        this.dialog.getInputGaiaId().setText("");
        this.dialog.getOutputAstrometricNoise().setText("");
        this.dialog.getOutputAstrometricNoiseStatus().setIcon(null);
        this.dialog.getOutputGaiaNonSingle().setText("");
        this.dialog.getOutputGaiaNonSingleStatus().setIcon(null);
        this.dialog.getOutputRuwe().setText("");
        this.dialog.getOutputRuweStatus().setIcon(null);
        this.dialog.getOutputGaiaRvError().setText("");
        this.dialog.getOutputGaiaRvErrorStatus().setIcon(null);
        this.dialog.getOutputSimbadOtyp().setText("");
        this.dialog.getOutputSimbadOtypStatus().setIcon(null);
        this.dialog.getOutputTessEb().setText("");
        this.dialog.getOutputTessEbStatus().setIcon(null);
        this.dialog.getOutputKeplerEb().setText("");
        this.dialog.getOutputKeplerEbStatus().setIcon(null);
        this.dialog.getOutputPlanetensucheOtyp().setText("");
        this.dialog.getOutputPlanetensucheOtypStatus().setIcon(null);
        this.dialog.getOutputDoubleStarCatalog().setText("");
        this.dialog.getOutputDoubleStarCatalogStatus().setIcon(null);
        this.dialog.getOutputSuperWasp().setText("");
        this.dialog.getOutputSuperWaspStatus().setIcon(null);
        this.dialog.getOutputGalahSurvey().setText("");
        this.dialog.getOutputGalahSurveyStatus().setIcon(null);
        this.dialog.getOutputCorot().setText("");
        this.dialog.getOutputCorotStatus().setIcon(null);
        this.dialog.getOutputKelt().setText("");
        this.dialog.getOutputKeltStatus().setIcon(null);
        this.dialog.getOutputTessOba().setText("");
        this.dialog.getOutputTessObaStatus().setIcon(null);
        this.dialog.getOutputAavso().setText("");
        this.dialog.getOutputAavsoStatus().setIcon(null);
        this.dialog.getLabelSimbadLink().setText("");
        this.dialog.getLabelPlanetensucheLink().setText("");
        this.dialog.getLabelTessEbLink().setText("");
        this.dialog.getLabelKeplerEbLink().setText("");
        this.dialog.getLabelSuperWaspLink().setText("");
        this.dialog.getLabelGalahSurveyLink().setText("");
        this.dialog.getLabelCorotLink().setText("");
        this.dialog.getLabelKeltLink().setText("");
        this.dialog.getLabelTessObaLink().setText("");
    }

    private void querySuperWaspCatalog(long l) {
        VizierSuperWaspFalsePositiveService vizierSuperWaspFalsePositiveService = new VizierSuperWaspFalsePositiveService();
        Optional<SuperWaspFalsePositiveDto> optional = vizierSuperWaspFalsePositiveService.querySuperWasp(l);
        if (optional.isEmpty()) {
            this.dialog.getOutputSuperWasp().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputSuperWaspStatus().setIcon(null);
            return;
        }
        SuperWaspFalsePositiveDto superWaspFalsePositiveDto = optional.get();
        Object object = superWaspFalsePositiveDto.getFlag();
        if (Check.isFilled(superWaspFalsePositiveDto.getFollowupFlag())) {
            object = (String)object + " (" + superWaspFalsePositiveDto.getFollowupFlag() + ")";
        }
        this.dialog.getOutputSuperWasp().setText((String)object);
        this.dialog.getOutputSuperWaspStatus().setIcon(this.getScaledTrafficLightIcon(superWaspFalsePositiveDto.getFlagStatus()));
        String string = "<html><a href=\"" + superWaspFalsePositiveDto.getLink() + "\">link</a></html>";
        this.dialog.getLabelSuperWaspLink().setText(string);
    }

    private void queryGalahSurveyCatalog(String string) {
        if (Check.isEmpty(string)) {
            this.dialog.getOutputGalahSurvey().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            this.dialog.getOutputGalahSurveyStatus().setIcon(null);
            return;
        }
        VizierGalahSurveySb2Service vizierGalahSurveySb2Service = new VizierGalahSurveySb2Service();
        Optional<GalahSurveyDto> optional = vizierGalahSurveySb2Service.query(string);
        if (optional.isEmpty()) {
            this.dialog.getOutputGalahSurvey().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputGalahSurveyStatus().setIcon(null);
            return;
        }
        GalahSurveyDto galahSurveyDto = optional.get();
        this.dialog.getOutputGalahSurvey().setText(this.dialog.getI18n().getString(I18N_KEY_YES));
        this.dialog.getOutputGalahSurveyStatus().setIcon(this.getScaledTrafficLightIcon(galahSurveyDto.getStatus()));
        String string2 = "<html><a href=\"" + galahSurveyDto.getLink() + "\">link</a></html>";
        this.dialog.getLabelGalahSurveyLink().setText(string2);
    }

    private void queryCorotCatalog(Optional<SesameResponseDto> optional) {
        if (optional.isEmpty()) {
            this.dialog.getOutputCorot().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            this.dialog.getOutputCorotStatus().setIcon(null);
            return;
        }
        String string = null;
        for (String optional22 : optional.get().getNames()) {
            if (!optional22.toLowerCase().startsWith("corot ")) continue;
            string = optional22.split(" ")[1];
            break;
        }
        if (string == null) {
            this.dialog.getOutputCorot().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            this.dialog.getOutputCorotStatus().setIcon(null);
            return;
        }
        VizierCorotBinariesService vizierCorotBinariesService = new VizierCorotBinariesService();
        Optional<CorotBinaryDto> optional2 = vizierCorotBinariesService.query(string);
        if (optional2.isPresent()) {
            CorotBinaryDto corotBinaryDto = optional2.get();
            this.dialog.getOutputCorot().setText(this.dialog.getI18n().getString(I18N_KEY_YES));
            if (corotBinaryDto.getPeriodInDays() != null) {
                this.dialog.getOutputCorot().setText(this.dialog.getOutputCorot().getText() + " (" + corotBinaryDto.getPeriodInDays() + " days)");
            }
            this.dialog.getOutputCorotStatus().setIcon(this.getScaledTrafficLightIcon(corotBinaryDto.getStatus()));
            String string2 = "<html><a href=\"" + corotBinaryDto.getLink() + "\">link</a></html>";
            this.dialog.getLabelCorotLink().setText(string2);
        } else {
            this.dialog.getOutputCorot().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputCorotStatus().setIcon(null);
        }
    }

    private void queryKeltCatalog(String string) {
        VizierKeltFalsePositiveService vizierKeltFalsePositiveService = new VizierKeltFalsePositiveService();
        Optional<KeltFalsePositiveDto> optional = vizierKeltFalsePositiveService.query(string);
        if (optional.isEmpty()) {
            this.dialog.getOutputKelt().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputKeltStatus().setIcon(null);
            return;
        }
        KeltFalsePositiveDto keltFalsePositiveDto = optional.get();
        this.dialog.getOutputKelt().setText(keltFalsePositiveDto.getType());
        if (keltFalsePositiveDto.getPeriodInDays() != null) {
            this.dialog.getOutputKelt().setText(this.dialog.getOutputKelt().getText() + "; " + keltFalsePositiveDto.getPeriodInDays() + " days");
        }
        this.dialog.getOutputKeltStatus().setIcon(this.getScaledTrafficLightIcon(keltFalsePositiveDto.getStatus()));
        String string2 = "<html><a href=\"" + keltFalsePositiveDto.getLink() + "\">link</a></html>";
        this.dialog.getLabelKeltLink().setText(string2);
    }

    private void queryTessObaEbCatalog(String string) {
        VizierTessOBAtypeEbCatalogService vizierTessOBAtypeEbCatalogService = new VizierTessOBAtypeEbCatalogService();
        Optional<EclipsingBinaryCatalogDto> optional = vizierTessOBAtypeEbCatalogService.query(string);
        if (optional.isEmpty()) {
            this.dialog.getOutputTessOba().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputTessObaStatus().setIcon(null);
            return;
        }
        EclipsingBinaryCatalogDto eclipsingBinaryCatalogDto = optional.get();
        IconPoolCustom iconPoolCustom = eclipsingBinaryCatalogDto.getEntryStatus();
        this.dialog.getOutputTessObaStatus().setIcon(this.getScaledTrafficLightIcon(iconPoolCustom));
        String string2 = "<html><a href=\"" + eclipsingBinaryCatalogDto.getLink() + "\">link</a></html>";
        this.dialog.getLabelTessObaLink().setText(string2);
        this.dialog.getOutputTessOba().setText(this.dialog.getI18n().getString(I18N_KEY_YES));
        if (eclipsingBinaryCatalogDto.getPeriodInDays() != null) {
            this.dialog.getOutputTessOba().setText(this.dialog.getOutputTessOba().getText() + " (" + eclipsingBinaryCatalogDto.getPeriodInDays() + " days)");
        }
    }

    private void queryAavsoVsxCatalog(Optional<VizierTicCatalogDto> optional, long l) {
        VizierTicCatalogDto vizierTicCatalogDto = optional.get();
        AavsoDatabaseApiClient aavsoDatabaseApiClient = new AavsoDatabaseApiClient();
        double d = vizierTicCatalogDto.getRaJ2000() * 360.0 / 24.0;
        Optional<StarObjectType> optional2 = aavsoDatabaseApiClient.fetchObjectType(vizierTicCatalogDto.getTicId(), d, vizierTicCatalogDto.getDeclJ2000(), l);
        if (optional2.isEmpty()) {
            this.dialog.getOutputAavso().setText(this.dialog.getI18n().getString(I18N_KEY_NO_ENTRY));
            this.dialog.getOutputAavsoStatus().setIcon(null);
            return;
        }
        StarObjectType starObjectType = optional2.get();
        this.dialog.getOutputAavso().setText(this.dialog.getI18n().getUebersetzungFuerAktuelleSprache(starObjectType.getTypeName()));
        if (StarObjectType.DOUBLE_STAR_REAL.equals((Object)starObjectType) || StarObjectType.ECLIPSING_BINARY.equals((Object)starObjectType) || StarObjectType.ECLIPSING_BINARY_CANDIDATE.equals((Object)starObjectType) || StarObjectType.MULTI_STAR_SYSTEM.equals((Object)starObjectType)) {
            this.dialog.getOutputKeltStatus().setIcon(this.getScaledTrafficLightIcon(IconPoolCustom.AMPEL_GRUEN));
        } else {
            this.dialog.getOutputKeltStatus().setIcon(this.getScaledTrafficLightIcon(IconPoolCustom.AMPEL_GELB));
        }
    }

    private long extractGaiaDr3IdFromSesame(Optional<SesameResponseDto> optional) {
        if (optional.isPresent()) {
            Set<String> set = optional.get().getNames();
            for (String string : set) {
                if (!string.startsWith("Gaia DR3 ")) continue;
                return Long.parseLong(string.substring(9).trim());
            }
        }
        return 0L;
    }

    private /* synthetic */ Void lambda$startScan$10(String string) throws Exception {
        this.queryGalahSurveyCatalog(string);
        return null;
    }

    private /* synthetic */ Void lambda$startScan$4(String string) throws Exception {
        this.queryGaia(string);
        return null;
    }
}

