/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.doublestar;

import de.planetensuche.core.Check;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;

public class JLabelHtmlLinkListener
implements MouseListener {
    private final ILogging logger;
    private final KonfigurationDTO konfiguration;

    public JLabelHtmlLinkListener(KonfigurationDTO konfigurationDTO) {
        this.konfiguration = konfigurationDTO;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        String string;
        Object object = mouseEvent.getSource();
        if (object instanceof JLabel && Check.isFilled(string = ((JLabel)object).getText())) {
            this.extractLinkAndOpenIt(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void extractLinkAndOpenIt(String string) {
        int n = string.indexOf("<a href=\"");
        String string2 = string.substring(n + 9);
        string2 = string2.substring(0, string2.indexOf("\">link"));
        this.openLink(string2);
    }

    private void openLink(String string) {
        try {
            if (this.konfiguration.isStandardBrowser() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(string));
            } else if (!this.konfiguration.isStandardBrowser()) {
                Runtime.getRuntime().exec(this.konfiguration.getBrowserpfad() + " \"" + string + "\"");
            }
        }
        catch (IOException | URISyntaxException exception) {
            this.logger.error("URL=" + string, exception);
        }
    }
}

