/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.formulare;

import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class EingabeentdeckerDialog
extends Basisdialog {
    private final ISprachcontainer sprache;
    private String[][] entdeckerdaten;
    private List<String> entdeckernachnamen;
    private final IEntdeckerRepository entdeckerRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private JTextField beruf;
    private JComboBox entdecker;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JButton loeschenButton;
    private JTextField nachname;
    private JList objekte;
    private JButton speichernButton;
    private JTextField vorname;

    public EingabeentdeckerDialog(ParameterDto parameterDto, IEntdeckerRepository iEntdeckerRepository, IObjektnamenRepository iObjektnamenRepository) {
        super(BasisdialogId.DATENBANK_EINGABE_ENTDECKER);
        this.entdeckerRepository = iEntdeckerRepository;
        this.sprache = parameterDto.getSprache();
        this.objektnamenRepository = iObjektnamenRepository;
        this.entdeckernachnamen = new ArrayList<String>();
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.showMessageBar(gridBagConstraints);
        try {
            this.setTitle(this.sprache.getString("db_fenster8"));
            this.jLabel1.setText(this.sprache.getString("db_gui57"));
            this.jLabel2.setText(this.sprache.getString("db_gui58"));
            this.jLabel3.setText(this.sprache.getString("db_gui59"));
            this.jLabel4.setText(this.sprache.getString("db_gui60"));
            this.jLabel5.setText(this.sprache.getString("db_gui61"));
            this.jButton3.setText(this.sprache.getString("db_gui62"));
            this.speichernButton.setText(null);
            this.speichernButton.setIcon(IconPoolDefault.SAVE.getImageIcon());
            this.speichernButton.setSize(24, 24);
            this.speichernButton.setToolTipText(this.sprache.getString("db_gui63"));
            this.loeschenButton.setText(null);
            this.loeschenButton.setIcon(IconPoolDefault.DELETE.getImageIcon());
            this.loeschenButton.setSize(24, 24);
            this.loeschenButton.setToolTipText(this.sprache.getString("db_gui64"));
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
            }
            this.getGuiDesigner().addComponent(this.objekte, false);
            this.ladeEntdecker();
            this.leseEntdeckerInCombobox();
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, "Fehler beim Starten: " + exception.toString(), "Fehler", 0);
        }
    }

    private void ladeEntdecker() {
        try {
            List<Entdecker> list = this.entdeckerRepository.getEntdecker();
            this.entdeckerdaten = new String[list.size()][3];
            int n = 0;
            for (Entdecker entdecker : list) {
                this.entdeckerdaten[n][0] = entdecker.getVorname();
                this.entdeckerdaten[n][1] = entdecker.getNachname();
                this.entdeckernachnamen.add(entdecker.getNachname());
                String string = entdecker.getFachgebiet();
                this.entdeckerdaten[n][2] = string != null && !"".equals(string) ? string : "";
                ++n;
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }

    private void leseEntdeckerInCombobox() {
        try {
            if (this.entdeckerdaten != null) {
                this.entdecker.removeAllItems();
                for (String[] stringArray : this.entdeckerdaten) {
                    this.entdecker.addItem(stringArray[1] + ", " + stringArray[0]);
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.entdecker = new JComboBox();
        this.jLabel2 = new JLabel();
        this.vorname = new JTextField();
        this.jLabel3 = new JLabel();
        this.nachname = new JTextField();
        this.jLabel4 = new JLabel();
        this.beruf = new JTextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.objekte = new JList();
        this.speichernButton = new JButton();
        this.loeschenButton = new JButton();
        this.jButton3 = new JButton();
        this.setTitle("Entdecker bearbeiten und loeschen");
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("gespeicherte Entdecker:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 43;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.entdecker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabeentdeckerDialog.this.entdeckerActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 207;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 0, 12);
        this.getContentPane().add((Component)this.entdecker, gridBagConstraints);
        this.jLabel2.setText("Vorname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 64;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 224;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 10, 0, 12);
        this.getContentPane().add((Component)this.vorname, gridBagConstraints);
        this.jLabel3.setText("Nachname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 106;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 224;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 12);
        this.getContentPane().add((Component)this.nachname, gridBagConstraints);
        this.jLabel4.setText("Beruf/Taetigkeit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 79;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 224;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 12);
        this.getContentPane().add((Component)this.beruf, gridBagConstraints);
        this.jLabel5.setText("von ihm entdeckte Objekte:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 27;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.objekte.setSelectionMode(0);
        this.objekte.setToolTipText("Diese Liste kann nicht editiert werden!");
        this.jScrollPane1.setViewportView(this.objekte);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 207;
        gridBagConstraints.ipady = 97;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 12);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.speichernButton.setText("speichern");
        this.speichernButton.setToolTipText("speichert die Aenderungen/den neuen Entdecker ab");
        this.speichernButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabeentdeckerDialog.this.speichernButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 31;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 5, 0);
        this.getContentPane().add((Component)this.speichernButton, gridBagConstraints);
        this.loeschenButton.setText("loeschen");
        this.loeschenButton.setToolTipText("loescht den vorhandenen Entdecker");
        this.loeschenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabeentdeckerDialog.this.loeschenButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 35;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 5, 12);
        this.getContentPane().add((Component)this.loeschenButton, gridBagConstraints);
        this.jButton3.setText("neuer Eintrag");
        this.jButton3.setToolTipText("leert alle Eingabefelder");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabeentdeckerDialog.this.jButton3ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 5, 0);
        this.getContentPane().add((Component)this.jButton3, gridBagConstraints);
        this.setSize(new Dimension(494, 421));
        this.setLocationRelativeTo(null);
    }

    private void entdeckerActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.entdecker.getSelectedIndex() > -1) {
                this.vorname.setText(this.entdeckerdaten[this.entdecker.getSelectedIndex()][0]);
                this.nachname.setText(this.entdeckerdaten[this.entdecker.getSelectedIndex()][1]);
                this.nachname.setEditable(false);
                this.beruf.setText(this.entdeckerdaten[this.entdecker.getSelectedIndex()][2]);
                this.objekte.setEnabled(true);
                List<Integer> list = this.entdeckerRepository.getObjektidsFuerEntdecker(this.nachname.getText(), this.vorname.getText());
                String[] stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray[i] = this.objektnamenRepository.getNamenByDatenId(list.get(i), ObjektnamenSortierung.BEKANNTHEIT).get(0);
                }
                this.objekte = new JList<String>(stringArray);
                this.objekte.setToolTipText(this.sprache.getString("db_m271"));
                this.objekte.setVisible(true);
                this.jScrollPane1.setViewportView(this.objekte);
            }
        }
        catch (RuntimeException | SQLException exception) {
            this.getLogger().error(exception);
        }
    }

    private void jButton3ActionPerformed(ActionEvent actionEvent) {
        this.vorname.setText("");
        this.nachname.setText("");
        this.nachname.setEditable(true);
        this.beruf.setText("");
        this.objekte = new JList();
        this.objekte.setToolTipText(this.sprache.getString("db_m271"));
        this.objekte.setVisible(true);
        this.jScrollPane1.setViewportView(this.objekte);
    }

    private void speichernButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.vorname.setText(this.vorname.getText().trim());
            this.nachname.setText(this.nachname.getText().trim());
            this.beruf.setText(this.beruf.getText().trim());
            String string = this.nachname.isEditable() ? this.vorname.getText() : this.entdeckerdaten[this.entdecker.getSelectedIndex()][0];
            EntdeckerTyp entdeckerTyp = EntdeckerTyp.PERSON;
            if (this.nachname.getText().contains("Search") || this.nachname.getText().contains("Project")) {
                entdeckerTyp = EntdeckerTyp.PROJECT;
            } else if (this.nachname.getText().contains("Telescope")) {
                entdeckerTyp = EntdeckerTyp.SPACE_TELESCOPE;
            }
            boolean bl = this.entdeckerRepository.save(this.vorname.getText(), string, this.nachname.getText(), this.beruf.getText(), entdeckerTyp);
            if (bl) {
                this.ladeEntdecker();
                this.leseEntdeckerInCombobox();
                this.showMessageOnMessageBar(this.sprache.getString("db_m272"), IconPoolDefault.INFO);
            } else {
                this.showMessageOnMessageBar(this.sprache.getString("db_m273"), IconPoolDefault.STOP);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }

    private void loeschenButtonActionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.entdeckernachnamen.indexOf(this.nachname.getText());
            if (n > -1) {
                List<Integer> list = this.entdeckerRepository.getObjektidsFuerEntdecker(this.nachname.getText(), this.vorname.getText());
                if (list.size() > 0) {
                    this.showMessageOnMessageBar(this.sprache.getString("db_m274"), IconPoolDefault.STOP);
                } else {
                    boolean bl = this.entdeckerRepository.delete(this.nachname.getText(), this.vorname.getText());
                    if (bl) {
                        this.ladeEntdecker();
                        this.leseEntdeckerInCombobox();
                        this.showMessageOnMessageBar(this.sprache.getString("db_m275"), IconPoolDefault.INFO);
                    } else {
                        this.showMessageOnMessageBar(this.sprache.getString("db_m276"), IconPoolDefault.STOP);
                    }
                }
            } else {
                this.showMessageOnMessageBar(this.sprache.getString("db_f105"), IconPoolDefault.STOP);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }
}

