/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.formulare;

import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class EingabemethodenDialog
extends Basisdialog {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private JButton addButton;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JButton loeschenButton;
    private JList objekte;

    public EingabemethodenDialog(ParameterDto parameterDto, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IObjektnamenRepository iObjektnamenRepository) {
        super(BasisdialogId.DATENBANK_EINGABE_ENTDECKUNGSMETHODEN);
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.sprache = parameterDto.getSprache();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.objektnamenRepository = iObjektnamenRepository;
        this.initComponents();
        this.setTitle(this.sprache.getString("db_gui106"));
        this.jLabel1.setText(this.sprache.getString("db_gui107"));
        this.jLabel2.setText(this.sprache.getString("db_gui108"));
        this.jLabel3.setText(this.sprache.getString("db_gui109"));
        this.loeschenButton.setText(null);
        this.loeschenButton.setIcon(IconPoolDefault.DELETE.getImageIcon());
        this.loeschenButton.setSize(24, 24);
        this.loeschenButton.setToolTipText(this.sprache.getString("db_gui64"));
        this.addButton.setText(this.sprache.getString("db_gui34"));
        this.objekte = new JList();
        this.objekte.setToolTipText(this.sprache.getString("db_m271"));
        this.objekte.setVisible(true);
        this.jScrollPane1.setViewportView(this.objekte);
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        this.getGuiDesigner().addComponent(this.objekte, false);
        this.ladeEntdeckungsmethoden();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.loeschenButton = new JButton();
        this.addButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.objekte = new JList();
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.jLabel1.setText("gespeicherte Methoden:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 20, 140, 24);
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabemethodenDialog.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.jComboBox1);
        this.jComboBox1.setBounds(160, 20, 190, 24);
        this.jLabel2.setText("Methode hinzufuegen:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 60, 150, 24);
        this.getContentPane().add(this.jTextField1);
        this.jTextField1.setBounds(160, 60, 190, 24);
        this.loeschenButton.setText("loeschen");
        this.loeschenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabemethodenDialog.this.loeschenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.loeschenButton);
        this.loeschenButton.setBounds(360, 20, 110, 24);
        this.addButton.setText("hinzufuegen");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabemethodenDialog.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.addButton);
        this.addButton.setBounds(360, 60, 110, 24);
        this.jLabel3.setText("mit dieser Methode entdeckte Objekte:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(10, 90, 330, 24);
        this.jScrollPane1.setViewportView(this.objekte);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(160, 120, 310, 132);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 491) / 2, (dimension.height - 293) / 2, 491, 293);
    }

    private void ladeEntdeckungsmethoden() {
        try {
            this.jComboBox1.removeAllItems();
            List<String> list = this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
            for (int i = 0; i < list.size(); ++i) {
                this.jComboBox1.addItem(list.get(i));
            }
            this.jComboBox1.setSelectedIndex(0);
        }
        catch (Exception exception) {
            this.logging.error(exception);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.jComboBox1.getSelectedIndex() > -1) {
                this.jTextField1.setText(this.jComboBox1.getSelectedItem().toString());
                List<Integer> list = this.entdeckungsmethodenRepository.getObjekteFuerEntdeckungsmethode(this.jComboBox1.getSelectedItem().toString());
                String[] stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray[i] = this.objektnamenRepository.getNamenByDatenId(list.get(i), ObjektnamenSortierung.BEKANNTHEIT).get(0);
                }
                this.objekte = new JList<String>(stringArray);
                this.objekte.setVisible(true);
                this.jScrollPane1.setViewportView(this.objekte);
            }
        }
        catch (RuntimeException | SQLException exception) {
            this.logging.error(exception);
        }
    }

    private void loeschenButtonActionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.jComboBox1.getSelectedItem().toString();
            int n = JOptionPane.showConfirmDialog(this, this.sprache.getString("db_m416"), this.sprache.getString("db_m200"), 0, 3);
            if (n == 0) {
                if (this.entdeckungsmethodenRepository.delete(string)) {
                    this.ladeEntdeckungsmethoden();
                } else {
                    JOptionPane.showMessageDialog(this, this.sprache.getString("db_f115"), this.sprache.getString("db_m276_titel"), 0);
                }
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.jTextField1.setText(this.jTextField1.getText().trim());
            if (this.jTextField1.getText().length() > 5) {
                if (this.entdeckungsmethodenRepository.save(this.jTextField1.getText())) {
                    this.ladeEntdeckungsmethoden();
                } else {
                    JOptionPane.showMessageDialog(this, this.sprache.getString("db_m417"), this.sprache.getString("db_f92_titel"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, this.sprache.getString("db_m418"), this.sprache.getString("db_f92_titel"), 0);
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(this, this.sprache.getString("db_f108") + " " + exception.toString(), this.sprache.getString("db_f92_titel"), 0);
        }
    }
}

