/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.formulare.objektbearbeiten;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.datenbank.dbmodel.api.IObjektnamenFilterDAO;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class EingabePlanetensucheObjektDialog
extends Basisdialog {
    static final String FEHLERMELDUNG_TITEL = "db_f4_titel";
    static final String KEINER = "db_keiner";
    private static final int MINDESTHOEHE_GUI_ELEMENTE = 24;
    private static final String NULL_PUNKT_NULL = "0.0";
    int semaphor;
    private final IDatenbankService datenbankService;
    PlanetensucheObjektPruefer ob;
    Map<String, String> ausgewaehlteEntdeckerNachnameVorname;
    private final FilterkonfigurationDto filterbedingungen;
    private int nameHoehe = 20;
    private JButton raUmrechnen;
    private JButton declUmrechnen;
    private JButton entfernungUmrechnen;
    private JButton bildAdd;
    private JButton nameAdd;
    private JButton entdeckerAdd;
    private JButton temperaturBerechnen;
    private JButton jumpTo;
    private JLabel lname;
    private JTextField name;
    private JLabel lobjekttyp;
    private JComboBox<String> objekttyp;
    private JLabel lentfernung;
    JTextField entfernung;
    private JLabel lmasse;
    JTextField masse;
    private JLabel ldurchmesser;
    JTextField durchmesser;
    private JLabel ldurchmesser2;
    JTextField durchmesser2;
    private JLabel lumlaufszeit;
    JTextField umlaufszeit;
    private JLabel lgeschwindigkeit;
    JTextField geschwindigkeit;
    private JLabel lexzentritaet;
    JTextField exzentritaet;
    private JLabel lalbedo;
    JTextField albedo;
    private JLabel ltemperatur;
    JTextField temperaturTextfeld;
    private JLabel lentdeckungsmethode;
    JComboBox<String> entdeckungsmethode;
    private JLabel lentdeckungBestaetigt;
    JCheckBox entdeckungBestaetigt;
    private JLabel lentdeckungsdatum;
    JTextField entdeckungsdatum;
    private JLabel lentdecker;
    JTextField entdecker;
    private JLabel lnotiz;
    private JLabel lspektraltyp;
    JComboBox<String> spektraltyp;
    JComboBox<Double> spektraltyp2;
    private JLabel llumi;
    JComboBox<String> lumi;
    private JLabel lsh;
    JTextField sh;
    private JLabel lah;
    JTextField ah;
    private JLabel lflaechenhelligkeit;
    JTextField flaechenhelligkeit;
    private JLabel lbv;
    JTextField bv;
    private JLabel koords;
    JTextField ra;
    JTextField decl;
    private JLabel lsternbild;
    JComboBox<String> sternbild;
    private JLabel lmetal;
    JTextField metal;
    private JLabel lsternentstehung;
    JTextField sternentstehung;
    private JLabel lrotverschiebung;
    JTextField rotverschiebung;
    private JLabel lalter;
    JTextField alter;
    private JLabel lstern;
    JComboBox<String> stern;
    private JLabel lplanet;
    JComboBox<String> planet;
    private JLabel lbild;
    JTextField bild;
    private final ITimestampDAO timestampDAO;
    private final IObjektnamenFilterDAO objektnamenFilterDAO;
    private final INotizenService notizenService;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private JTextField autor;
    private JButton beispielwerte;
    private JButton bildentfernen;
    private JButton entfernen;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JButton leeren;
    private JButton loeschenButton;
    private JButton neu;
    private JTextArea notiz;
    private JComboBox objekt;
    private JComboBox objektkat;
    private JPanel optionjpanel;
    private JScrollPane rnotiz;
    private JRadioButton saveInDatenbank;
    private JRadioButton saveInXMLdatei;
    private JButton speichernButton;
    private JButton springeZuObjekt;
    private JLabel stamp;
    private JPanel tab1;
    private JPanel tab2;
    private JTabbedPane tabpane;

    EingabePlanetensucheObjektDialog(FilterkonfigurationDto filterkonfigurationDto, IObjektnamenFilterDAO iObjektnamenFilterDAO, InjectionDto injectionDto) {
        super(BasisdialogId.DATENBANK_EINGABE_PLANETENSUCHEOBJEKT);
        this.filterbedingungen = filterkonfigurationDto;
        this.timestampDAO = injectionDto.getTimestampDAO();
        this.objektnamenFilterDAO = iObjektnamenFilterDAO;
        this.notizenService = injectionDto.getNotizenService();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.kategorienRepository = injectionDto.getKategorienRepository();
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.showMessageBar(gridBagConstraints);
        this.saveInDatenbank.setEnabled(false);
        this.saveInXMLdatei.setEnabled(true);
        this.datenbankService = injectionDto.getDatenbankService();
        this.ob = new PlanetensucheObjektPruefer(injectionDto.getDao());
        this.ausgewaehlteEntdeckerNachnameVorname = new HashMap<String, String>();
        try {
            int n;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(dimension.width / 4, 0, 650, 500);
            this.setTitle(this.i18n.getString("db_fenster4"));
            this.tabpane.setTitleAt(0, this.i18n.getString("db_gui104"));
            this.tabpane.setTitleAt(1, this.i18n.getString("db_gui105"));
            this.jMenu1.setText(this.i18n.getString("db_menu_29"));
            this.jMenuItem1.setText(this.i18n.getString("db_menu_30"));
            this.jLabel1.setText(this.i18n.getString("db_gui17"));
            this.jLabel3.setText(this.i18n.getString("db_gui18"));
            this.neu.setText(this.i18n.getString("db_gui19"));
            this.springeZuObjekt.setText(this.i18n.getString("db_gui20"));
            this.entfernen.setText(this.i18n.getString("db_gui21"));
            this.bildentfernen.setText(this.i18n.getString("db_gui21"));
            this.loeschenButton.setText(null);
            this.loeschenButton.setIcon(IconPoolDefault.DELETE.getImageIcon());
            this.loeschenButton.setSize(24, 24);
            this.loeschenButton.setToolTipText(this.i18n.getString("db_gui21"));
            this.jLabel4.setText(this.i18n.getString("db_gui22"));
            this.saveInDatenbank.setText(this.i18n.getString("db_gui23"));
            this.saveInXMLdatei.setText(this.i18n.getString("db_m167"));
            this.jLabel7.setText(this.i18n.getString("db_gui25"));
            this.jLabel8.setText(this.i18n.getString("db_m138") + ":");
            this.jLabel9.setText(this.i18n.getString("db_m139") + ":");
            this.jLabel5.setText(this.i18n.getString("db_gui26"));
            this.speichernButton.setText(null);
            this.speichernButton.setIcon(IconPoolDefault.SAVE.getImageIcon());
            this.speichernButton.setSize(24, 24);
            this.speichernButton.setToolTipText(this.i18n.getString("db_gui27"));
            this.jLabel6.setText(this.i18n.getString("db_gui28"));
            this.beispielwerte.setText(this.i18n.getString("db_gui29"));
            this.leeren.setText(this.i18n.getString("db_gui30"));
            this.raUmrechnen = new JButton(this.i18n.getString("db_gui31"));
            this.tab1.add(this.raUmrechnen);
            this.declUmrechnen = new JButton(this.i18n.getString("db_gui32"));
            this.tab1.add(this.declUmrechnen);
            this.entfernungUmrechnen = new JButton(this.i18n.getString("db_gui33"));
            this.tab1.add(this.entfernungUmrechnen);
            this.bildAdd = new JButton(this.i18n.getString("db_gui34"));
            this.tab2.add(this.bildAdd);
            this.bildAdd.setVisible(true);
            this.nameAdd = new JButton(this.i18n.getString("db_gui34"));
            this.tab1.add(this.nameAdd);
            this.nameAdd.setVisible(true);
            this.entdeckerAdd = new JButton(this.i18n.getString("db_gui34"));
            this.tab2.add(this.entdeckerAdd);
            this.entdeckerAdd.setVisible(true);
            this.temperaturBerechnen = new JButton(this.i18n.getString("db_gui35"));
            this.tab2.add(this.temperaturBerechnen);
            this.temperaturBerechnen.setVisible(true);
            this.jumpTo = new JButton(this.i18n.getString("db_gui20"));
            this.tab1.add(this.jumpTo);
            this.jumpTo.setVisible(false);
            this.neu.setBounds(445, 70, 60, 24);
            this.springeZuObjekt.setBounds(505, 70, 100, 24);
            this.nameHoehe = 20;
            this.lname = new JLabel();
            this.lname.setVisible(true);
            this.lname.setBounds(10, this.nameHoehe, 250, 24);
            this.tab1.add(this.lname);
            this.name = new JTextField();
            this.name.setVisible(true);
            this.name.setBounds(250, this.nameHoehe, 180, 24);
            this.tab1.add(this.name);
            this.nameAdd.setBounds(430, this.nameHoehe, 120, 24);
            this.nameAdd.setVisible(true);
            this.lobjekttyp = new JLabel();
            this.tab1.add(this.lobjekttyp);
            this.objekttyp = new JComboBox();
            this.objekttyp.setSize(120, 24);
            this.objekttyp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EingabePlanetensucheObjektDialog.this.objekttypActionPerformed(actionEvent);
                }
            });
            this.tab1.add(this.objekttyp);
            this.lalbedo = new JLabel(this.i18n.getString("db_m115") + ":");
            this.tab1.add(this.lalbedo);
            this.albedo = new JTextField();
            this.tab1.add(this.albedo);
            this.lsh = new JLabel();
            this.tab1.add(this.lsh);
            this.sh = new JTextField();
            this.tab1.add(this.sh);
            this.lah = new JLabel(this.i18n.getString("db_m110") + ":");
            this.tab1.add(this.lah);
            this.ah = new JTextField();
            this.ah.setEditable(false);
            this.tab1.add(this.ah);
            this.lflaechenhelligkeit = new JLabel(this.i18n.getString("db_m109") + ":");
            this.tab1.add(this.lflaechenhelligkeit);
            this.flaechenhelligkeit = new JTextField();
            this.tab1.add(this.flaechenhelligkeit);
            this.lentfernung = new JLabel();
            this.tab1.add(this.lentfernung);
            this.entfernung = new JTextField();
            this.tab1.add(this.entfernung);
            this.lmasse = new JLabel();
            this.tab1.add(this.lmasse);
            this.masse = new JTextField();
            this.tab1.add(this.masse);
            this.ldurchmesser = new JLabel();
            this.tab1.add(this.ldurchmesser);
            this.durchmesser = new JTextField();
            this.tab1.add(this.durchmesser);
            this.ldurchmesser2 = new JLabel();
            this.tab1.add(this.ldurchmesser2);
            this.durchmesser2 = new JTextField();
            this.tab1.add(this.durchmesser2);
            this.lumlaufszeit = new JLabel(this.i18n.getString("db_m220"));
            this.tab1.add(this.lumlaufszeit);
            this.umlaufszeit = new JTextField();
            this.tab1.add(this.umlaufszeit);
            this.lgeschwindigkeit = new JLabel(this.i18n.getString("db_m236"));
            this.tab1.add(this.lgeschwindigkeit);
            this.geschwindigkeit = new JTextField();
            this.tab1.add(this.geschwindigkeit);
            this.lexzentritaet = new JLabel(this.i18n.getString("db_m111") + ":");
            this.tab1.add(this.lexzentritaet);
            this.exzentritaet = new JTextField();
            this.tab1.add(this.exzentritaet);
            this.ltemperatur = new JLabel();
            this.tab2.add(this.ltemperatur);
            this.temperaturTextfeld = new JTextField();
            this.tab2.add(this.temperaturTextfeld);
            this.lentdeckungsmethode = new JLabel(this.i18n.getString("db_m126") + ":");
            this.tab2.add(this.lentdeckungsmethode);
            this.entdeckungsmethode = new JComboBox();
            List<String> list = injectionDto.getEntdeckungsmethodenRepository().getEntdeckungsmethoden();
            for (int i = 0; i < list.size(); ++i) {
                String string = this.i18n.getUebersetzungFuerAktuelleSprache(list.get(i));
                this.entdeckungsmethode.addItem(string);
            }
            this.tab2.add(this.entdeckungsmethode);
            this.lentdeckungBestaetigt = new JLabel(this.i18n.getString("db_m451"));
            this.tab2.add(this.lentdeckungBestaetigt);
            this.entdeckungBestaetigt = new JCheckBox();
            this.tab2.add(this.entdeckungBestaetigt);
            this.lentdeckungsdatum = new JLabel(this.i18n.getString("db_m222"));
            this.tab2.add(this.lentdeckungsdatum);
            this.entdeckungsdatum = new JTextField();
            this.tab2.add(this.entdeckungsdatum);
            this.lentdecker = new JLabel(this.i18n.getString("db_m128") + ":");
            this.tab2.add(this.lentdecker);
            this.entdecker = new JTextField();
            this.entdecker.setEnabled(false);
            this.tab2.add(this.entdecker);
            this.lnotiz = new JLabel(this.i18n.getString("db_m228"));
            this.tab2.add(this.lnotiz);
            this.lspektraltyp = new JLabel();
            this.tab1.add(this.lspektraltyp);
            this.spektraltyp = new JComboBox();
            this.spektraltyp.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        EingabePlanetensucheObjektDialog.this.spektraltypActionPerformed();
                    }
                    catch (SQLException sQLException) {
                        EingabePlanetensucheObjektDialog.this.getLogger().error(sQLException);
                    }
                }
            });
            this.tab1.add(this.spektraltyp);
            this.spektraltyp2 = new JComboBox();
            this.tab1.add(this.spektraltyp2);
            this.llumi = new JLabel();
            this.tab1.add(this.llumi);
            this.lumi = new JComboBox();
            this.tab1.add(this.lumi);
            this.lbv = new JLabel(this.i18n.getString("db_m412") + ":");
            this.tab1.add(this.lbv);
            this.bv = new JTextField();
            this.tab1.add(this.bv);
            this.koords = new JLabel(this.i18n.getString("db_m413") + ":");
            this.tab1.add(this.koords);
            this.ra = new JTextField();
            this.tab1.add(this.ra);
            this.decl = new JTextField();
            this.tab1.add(this.decl);
            this.lsternbild = new JLabel(this.i18n.getString("db_m288") + ":");
            this.tab1.add(this.lsternbild);
            this.sternbild = new JComboBox();
            try {
                List<String> list2 = this.datenbankService.getSternbilderNamen(null);
                for (int i = 0; i < list2.size(); ++i) {
                    this.sternbild.addItem(list2.get(i));
                }
            }
            catch (SQLException sQLException) {
                this.getLogger().error(sQLException);
                JOptionPane.showMessageDialog(null, this.i18n.getString("db_f53") + "\n" + sQLException.toString(), this.i18n.getString(FEHLERMELDUNG_TITEL), 0);
            }
            this.tab1.add(this.sternbild);
            this.lmetal = new JLabel(this.i18n.getString("sim_m58") + ":");
            this.tab2.add(this.lmetal);
            this.metal = new JTextField();
            this.tab2.add(this.metal);
            this.lsternentstehung = new JLabel(this.i18n.getString("db_m122") + ":");
            this.tab2.add(this.lsternentstehung);
            this.sternentstehung = new JTextField();
            this.tab2.add(this.sternentstehung);
            this.lrotverschiebung = new JLabel(this.i18n.getString("db_m123") + ":");
            this.tab2.add(this.lrotverschiebung);
            this.rotverschiebung = new JTextField();
            this.tab2.add(this.rotverschiebung);
            this.lalter = new JLabel(this.i18n.getString("sim_m86") + ":");
            this.tab2.add(this.lalter);
            this.alter = new JTextField();
            this.tab2.add(this.alter);
            this.lstern = new JLabel();
            this.tab1.add(this.lstern);
            this.stern = new JComboBox();
            this.stern.addItem(this.i18n.getString(KEINER));
            this.tab1.add(this.stern);
            this.lplanet = new JLabel();
            this.tab1.add(this.lplanet);
            this.planet = new JComboBox();
            this.planet.addItem(this.i18n.getString(KEINER));
            this.tab1.add(this.planet);
            this.lbild = new JLabel(this.i18n.getString("db_m140") + ":");
            this.lbild.setVisible(true);
            this.tab2.add(this.lbild);
            this.bild = new JTextField();
            this.bild.setEnabled(false);
            this.bild.setVisible(true);
            this.tab2.add(this.bild);
            for (String string : this.i18n.getPlanetensucheObjektKategorien()) {
                this.objektkat.addItem(string);
            }
            for (n = 0; n < this.getContentPane().getComponentCount(); ++n) {
                this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(n), false);
            }
            this.getGuiDesigner().addComponent(this.notiz, false);
            for (n = 0; n < this.optionjpanel.getComponentCount(); ++n) {
                this.getGuiDesigner().addComponent((JComponent)this.optionjpanel.getComponent(n), false);
            }
            for (n = 0; n < this.tab1.getComponentCount(); ++n) {
                this.getGuiDesigner().addComponent((JComponent)this.tab1.getComponent(n), false);
            }
            for (n = 0; n < this.tab2.getComponentCount(); ++n) {
                this.getGuiDesigner().addComponent((JComponent)this.tab2.getComponent(n), false);
            }
            this.showMessageOnMessageBar(this.i18n.getString("db_m196"), IconPoolDefault.INFO);
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, this.i18n.getString("db_f16") + " " + exception.toString(), this.i18n.getString(FEHLERMELDUNG_TITEL), 0);
        }
    }

    public JComboBox<String> getObjektListBox() {
        return this.objekt;
    }

    public JComboBox<String> getSternListBox() {
        return this.stern;
    }

    private void blendeEingabefelderAus() {
        this.lentfernung.setVisible(false);
        this.entfernung.setVisible(false);
        this.lmasse.setVisible(false);
        this.masse.setVisible(false);
        this.ldurchmesser.setVisible(false);
        this.durchmesser.setVisible(false);
        this.ldurchmesser2.setVisible(false);
        this.durchmesser2.setVisible(false);
        this.lumlaufszeit.setVisible(false);
        this.umlaufszeit.setVisible(false);
        this.lgeschwindigkeit.setVisible(false);
        this.geschwindigkeit.setVisible(false);
        this.lexzentritaet.setVisible(false);
        this.exzentritaet.setVisible(false);
        this.ltemperatur.setVisible(false);
        this.temperaturTextfeld.setVisible(false);
        this.lentdeckungsmethode.setVisible(false);
        this.entdeckungsmethode.setVisible(false);
        this.entdeckungsmethode.setSelectedItem(this.i18n.getString("ps_entd_unbekannt"));
        this.lentdeckungBestaetigt.setVisible(false);
        this.entdeckungBestaetigt.setVisible(false);
        this.lentdeckungsdatum.setVisible(false);
        this.entdeckungsdatum.setVisible(false);
        this.lentdecker.setVisible(false);
        this.entdecker.setVisible(false);
        this.lspektraltyp.setVisible(false);
        this.spektraltyp.setVisible(false);
        this.spektraltyp2.setVisible(false);
        this.llumi.setVisible(false);
        this.lumi.setVisible(false);
        this.lsh.setVisible(false);
        this.sh.setVisible(false);
        this.lah.setVisible(false);
        this.ah.setVisible(false);
        this.lflaechenhelligkeit.setVisible(false);
        this.flaechenhelligkeit.setVisible(false);
        this.lbv.setVisible(false);
        this.bv.setVisible(false);
        this.koords.setVisible(false);
        this.ra.setVisible(false);
        this.decl.setVisible(false);
        this.lsternbild.setVisible(false);
        this.sternbild.setVisible(false);
        this.lmetal.setVisible(false);
        this.metal.setVisible(false);
        this.lsternentstehung.setVisible(false);
        this.sternentstehung.setVisible(false);
        this.lrotverschiebung.setVisible(false);
        this.rotverschiebung.setVisible(false);
        this.lalter.setVisible(false);
        this.alter.setVisible(false);
        this.lstern.setVisible(false);
        this.stern.setVisible(false);
        this.lplanet.setVisible(false);
        this.planet.setVisible(false);
        this.lalbedo.setVisible(false);
        this.albedo.setVisible(false);
    }

    private void fuelleObjektnamen() {
        try {
            List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.objektkat.getSelectedIndex(), false, this.filterbedingungen);
            this.objekt.removeAllItems();
            for (String string : list) {
                this.objekt.addItem(string);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f94") + ":\n" + exception.toString(), this.i18n.getString("db_f9_titel"), 0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.objektkat = new JComboBox();
        this.objekt = new JComboBox();
        this.jLabel3 = new JLabel();
        this.optionjpanel = new JPanel();
        this.saveInDatenbank = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.loeschenButton = new JButton();
        this.jLabel5 = new JLabel();
        this.leeren = new JButton();
        this.jLabel6 = new JLabel();
        this.beispielwerte = new JButton();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.autor = new JTextField();
        this.jLabel9 = new JLabel();
        this.stamp = new JLabel();
        this.speichernButton = new JButton();
        this.saveInXMLdatei = new JRadioButton();
        this.neu = new JButton();
        this.springeZuObjekt = new JButton();
        this.tabpane = new JTabbedPane();
        this.tab1 = new JPanel();
        this.tab2 = new JPanel();
        this.rnotiz = new JScrollPane();
        this.notiz = new JTextArea();
        this.entfernen = new JButton();
        this.bildentfernen = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.setTitle("neuer Eintrag");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EingabePlanetensucheObjektDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(null);
        this.jLabel1.setText("Objektkategorie:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 40, 170, 24);
        this.objektkat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.objektkatActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.objektkat);
        this.objektkat.setBounds(200, 40, 210, 24);
        this.objekt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.objektActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.objekt);
        this.objekt.setBounds(200, 70, 210, 24);
        this.jLabel3.setText("Objekt bearbeiten:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(20, 70, 180, 24);
        this.optionjpanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.optionjpanel.setLayout(null);
        this.saveInDatenbank.setSelected(true);
        this.saveInDatenbank.setText("Datenbank");
        this.saveInDatenbank.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optionjpanel.add(this.saveInDatenbank);
        this.saveInDatenbank.setBounds(20, 40, 110, 24);
        this.jLabel4.setText("Speichern in");
        this.optionjpanel.add(this.jLabel4);
        this.jLabel4.setBounds(20, 10, 110, 24);
        this.loeschenButton.setText("loeschen");
        this.optionjpanel.add(this.loeschenButton);
        this.loeschenButton.setBounds(310, 90, 120, 24);
        this.jLabel5.setText("aktuellen Datensatz");
        this.optionjpanel.add(this.jLabel5);
        this.jLabel5.setBounds(310, 10, 140, 24);
        this.leeren.setText("leeren");
        this.optionjpanel.add(this.leeren);
        this.leeren.setBounds(450, 90, 120, 24);
        this.jLabel6.setText("alle Felder");
        this.optionjpanel.add(this.jLabel6);
        this.jLabel6.setBounds(450, 10, 110, 24);
        this.beispielwerte.setText("Beispielwerte");
        this.beispielwerte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.beispielwerteActionPerformed(actionEvent);
            }
        });
        this.optionjpanel.add(this.beispielwerte);
        this.beispielwerte.setBounds(450, 50, 120, 24);
        this.jLabel7.setText("Datensatzinformationen");
        this.optionjpanel.add(this.jLabel7);
        this.jLabel7.setBounds(140, 10, 150, 24);
        this.jLabel8.setText("Autor:");
        this.optionjpanel.add(this.jLabel8);
        this.jLabel8.setBounds(140, 30, 80, 24);
        this.autor.setText("Gerd Guehne");
        this.optionjpanel.add(this.autor);
        this.autor.setBounds(140, 50, 150, 24);
        this.jLabel9.setText("zuletzt aktualisiert:");
        this.optionjpanel.add(this.jLabel9);
        this.jLabel9.setBounds(140, 80, 140, 24);
        this.stamp.setHorizontalAlignment(0);
        this.stamp.setText("-");
        this.stamp.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.optionjpanel.add(this.stamp);
        this.stamp.setBounds(140, 100, 150, 24);
        this.speichernButton.setText("speichern");
        this.optionjpanel.add(this.speichernButton);
        this.speichernButton.setBounds(310, 50, 120, 24);
        this.saveInXMLdatei.setText("XML-Datei");
        this.saveInXMLdatei.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optionjpanel.add(this.saveInXMLdatei);
        this.saveInXMLdatei.setBounds(20, 60, 110, 24);
        this.getContentPane().add(this.optionjpanel);
        this.optionjpanel.setBounds(20, 360, 600, 130);
        this.neu.setText("neu");
        this.neu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.neuActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.neu);
        this.neu.setBounds(420, 70, 100, 24);
        this.springeZuObjekt.setText("springe zu");
        this.getContentPane().add(this.springeZuObjekt);
        this.springeZuObjekt.setBounds(530, 70, 100, 24);
        this.tab1.setLayout(null);
        this.tabpane.addTab("tab1", this.tab1);
        this.tab2.setLayout(null);
        this.notiz.setMinimumSize(new Dimension(200, 20));
        this.rnotiz.setViewportView(this.notiz);
        this.tab2.add(this.rnotiz);
        this.rnotiz.setBounds(40, 50, 280, 120);
        this.entfernen.setText("loeschen");
        this.entfernen.setMaximumSize(new Dimension(100, 20));
        this.entfernen.setMinimumSize(new Dimension(100, 20));
        this.entfernen.setPreferredSize(new Dimension(100, 20));
        this.entfernen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.entfernenActionPerformed(actionEvent);
            }
        });
        this.tab2.add(this.entfernen);
        this.entfernen.setBounds(390, 60, 100, 24);
        this.bildentfernen.setText("loeschen");
        this.bildentfernen.setMinimumSize(new Dimension(100, 20));
        this.bildentfernen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.bildentfernenActionPerformed(actionEvent);
            }
        });
        this.tab2.add(this.bildentfernen);
        this.bildentfernen.setBounds(410, 20, 120, 24);
        this.tabpane.addTab("tab2", this.tab2);
        this.getContentPane().add(this.tabpane);
        this.tabpane.setBounds(20, 100, 600, 250);
        this.jMenu1.setText("Loeschen");
        this.jMenuItem1.setText("nach Datum");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialog.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 649) / 2, (dimension.height - 549) / 2, 649, 549);
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        try {
            List<String> list = this.timestampDAO.getZeitraeume();
            Object[] objectArray = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = list.get(i);
            }
            Object object = JOptionPane.showInputDialog(this, this.i18n.getString("db_m197"), this.i18n.getString("db_m198"), 3, null, objectArray, objectArray[0]);
            if (object != null) {
                List<Integer> list2 = this.timestampDAO.getIDsFuerTag(object.toString());
                Object[] objectArray2 = new Object[list2.size()];
                for (int i = 0; i < list2.size(); ++i) {
                    objectArray2[i] = this.objektnamenRepository.getNamenByDatenId(list2.get(i), ObjektnamenSortierung.ALPHABETISCH);
                }
                Object object2 = JOptionPane.showInputDialog(this, this.i18n.getString("db_m199"), this.i18n.getString("db_m200"), 3, null, objectArray2, objectArray2[0]);
                if (object2 != null) {
                    for (Integer n : list2) {
                        this.planetensucheObjektRepository.delete(n);
                    }
                    JOptionPane.showMessageDialog(this, this.i18n.getString("db_m201") + " " + list2.size() + " " + this.i18n.getString("db_m202"), this.i18n.getString("db_m203"), 1);
                }
            }
        }
        catch (SQLException sQLException) {
            this.getLogger().error(sQLException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f54") + sQLException.getLocalizedMessage(), this.i18n.getString("db_f55"), 0);
        }
    }

    private void entfernenActionPerformed(ActionEvent actionEvent) {
        this.entdecker.setText("");
    }

    private void neuActionPerformed(ActionEvent actionEvent) {
        this.setTitle(this.i18n.getString("db_fenster5"));
        this.leereAlleFelder();
        this.objekttyp.setSelectedIndex(0);
        this.planet.setSelectedItem(this.i18n.getString(KEINER));
        this.stern.setSelectedItem(this.i18n.getString(KEINER));
        this.sternbild.setSelectedItem("unbekannt");
        this.spektraltyp.setSelectedItem(this.i18n.getString("db_unbekannt"));
        this.spektraltyp2.setSelectedItem(NULL_PUNKT_NULL);
        this.lumi.setSelectedItem(this.i18n.getString("db_unbekannt"));
        this.entdeckungsmethode.setSelectedItem(this.i18n.getString("ps_entd_unbekannt"));
        this.ob = new PlanetensucheObjektPruefer(BeanFactory.getInstanceDaoHigh());
        this.stamp.setText(this.ob.getStamp().toString());
    }

    private void formWindowClosing(WindowEvent windowEvent) {
    }

    private void beispielwerteActionPerformed(ActionEvent actionEvent) {
        this.alter.setText(NULL_PUNKT_NULL);
        if (this.objektkat.getSelectedIndex() == 0) {
            this.name.setText("Xena;Eris;2003 UB313;");
            this.spektraltyp.setSelectedItem("M");
            this.entfernung.setText("67,709");
            this.masse.setText("39E+21");
            this.durchmesser.setText("2400");
            this.umlaufszeit.setText("203444,25");
            this.geschwindigkeit.setText("3,620");
            this.exzentritaet.setText("0,441");
            this.albedo.setText("0,85");
            this.entdeckungsdatum.setText("31.10.2003");
            this.entdecker.setText("Brown;Trujillo;Rabinowitz;");
            this.bild.setText("");
            this.notiz.setText("Neigung der Bahnebene: 44,177\u00b0");
        } else if (this.objektkat.getSelectedIndex() == 1) {
            this.name.setText("GQ Lupi b;");
            this.spektraltyp.setSelectedItem("T");
            this.spektraltyp2.setSelectedItem("1.0");
            this.entfernung.setText("103,0");
            this.masse.setText("21,5");
            this.durchmesser.setText("3,6");
            this.umlaufszeit.setText("438300");
            this.geschwindigkeit.setText("");
            this.exzentritaet.setText("");
            this.temperaturTextfeld.setText("1500");
            this.entdeckungsmethode.setSelectedItem(this.i18n.getString("ps_entd_direkt"));
            this.entdeckungsdatum.setText("31.03.2005");
            this.entdecker.setText("Neuhaeuser;");
            this.stern.setSelectedItem("GQ Lupi");
            this.bild.setText("");
            this.notiz.setText("");
        } else if (this.objektkat.getSelectedIndex() == 2) {
            this.name.setText("NGC 147;");
            this.objekttyp.setSelectedItem("Galaxie");
            this.lumi.setSelectedItem("E0");
            this.spektraltyp.setSelectedItem("irregulaere Zwerggalaxie");
            this.sternbild.setSelectedItem("Kassiopeia");
            this.ra.setText("0,553333333");
            this.decl.setText("48,51666666");
            this.entfernung.setText("2400000");
            this.durchmesser.setText("");
            this.durchmesser2.setText("10500");
            this.sh.setText("9,5");
            this.sternentstehung.setText("2");
            this.rotverschiebung.setText("2.5");
            this.entdeckungsdatum.setText("08.09.1829");
            this.entdecker.setText("(J.) Herschel");
            this.bild.setText("");
            this.notiz.setText("");
        } else if (this.objektkat.getSelectedIndex() == 3) {
            this.name.setText("Coma Galaxienhaufen;Abell 1656;");
            this.sternbild.setSelectedItem("Haar der Berenike");
            this.ra.setText("12,416666666");
            this.decl.setText("26,0");
            this.entfernung.setText("290000000");
            this.durchmesser.setText("300");
            this.sh.setText("2,5");
            this.bild.setText("");
            this.notiz.setText("gigantischer Galaxienhaufen mit mind. 20 Galaxien");
        } else if (this.objektkat.getSelectedIndex() == 4) {
            this.name.setText("Halleysche Komet;");
            this.spektraltyp.setSelectedItem("M");
            this.entfernung.setText("17");
            this.umlaufszeit.setText("76");
            this.exzentritaet.setText("0,96727725");
            this.entdeckungsdatum.setText("01.01.1692");
            this.entdecker.setText("Halley;");
            this.bild.setText("");
            this.notiz.setText("beobachtet in den Jahren: 11 v.Chr., 66 n.Chr., 1066, 1531, 1607, 1682 und 1758");
        } else if (this.objektkat.getSelectedIndex() == 5) {
            this.name.setText("Caloris-Becken;");
            this.durchmesser.setText("1350");
            this.bild.setText("");
            this.notiz.setText("Kraterrand von 2 km Hoehe!");
        } else if (this.objektkat.getSelectedIndex() == 6) {
            this.name.setText("Io;");
            this.entfernung.setText("422000");
            this.masse.setText("8,93e24");
            this.durchmesser.setText("3643");
            this.umlaufszeit.setText("1,769");
            this.albedo.setText("0,61");
            this.sh.setText("");
            this.entdeckungsdatum.setText("01.01.1610");
            this.entdecker.setText("Galileo;Marius;");
            this.planet.setSelectedItem("Jupiter");
            this.bild.setText("");
            this.notiz.setText("Anziehungskraft relativ zur Erdanziehung: 18,31 %; Atmosphaere: sehr duenn, vorallem aus Schwefel");
        } else if (this.objektkat.getSelectedIndex() == 7) {
            this.name.setText("Erde;Earth;");
            this.entfernung.setText("1,00");
            this.masse.setText("0,00314");
            this.durchmesser.setText("0,0892");
            this.umlaufszeit.setText("365,25");
            this.geschwindigkeit.setText("29,8");
            this.exzentritaet.setText("0,09");
            this.albedo.setText("0,20");
            this.temperaturTextfeld.setText("17,5");
            this.entdeckungsmethode.setSelectedItem(this.i18n.getString("ps_entd_unbekannt"));
            this.entdeckungsdatum.setText("");
            this.entdecker.setText("");
            this.stern.setSelectedItem("Sonne");
            this.bild.setText("");
            this.notiz.setText("Oberflaeche mit 73% Wasser bedeckt, viel Gestein (Silikate usw.)\nAtmosphaere: Sauerstoff, Kohlenstoff, Stickstoff und Edelgase\nAtmosphaerendruck: 1,0 bar\n");
        } else if (this.objektkat.getSelectedIndex() == 10) {
            this.name.setText("Procyon A;Alpha Canis Minoris A;10 Canis Minoris;HR 2943;HD 61421;GC 10277;HIP 37279;BD +05 1739A;SAO 115756;");
            this.objekttyp.setSelectedItem(StarObjectType.SINGLE_STAR.getTypeName());
            this.spektraltyp.setSelectedItem("F");
            this.spektraltyp2.setSelectedItem("5.0");
            this.lumi.setSelectedItem("V");
            this.sternbild.setSelectedItem("Kleiner Hund");
            this.ra.setText("7,655033");
            this.decl.setText("5,22499");
            this.entfernung.setText("11,258");
            this.masse.setText("1,78");
            this.durchmesser.setText("1,443");
            this.sh.setText("0,385");
            this.geschwindigkeit.setText("-4,0");
            this.temperaturTextfeld.setText("7500");
            this.bv.setText("0,42");
            this.metal.setText("");
            this.alter.setText("");
            this.bild.setText("");
            this.notiz.setText("");
        } else if (this.objektkat.getSelectedIndex() == 11) {
            this.name.setText("47 Tucanae;NGC 104;Lacaille I.1;Dunlop 18;Bennett 2;");
            this.objekttyp.setSelectedItem("Kugelsternhaufen");
            this.lumi.setSelectedItem("III");
            this.sternbild.setSelectedItem("Tukan");
            this.ra.setText("0,40167");
            this.decl.setText("-72,08333333");
            this.entfernung.setText("14000");
            this.durchmesser.setText("25");
            this.sh.setText("4,03");
            this.entdeckungsdatum.setText("");
            this.entdecker.setText("");
            this.bild.setText("");
            this.notiz.setText("");
        } else if (this.objektkat.getSelectedIndex() == 8) {
            this.name.setText("Kohlensack Nebel;");
            this.sternbild.setSelectedItem("Kreuz");
            this.ra.setText("12,8666666");
            this.decl.setText("-63,3");
            this.entfernung.setText("2000");
            this.durchmesser.setText("360");
            this.sh.setText("");
            this.bild.setText("");
            this.notiz.setText("Dieser Nebel besteht aus einer Wolke voller Staub (vorallem Kohlenstoff - daher auch der Name), der fast kein Licht hindurchlaesst. Bereits 1499 wurde dieser Dunkelnebel von dem Portogiesen Vincente Yanez Pinzon beobachtet, aber erst 1751/1752 von Abbe Lacaille in seinen Katalog aufgenommen.");
        }
    }

    public void setNameAufGUI(String string) {
        if (string.contains(";")) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                if (string2.trim().isEmpty()) continue;
                this.name.setText(this.name.getText() + string2.trim() + ";");
            }
        } else if (!string.trim().isEmpty()) {
            this.name.setText(this.name.getText() + string.trim() + ";");
        }
    }

    public JTextField getTemperaturTextfeld() {
        return this.temperaturTextfeld;
    }

    public JButton getTemperaturBerechnen() {
        return this.temperaturBerechnen;
    }

    public JButton getNameAdd() {
        return this.nameAdd;
    }

    public JButton getEntdeckerAdd() {
        return this.entdeckerAdd;
    }

    public JTextField getEntdecker() {
        return this.entdecker;
    }

    public JComboBox<String> getSpektraltyp() {
        return this.spektraltyp;
    }

    public JComboBox<Double> getSpektraltyp2() {
        return this.spektraltyp2;
    }

    public Map<String, String> getAusgewaehlteEntdeckerNachnameVorname() {
        return this.ausgewaehlteEntdeckerNachnameVorname;
    }

    private void spektraltypActionPerformed() throws SQLException {
        if (this.spektraltyp.getSelectedIndex() == -1) {
            return;
        }
        if (this.spektraltyp.getSelectedItem().toString().equals(this.i18n.getString("db_unbekannt"))) {
            this.spektraltyp2.setEnabled(false);
        } else {
            this.spektraltyp2.setEnabled(true);
        }
        this.spektraltyp2.removeAllItems();
        List<Double> list = this.spektraltyp.getSelectedItem().toString().startsWith("D") ? this.datenbankService.getSpektraltypen2(true) : this.datenbankService.getSpektraltypen2(false);
        for (int i = 0; i < list.size(); ++i) {
            this.spektraltyp2.addItem(list.get(i));
        }
    }

    public void leereAlleFelder() {
        this.albedo.setText("");
        this.bv.setText("");
        this.decl.setText("");
        this.durchmesser.setText("");
        this.durchmesser2.setText("");
        this.entdecker.setText("");
        this.entdeckungsdatum.setText("");
        this.entfernung.setText("");
        this.exzentritaet.setText("");
        this.geschwindigkeit.setText("");
        this.masse.setText("");
        this.metal.setText("");
        this.name.setText("");
        this.notiz.setText("");
        this.ra.setText("");
        this.sh.setText("");
        this.ah.setText("");
        this.flaechenhelligkeit.setText("");
        this.sternentstehung.setText("");
        this.rotverschiebung.setText("");
        this.alter.setText("");
        this.temperaturTextfeld.setText("");
        this.umlaufszeit.setText("");
        this.bild.setText("");
    }

    public JButton getLeerenButton() {
        return this.leeren;
    }

    public JButton getLoeschenButton() {
        return this.loeschenButton;
    }

    private void objektActionPerformed(ActionEvent actionEvent) {
        if (this.objekt.getSelectedIndex() > -1 && this.semaphor == 0) {
            boolean bl = this.i18n.getString("ps_sternbilder").equals(this.objektkat.getSelectedItem().toString());
            if (bl) {
                return;
            }
            this.semaphor = 1;
            String string = this.objekt.getSelectedItem().toString();
            int n = this.objektkat.getSelectedIndex();
            try {
                if (!"".equals(string)) {
                    SternbildSprache sternbildSprache;
                    this.leereAlleFelder();
                    this.setTitle(this.i18n.getString("db_fenster4"));
                    Integer n2 = this.objektnamenRepository.getIDFuerNamen(string, true);
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n2);
                    this.ob = new PlanetensucheObjektPruefer(BeanFactory.getInstanceDaoHigh(), iPlanetensucheObjekt);
                    String string2 = this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getObjekttyp());
                    this.objekttyp.setSelectedItem(string2);
                    this.autor.setText(this.ob.getAutor());
                    this.stamp.setText(this.ob.getStamp().toString());
                    if (n == 10) {
                        this.spektraltyp.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getSpektralklasse()));
                        this.spektraltyp2.setSelectedItem(this.ob.getSpektralklasse2());
                        this.lumi.setSelectedItem(this.ob.getLeuchtkraftklasse());
                    } else if (n == 1) {
                        this.spektraltyp.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getSpektralklasse()));
                        this.spektraltyp2.setSelectedItem(this.ob.getSpektralklasse2());
                    } else if (n == 11) {
                        this.lumi.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getSternhaufenform()));
                    } else if (n == 2) {
                        if (!this.ob.getGalaxienform().isEmpty()) {
                            this.lumi.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getGalaxienform()));
                        }
                        if (!this.ob.getGalaxienart().isEmpty()) {
                            this.spektraltyp.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getGalaxienart()));
                        }
                        if (!this.ob.getNebelform().isEmpty()) {
                            this.lumi.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getNebelform()));
                        }
                    }
                    if (this.ob.getRA() != 0.0) {
                        this.ra.setText(Double.toString(this.ob.getRA()));
                    }
                    if (this.ob.getDECL() != 0.0) {
                        this.decl.setText(Double.toString(this.ob.getDECL()));
                    }
                    if (SternbildSprache.DEUTSCH.equals((Object)(sternbildSprache = this.datenbankService.getSternbildsprache()))) {
                        this.sternbild.setSelectedItem(this.ob.getSternbildDTBezeichnung());
                    } else if (SternbildSprache.ENGLISCH.equals((Object)sternbildSprache)) {
                        this.sternbild.setSelectedItem(this.ob.getSternbildENGBezeichnung());
                    } else if (SternbildSprache.LATEINISCH.equals((Object)sternbildSprache)) {
                        this.sternbild.setSelectedItem(this.ob.getSternbildLATBezeichnung());
                    }
                    if (this.ob.getEntfernung() > 0.0) {
                        this.entfernung.setText(Double.toString(this.ob.getEntfernung()));
                    }
                    if (this.ob.getDurchmesser() > 0.0) {
                        this.durchmesser.setText(Double.toString(this.ob.getDurchmesser()));
                    }
                    if (this.ob.getGalaxienDurchmesserInLy() > 0.0) {
                        this.durchmesser2.setText(Double.toString(this.ob.getGalaxienDurchmesserInLy()));
                    }
                    if (this.ob.getMasse() > 0.0) {
                        this.masse.setText(Double.toString(this.ob.getMasse()));
                    }
                    if (this.ob.getScheinbareHelligkeit() > -100.0) {
                        this.sh.setText(Double.toString(this.ob.getScheinbareHelligkeit()));
                    }
                    if (this.ob.getAbsoluteHelligkeit() > -100.0) {
                        this.ah.setText(Double.toString(this.ob.getAbsoluteHelligkeit()));
                    }
                    if (this.ob.getFlaechenhelligkeit() > -100.0) {
                        this.flaechenhelligkeit.setText(Double.toString(this.ob.getFlaechenhelligkeit()));
                    }
                    if (!this.ob.isUmlaufszeitUnbekannt()) {
                        this.umlaufszeit.setText(Double.toString(this.ob.getUmlaufszeit()));
                    }
                    if (!this.ob.isExzentritaetUnbekannt()) {
                        this.exzentritaet.setText(Double.toString(this.ob.getExzentritaet()));
                    }
                    if (!this.ob.isTemperaturUnbekannt()) {
                        this.temperaturTextfeld.setText(Double.toString(this.ob.getTemperatur()));
                    }
                    if (this.ob.getAlbedo() > 0.0) {
                        this.albedo.setText(Double.toString(this.ob.getAlbedo()));
                    }
                    if (!this.ob.isGeschwindigkeitUnbekannt()) {
                        this.geschwindigkeit.setText(Double.toString(this.ob.getGeschwindigkeit()));
                    }
                    if (!this.ob.isBVUnbekannt()) {
                        this.bv.setText(Double.toString(this.ob.getBV()));
                    }
                    if (!this.ob.isMetallizitaetUnbekannt()) {
                        this.metal.setText(Double.toString(this.ob.getMetallizitaet()));
                    }
                    if (this.ob.getSternentstehung() > 0) {
                        this.sternentstehung.setText(Integer.toString(this.ob.getSternentstehung()));
                    }
                    if (this.ob.getRotverschiebung() > -10.0) {
                        this.rotverschiebung.setText(Double.toString(this.ob.getRotverschiebung()));
                    }
                    if (this.alter.isVisible() && !this.ob.isAlterInMrdJahreUnbekannt()) {
                        this.alter.setText(Double.toString(this.ob.getAlterInMrdJahre()));
                    }
                    this.entdeckungsmethode.setSelectedItem(this.i18n.getUebersetzungFuerAktuelleSprache(this.ob.getEntdeckungsmethode()));
                    this.entdeckungBestaetigt.setSelected(this.ob.isEntdeckungBestaetigt());
                    this.entdeckungsdatum.setText(this.ob.getEntdeckungsdatum());
                    Map<String, String> map = this.ob.getEntdeckerMitNachnamenVornamen();
                    for (Map.Entry<String, String> object : map.entrySet()) {
                        this.entdecker.setText(this.entdecker.getText() + object.getKey() + ";");
                        this.ausgewaehlteEntdeckerNachnameVorname.put(object.getKey(), object.getValue());
                    }
                    for (String string3 : this.ob.getObjektNamen()) {
                        this.name.setText(this.name.getText() + string3 + ";");
                    }
                    if (this.ob.getUmkreistObjekt().isEmpty()) {
                        this.planet.setSelectedItem(this.i18n.getString(KEINER));
                        this.stern.setSelectedItem(this.i18n.getString(KEINER));
                    } else if (n == 6) {
                        this.planet.setSelectedItem(this.ob.getUmkreistObjekt());
                    } else {
                        this.stern.setSelectedItem(this.ob.getUmkreistObjekt());
                    }
                    for (String string4 : this.ob.getBilder()) {
                        this.bild.setText(this.bild.getText() + string4 + ";");
                    }
                    String string3 = this.notizenService.getByDatenid(this.ob.getDatenid()).replaceAll("<br>", "\n");
                    this.notiz.append(string3);
                    this.ra.setCaretPosition(0);
                    this.decl.setCaretPosition(0);
                }
            }
            catch (Exception exception) {
                this.getLogger().error(exception);
                JOptionPane.showMessageDialog(this, this.i18n.getString("db_f16") + " " + exception.toString(), this.i18n.getString(FEHLERMELDUNG_TITEL), 0);
            }
            this.semaphor = 0;
            this.objekt.repaint();
            this.planet.repaint();
            this.stern.repaint();
        }
    }

    public JButton getBildAdd() {
        return this.bildAdd;
    }

    public JTextField getBild() {
        return this.bild;
    }

    public JTextField getEntfernung() {
        return this.entfernung;
    }

    public JButton getEntfernungUmrechnen() {
        return this.entfernungUmrechnen;
    }

    public JTextField getRa() {
        return this.ra;
    }

    public JButton getRaUmrechnen() {
        return this.raUmrechnen;
    }

    public JTextField getDecl() {
        return this.decl;
    }

    public JButton getDeclUmrechnen() {
        return this.declUmrechnen;
    }

    void sperreGUI(boolean bl) {
        this.objektkat.setEnabled(!bl);
        this.objekt.setEnabled(!bl);
        this.speichernButton.setEnabled(!bl);
        this.loeschenButton.setEnabled(!bl);
    }

    void korrigiere() {
        if ("".equals(this.entfernung.getText())) {
            this.entfernung.setText(NULL_PUNKT_NULL);
        } else {
            this.entfernung.setText(this.entfernung.getText().replace(",", "."));
        }
        if ("".equals(this.ra.getText())) {
            this.ra.setText(NULL_PUNKT_NULL);
        } else {
            this.ra.setText(this.ra.getText().replace(",", "."));
        }
        if ("".equals(this.decl.getText())) {
            this.decl.setText(NULL_PUNKT_NULL);
        } else {
            this.decl.setText(this.decl.getText().replace(",", "."));
        }
        if ("".equals(this.durchmesser.getText())) {
            this.durchmesser.setText(NULL_PUNKT_NULL);
        } else {
            this.durchmesser.setText(this.durchmesser.getText().replaceFirst(",", "."));
        }
        if ("".equals(this.durchmesser2.getText())) {
            this.durchmesser2.setText(NULL_PUNKT_NULL);
        } else {
            this.durchmesser2.setText(this.durchmesser2.getText().replaceFirst(",", "."));
        }
        if ("".equals(this.sh.getText())) {
            this.sh.setText("-100.0");
        } else {
            this.sh.setText(this.sh.getText().replace(",", "."));
        }
        if ("".equals(this.flaechenhelligkeit.getText())) {
            this.flaechenhelligkeit.setText("-100.0");
        } else {
            this.flaechenhelligkeit.setText(this.flaechenhelligkeit.getText().replaceFirst(",", "."));
        }
        if ("".equals(this.masse.getText())) {
            this.masse.setText(NULL_PUNKT_NULL);
        } else {
            this.masse.setText(this.masse.getText().replace(",", "."));
        }
        if ("".equals(this.bv.getText())) {
            this.bv.setText("-100.0");
        } else {
            this.bv.setText(this.bv.getText().replace(",", "."));
        }
        if ("".equals(this.exzentritaet.getText())) {
            this.exzentritaet.setText(NULL_PUNKT_NULL);
        } else {
            this.exzentritaet.setText(this.exzentritaet.getText().replace(",", "."));
        }
        if ("".equals(this.geschwindigkeit.getText())) {
            this.geschwindigkeit.setText(NULL_PUNKT_NULL);
        } else {
            this.geschwindigkeit.setText(this.geschwindigkeit.getText().replace(",", "."));
        }
        if ("".equals(this.metal.getText())) {
            this.metal.setText("-100.0");
        } else {
            this.metal.setText(this.metal.getText().replace(",", "."));
        }
        if ("".equals(this.temperaturTextfeld.getText())) {
            this.temperaturTextfeld.setText("-273.15");
        } else {
            this.temperaturTextfeld.setText(this.temperaturTextfeld.getText().replace(",", "."));
        }
        if ("".equals(this.albedo.getText())) {
            this.albedo.setText(NULL_PUNKT_NULL);
        } else {
            this.albedo.setText(this.albedo.getText().replace(",", "."));
        }
        if ("".equals(this.umlaufszeit.getText())) {
            this.umlaufszeit.setText(NULL_PUNKT_NULL);
        } else {
            this.umlaufszeit.setText(this.umlaufszeit.getText().replace(",", "."));
        }
        if ("".equals(this.sternentstehung.getText())) {
            this.sternentstehung.setText("0");
        } else {
            this.sternentstehung.setText(this.sternentstehung.getText().replace(",", "."));
        }
        if ("".equals(this.rotverschiebung.getText())) {
            this.rotverschiebung.setText("-10.0");
        } else {
            this.rotverschiebung.setText(this.rotverschiebung.getText().replace(",", "."));
        }
        if ("".equals(this.alter.getText())) {
            this.alter.setText(NULL_PUNKT_NULL);
        } else {
            this.alter.setText(this.alter.getText().replace(",", "."));
        }
    }

    private void getGalaxienform() throws SQLException {
        List<String> list = this.datenbankService.getGalaxienformen();
        this.lumi.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            this.lumi.addItem(this.i18n.getUebersetzungFuerAktuelleSprache(list.get(i)));
        }
        this.llumi.setVisible(true);
        this.lumi.setVisible(true);
    }

    private void getGalaxiearten() throws SQLException {
        this.spektraltyp.removeAllItems();
        List<String> list = this.datenbankService.getGalaxienarten();
        for (int i = 0; i < list.size(); ++i) {
            this.spektraltyp.addItem(this.i18n.getUebersetzungFuerAktuelleSprache(list.get(i)));
        }
        this.lspektraltyp.setVisible(true);
        this.spektraltyp.setVisible(true);
    }

    private void objekttypActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.objekttyp.getSelectedIndex() > -1) {
                this.lumi.removeAllItems();
                this.llumi.setVisible(false);
                this.lumi.setVisible(false);
                this.lspektraltyp.setVisible(false);
                this.spektraltyp.setVisible(false);
                this.spektraltyp2.setVisible(false);
                this.lrotverschiebung.setVisible(false);
                this.rotverschiebung.setVisible(false);
                this.lah.setVisible(false);
                this.ah.setVisible(false);
                if (this.objektkat.getSelectedIndex() == 0) {
                    this.lspektraltyp.setVisible(true);
                    this.spektraltyp.setVisible(true);
                } else if (this.i18n.getString("ps_ot_planetnebel").equals(this.objekttyp.getSelectedItem().toString()) || this.i18n.getString("ps_ot_gasnebel").equals(this.objekttyp.getSelectedItem().toString())) {
                    this.llumi.setVisible(true);
                    this.lumi.setVisible(true);
                    List<String> list = !this.i18n.isAktuelleSpracheDeutsch() ? this.datenbankService.getNebelformen(this.i18n.getUebersetzungEnglischInDeutsch(this.objekttyp.getSelectedItem().toString())) : this.datenbankService.getNebelformen(this.objekttyp.getSelectedItem().toString());
                    for (int i = 0; i < list.size(); ++i) {
                        this.lumi.addItem(this.i18n.getUebersetzungFuerAktuelleSprache(list.get(i)));
                    }
                    this.lbv.setVisible(false);
                    this.bv.setVisible(false);
                    this.ldurchmesser2.setVisible(false);
                    this.durchmesser2.setVisible(false);
                    this.lmetal.setVisible(false);
                    this.metal.setVisible(false);
                    this.lstern.setVisible(false);
                    this.stern.setVisible(false);
                } else if (this.i18n.getString("ps_ot_ocl").equals(this.objekttyp.getSelectedItem().toString()) || this.i18n.getString("ps_ot_gcl").equals(this.objekttyp.getSelectedItem().toString())) {
                    this.llumi.setVisible(true);
                    this.lumi.setVisible(true);
                    List<String> list = !this.i18n.isAktuelleSpracheDeutsch() ? this.datenbankService.getSternhaufenformen(this.i18n.getUebersetzungEnglischInDeutsch(this.objekttyp.getSelectedItem().toString())) : this.datenbankService.getSternhaufenformen(this.objekttyp.getSelectedItem().toString());
                    for (int i = 0; i < list.size(); ++i) {
                        this.lumi.addItem(this.i18n.getUebersetzungFuerAktuelleSprache(list.get(i)));
                    }
                    if (this.i18n.getString("ps_ot_gcl").equals(this.objekttyp.getSelectedItem().toString())) {
                        this.lah.setVisible(true);
                        this.ah.setVisible(true);
                    }
                } else if (this.i18n.getString("ps_ot_galaxie").equals(this.objekttyp.getSelectedItem().toString())) {
                    this.getGalaxienform();
                    this.getGalaxiearten();
                    this.lspektraltyp.setVisible(true);
                    this.spektraltyp.setVisible(true);
                    this.ldurchmesser2.setVisible(true);
                    this.durchmesser2.setVisible(true);
                    this.lmetal.setVisible(true);
                    this.metal.setVisible(true);
                    this.lrotverschiebung.setVisible(true);
                    this.rotverschiebung.setVisible(true);
                    this.lstern.setVisible(true);
                    this.stern.setVisible(true);
                    this.lbv.setVisible(true);
                    this.bv.setVisible(true);
                    this.lah.setVisible(true);
                    this.ah.setVisible(true);
                } else if (this.objektkat.getSelectedIndex() == 10 || this.objektkat.getSelectedIndex() == 1) {
                    int n;
                    this.lah.setVisible(true);
                    this.ah.setVisible(true);
                    if (this.objektkat.getSelectedIndex() == 1) {
                        if (this.i18n.getString("ps_ot_brzwerg").equals(this.objekttyp.getSelectedItem().toString())) {
                            this.lentfernung.setText(this.i18n.getString("db_m215"));
                        } else {
                            this.lentfernung.setText(this.i18n.getString("db_m216"));
                        }
                    }
                    this.lspektraltyp.setVisible(true);
                    this.spektraltyp.removeAllItems();
                    List<String> list = this.datenbankService.getSpektraltypen(this.kategorienRepository.getKategorien().get(this.objektkat.getSelectedIndex()));
                    for (int i = 0; i < list.size(); ++i) {
                        this.spektraltyp.addItem(list.get(i));
                    }
                    this.spektraltyp.addItem(this.i18n.getString("db_unbekannt"));
                    this.spektraltyp.setVisible(true);
                    this.spektraltyp2.removeAllItems();
                    List<Double> list2 = this.datenbankService.getSpektraltypen2(this.i18n.getString("ps_ot_wzerg").equals(this.objekttyp.getSelectedItem().toString()));
                    for (n = 0; n < list2.size(); ++n) {
                        this.spektraltyp2.addItem(list2.get(n));
                    }
                    this.spektraltyp2.setVisible(true);
                    if (this.objektkat.getSelectedIndex() == 10) {
                        list = this.datenbankService.getLeuchtkraftklassen();
                        for (n = 0; n < list.size(); ++n) {
                            this.lumi.addItem(list.get(n));
                        }
                        this.llumi.setVisible(true);
                        this.lumi.setVisible(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f16") + " " + exception.toString(), this.i18n.getString(FEHLERMELDUNG_TITEL), 0);
        }
    }

    private void zeigeObjekttyp(int n) throws SQLException {
        List<String> list = this.datenbankService.getObjekttypen(this.kategorienRepository.getKategorien().get(this.objektkat.getSelectedIndex()));
        this.objekttyp.removeAllItems();
        for (String string : list) {
            this.objekttyp.addItem(this.i18n.getUebersetzungFuerAktuelleSprache(string));
        }
        this.lobjekttyp.setBounds(10, n, 200, 24);
        this.lobjekttyp.setText(this.i18n.getString("db_m71") + ":");
        this.lobjekttyp.setVisible(true);
        this.objekttyp.setBounds(250, n, 220, 24);
        this.objekttyp.setVisible(true);
    }

    private void zeigeKategoriePlaneten(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 620);
        this.tabpane.setBounds(10, 100, 590, 320);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.objekttyp.setSelectedItem("Planet");
        this.zeigeEntfernungSwingElemente(n2, this.i18n.getString("db_m217"));
        this.zeigeMasseSwingElemente(n2 += 20, this.i18n.getString("db_m218"));
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m219"));
        this.zeigeUmlaufszeitSwingElemente(n2 += 20);
        this.zeigeExzentritaetSwingElemente(n2 += 20);
        this.zeigeAlbedoSwingElemente(n2 += 20);
        this.lstern.setText(this.i18n.getString("db_m223"));
        this.lstern.setBounds(10, n2 += 20, 250, 24);
        this.lstern.setVisible(true);
        List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.STERNE.getKategorienName()), false, this.filterbedingungen);
        list.addAll(this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.BR_ZWERGE.getKategorienName()), false, this.filterbedingungen));
        Collections.sort(list);
        this.stern.removeAllItems();
        this.stern.addItem(this.i18n.getString(KEINER));
        for (int i = 0; i < list.size(); ++i) {
            this.stern.addItem(list.get(i));
        }
        this.stern.setBounds(250, n2, 220, 24);
        this.stern.setVisible(true);
        this.jumpTo.setBounds(470, n2, 120, 24);
        this.jumpTo.setVisible(true);
        n2 = 20;
        this.zeigeTemperaturSwingElemente(n2, this.i18n.getString("db_m221") + ":");
        this.zeigeEntdeckungsmethodeSwingElemente(n2 += 20);
        this.zeigeEntdeckungBestaetigtSwingElemente(n2 += 20);
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2 += 20);
        this.zeigeBildUndNotizSwingElemente(n2 += 40);
    }

    private void zeigeKategorieMonde(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 610);
        this.tabpane.setBounds(10, 100, 590, 310);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.objekttyp.setSelectedIndex(0);
        this.zeigeEntfernungSwingElemente(n2, this.i18n.getString("db_m224"));
        this.zeigeMasseSwingElemente(n2 += 20, this.i18n.getString("db_m225"));
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m226"));
        this.zeigeUmlaufszeitSwingElemente(n2 += 20);
        this.zeigeExzentritaetSwingElemente(n2 += 20);
        this.zeigeAlbedoSwingElemente(n2 += 20);
        this.zeigeScheinbareHelligkeitSwingElemente(n2 += 20, this.i18n.getString("db_m107") + ":");
        this.lplanet.setText(this.i18n.getString("db_m227"));
        this.lplanet.setBounds(10, n2 += 20, 250, 24);
        this.lplanet.setVisible(true);
        List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.PLANETEN.getKategorienName()), false, this.filterbedingungen);
        list.addAll(this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.ASTEROIDEN.getKategorienName()), false, this.filterbedingungen));
        Collections.sort(list);
        this.planet.removeAllItems();
        this.planet.addItem(this.i18n.getString(KEINER));
        for (int i = 0; i < list.size(); ++i) {
            this.planet.addItem(list.get(i));
        }
        this.planet.setBounds(250, n2, 220, 24);
        this.planet.setVisible(true);
        n2 = 20;
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2);
        this.zeigeBildUndNotizSwingElemente(n2 += 40);
    }

    private void zeigeKategorieAsteroiden(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 580);
        this.tabpane.setBounds(10, 100, 590, 280);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.objekttyp.setSelectedIndex(0);
        this.spektraltyp.removeAllItems();
        List<String> list = this.datenbankService.getSpektraltypen(this.kategorienRepository.getKategorien().get(this.objektkat.getSelectedIndex()));
        for (int i = 0; i < list.size(); ++i) {
            this.spektraltyp.addItem(list.get(i));
        }
        this.spektraltyp.setBounds(250, n2, 120, 24);
        this.spektraltyp.setVisible(true);
        this.zeigeEntfernungSwingElemente(n2 += 20, this.i18n.getString("db_m217"));
        this.zeigeMasseSwingElemente(n2 += 20, this.i18n.getString("db_m225"));
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m226"));
        this.zeigeUmlaufszeitSwingElemente(n2 += 20);
        this.zeigeExzentritaetSwingElemente(n2 += 20);
        this.zeigeAlbedoSwingElemente(n2 += 20);
        n2 = 20;
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2);
        this.zeigeBildUndNotizSwingElemente(n2 += 40);
    }

    private void zeigeKategorieKometen(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 580);
        this.tabpane.setBounds(10, 100, 590, 280);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.objekttyp.setSelectedItem("Kurzperiodischer Komet");
        this.zeigeEntfernungSwingElemente(n2, this.i18n.getString("db_m217"));
        this.zeigeUmlaufszeitSwingElemente(n2 += 20);
        this.zeigeExzentritaetSwingElemente(n2 += 20);
        n2 = 20;
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2);
        this.zeigeBildUndNotizSwingElemente(n2 += 40);
    }

    private void zeigeKategorieBrauneZwerge(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 680);
        this.tabpane.setBounds(10, 100, 590, 380);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.objekttyp.setSelectedIndex(0);
        this.lspektraltyp.setText(this.i18n.getString("db_m230"));
        this.lspektraltyp.setBounds(10, n2, 200, 24);
        this.lspektraltyp.setVisible(true);
        this.spektraltyp.removeAllItems();
        List<String> list = this.datenbankService.getSpektraltypen(this.kategorienRepository.getKategorien().get(this.objektkat.getSelectedIndex()));
        for (int i = 0; i < list.size(); ++i) {
            this.spektraltyp.addItem(list.get(i));
        }
        this.spektraltyp.setBounds(250, n2, 80, 24);
        this.spektraltyp.setVisible(true);
        this.spektraltyp2.removeAllItems();
        List<Double> list2 = this.datenbankService.getSpektraltypen2(false);
        for (int i = 0; i < list2.size(); ++i) {
            this.spektraltyp2.addItem(list2.get(i));
        }
        this.spektraltyp2.setBounds(330, n2, 80, 24);
        this.spektraltyp2.setVisible(true);
        this.zeigeSternbildRaUndDeclSwingElemente(n2 += 20);
        this.zeigeEntfernungSwingElemente(n2 += 60, this.i18n.getString("db_m215"));
        this.entfernungUmrechnen.setBounds(370, n2, 100, 24);
        this.entfernungUmrechnen.setVisible(true);
        this.zeigeMasseSwingElemente(n2 += 20, this.i18n.getString("db_m218"));
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m219"));
        this.zeigeUmlaufszeitSwingElemente(n2 += 20);
        this.zeigeExzentritaetSwingElemente(n2 += 20);
        this.zeigeScheinbareHelligkeitSwingElemente(n2 += 20, this.i18n.getString("db_m108") + ":");
        this.zeigeAbsoluteHelligkeitUndBVSwingElemente(n2 += 20);
        this.lstern.setText(this.i18n.getString("db_m232"));
        this.lstern.setBounds(10, n2 += 40, 250, 24);
        this.lstern.setVisible(true);
        List<String> list3 = this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.STERNE.getKategorienName()), false, this.filterbedingungen);
        Collections.sort(list3);
        this.stern.removeAllItems();
        this.stern.addItem(this.i18n.getString(KEINER));
        for (int i = 0; i < list3.size(); ++i) {
            this.stern.addItem(list3.get(i));
        }
        this.stern.setBounds(250, n2, 220, 24);
        this.stern.setVisible(true);
        n2 = 20;
        this.zeigeTemperaturSwingElemente(n2, this.i18n.getString("db_m231"));
        this.zeigeAlterSwingElemente(n2 += 20);
        this.zeigeEntdeckungsmethodeSwingElemente(n2 += 20);
        this.zeigeEntdeckungBestaetigtSwingElemente(n2 += 20);
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2 += 20);
        this.zeigeBildUndNotizSwingElemente(n2 += 40);
    }

    private void zeigeKategorieSterne(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 670);
        this.tabpane.setBounds(10, 100, 590, 370);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.lobjekttyp.setText(this.i18n.getString("db_m71") + ":");
        this.lobjekttyp.setVisible(true);
        this.objekttyp.setSelectedIndex(0);
        this.objekttyp.setVisible(true);
        this.lspektraltyp.setText(this.i18n.getString("db_m230"));
        this.lspektraltyp.setBounds(10, n2, 200, 24);
        this.lspektraltyp.setVisible(true);
        this.spektraltyp.setBounds(250, n2, 100, 24);
        this.spektraltyp.setVisible(true);
        this.spektraltyp2.setBounds(350, n2, 80, 24);
        this.spektraltyp2.setVisible(true);
        this.llumi.setText(this.i18n.getString("db_m233"));
        this.llumi.setBounds(10, n2 += 20, 200, 24);
        this.llumi.setVisible(true);
        this.lumi.setBounds(250, n2, 100, 24);
        this.lumi.setVisible(true);
        this.zeigeSternbildRaUndDeclSwingElemente(n2 += 20);
        this.zeigeEntfernungSwingElemente(n2 += 60, this.i18n.getString("db_m216"));
        this.entfernungUmrechnen.setBounds(370, n2, 100, 24);
        this.entfernungUmrechnen.setVisible(true);
        this.zeigeMasseSwingElemente(n2 += 20, this.i18n.getString("db_m234"));
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m235"));
        this.zeigeScheinbareHelligkeitSwingElemente(n2 += 20, this.i18n.getString("db_m108") + ":");
        this.zeigeAbsoluteHelligkeitUndBVSwingElemente(n2 += 20);
        this.zeigeGeschwindigkeitSwingElemente(n2 += 40);
        this.lstern.setText(this.i18n.getString("db_m237"));
        this.lstern.setBounds(10, n2 += 20, 230, 24);
        this.lstern.setVisible(true);
        List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.STERNHAUFEN.getKategorienName()), false, this.filterbedingungen);
        list.addAll(this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()), false, this.filterbedingungen));
        Collections.sort(list);
        this.stern.removeAllItems();
        this.stern.addItem(this.i18n.getString(KEINER));
        for (int i = 0; i < list.size(); ++i) {
            this.stern.addItem(list.get(i));
        }
        this.stern.setBounds(250, n2, 120, 24);
        this.stern.setVisible(true);
        n2 = 20;
        this.zeigeTemperaturSwingElemente(n2, this.i18n.getString("db_m231"));
        this.temperaturBerechnen.setBounds(370, n2, 100, 24);
        this.temperaturBerechnen.setVisible(true);
        this.zeigeMetallizitaetSwingElemente(n2 += 20);
        this.zeigeAlterSwingElemente(n2 += 20);
        this.zeigeBildUndNotizSwingElemente(n2 += 20);
    }

    private void zeigeKategorieSternhaufen(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 650);
        this.tabpane.setBounds(10, 100, 590, 350);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.lobjekttyp.setText(this.i18n.getString("db_m71") + ":");
        this.lobjekttyp.setVisible(true);
        this.objekttyp.setSelectedItem(this.i18n.getString("ps_ot_gcl"));
        this.objekttyp.setVisible(true);
        this.llumi.setText(this.i18n.getString("db_m238"));
        this.llumi.setBounds(10, n2, 200, 24);
        this.llumi.setVisible(true);
        this.lumi.setBounds(250, n2, 220, 24);
        this.lumi.setVisible(true);
        this.zeigeSternbildRaUndDeclSwingElemente(n2 += 20);
        this.zeigeEntfernungSwingElemente(n2 += 60, this.i18n.getString("db_m216"));
        this.entfernungUmrechnen.setBounds(370, n2, 100, 24);
        this.entfernungUmrechnen.setVisible(true);
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m239"));
        this.zeigeScheinbareHelligkeitSwingElemente(n2 += 20, this.i18n.getString("db_m108") + ":");
        this.zeigeAbsoluteHelligkeitUndBVSwingElemente(n2 += 20);
        this.zeigeFlaechenhelligkeitSwingElemente(n2 += 40);
        this.zeigeGeschwindigkeitSwingElemente(n2 += 20);
        this.lstern.setText(this.i18n.getString("db_m237"));
        this.lstern.setBounds(10, n2 += 20, 230, 24);
        this.lstern.setVisible(true);
        List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()), false, this.filterbedingungen);
        Collections.sort(list);
        this.stern.removeAllItems();
        this.stern.addItem(this.i18n.getString(KEINER));
        for (int i = 0; i < list.size(); ++i) {
            this.stern.addItem(list.get(i));
        }
        this.stern.setBounds(250, n2, 120, 24);
        this.stern.setVisible(true);
        n2 = 20;
        this.zeigeMetallizitaetSwingElemente(n2);
        this.zeigeAlterSwingElemente(n2 += 20);
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2 += 20);
        this.zeigeBildUndNotizSwingElemente(n2 += 40);
    }

    private void zeigeKategorieGalaxienUndNebel(int n) throws SQLException {
        int n2 = n;
        this.setSize(620, 720);
        this.tabpane.setBounds(10, 100, 590, 420);
        this.lname.setText(this.i18n.getString("db_m129") + ":");
        this.lobjekttyp.setText(this.i18n.getString("db_m71") + ":");
        this.lobjekttyp.setVisible(true);
        this.objekttyp.setSelectedItem(this.i18n.getString("ps_ot_galaxie"));
        this.objekttyp.setVisible(true);
        this.lspektraltyp.setText(this.i18n.getString("db_m238"));
        this.lspektraltyp.setBounds(10, n2, 200, 24);
        this.lspektraltyp.setVisible(true);
        this.spektraltyp.setBounds(250, n2, 220, 24);
        this.spektraltyp.setVisible(true);
        this.llumi.setText(this.i18n.getString("db_m240"));
        this.llumi.setBounds(10, n2 += 20, 200, 24);
        this.llumi.setVisible(true);
        this.lumi.setBounds(250, n2, 220, 24);
        this.lumi.setVisible(true);
        this.zeigeSternbildRaUndDeclSwingElemente(n2 += 20);
        this.zeigeEntfernungSwingElemente(n2 += 60, this.i18n.getString("db_m216"));
        this.entfernungUmrechnen.setBounds(370, n2, 100, 24);
        this.entfernungUmrechnen.setVisible(true);
        this.zeigeDurchmesserSwingElemente(n2 += 20, this.i18n.getString("db_m239"));
        this.ldurchmesser2.setText(this.i18n.getString("db_m241"));
        this.ldurchmesser2.setBounds(10, n2 += 20, 230, 24);
        this.durchmesser2.setBounds(250, n2, 120, 24);
        this.zeigeMasseSwingElemente(n2 += 20, this.i18n.getString("db_m234"));
        this.zeigeScheinbareHelligkeitSwingElemente(n2 += 20, this.i18n.getString("db_m108") + ":");
        this.zeigeAbsoluteHelligkeitUndBVSwingElemente(n2 += 20);
        this.zeigeFlaechenhelligkeitSwingElemente(n2 += 40);
        this.zeigeGeschwindigkeitSwingElemente(n2 += 20);
        this.lstern.setText(this.i18n.getString("db_m242"));
        this.lstern.setBounds(10, n2 += 20, 200, 24);
        List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.kategorienRepository.getKategorien().indexOf(ObjektKategorie.GALAXIENHAUFEN.getKategorienName()), false, this.filterbedingungen);
        this.stern.removeAllItems();
        this.stern.addItem(this.i18n.getString(KEINER));
        for (int i = 0; i < list.size(); ++i) {
            this.stern.addItem(list.get(i));
        }
        this.stern.setBounds(250, n2, 120, 24);
        n2 = 20;
        this.zeigeMetallizitaetSwingElemente(n2);
        this.zeigeAlterSwingElemente(n2 += 20);
        this.zeigeEntdeckungsdatumUndEntdeckerSwingElemente(n2 += 20);
        this.lsternentstehung.setBounds(10, n2 += 40, 200, 24);
        this.lsternentstehung.setVisible(true);
        this.sternentstehung.setBounds(250, n2, 120, 24);
        this.sternentstehung.setVisible(true);
        this.lrotverschiebung.setBounds(10, n2 += 20, 200, 24);
        this.lrotverschiebung.setVisible(true);
        this.rotverschiebung.setBounds(250, n2, 120, 24);
        this.rotverschiebung.setVisible(true);
        this.zeigeBildUndNotizSwingElemente(n2 += 20);
    }

    private void objektkatActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.semaphor == 0) {
                this.semaphor = 1;
                this.raUmrechnen.setVisible(false);
                this.declUmrechnen.setVisible(false);
                this.entfernungUmrechnen.setVisible(false);
                this.entdeckerAdd.setVisible(false);
                this.entfernen.setVisible(false);
                this.temperaturBerechnen.setVisible(false);
                this.jumpTo.setVisible(false);
                this.leereAlleFelder();
                this.blendeEingabefelderAus();
                int n = this.nameHoehe + 20;
                this.fuelleObjektnamen();
                this.zeigeObjekttyp(n);
                n += 20;
                if (this.objektkat.getSelectedIndex() == 7) {
                    this.zeigeKategoriePlaneten(n);
                } else if (this.objektkat.getSelectedIndex() == 6) {
                    this.zeigeKategorieMonde(n);
                } else if (this.objektkat.getSelectedIndex() == 0) {
                    this.zeigeKategorieAsteroiden(n);
                } else if (this.objektkat.getSelectedIndex() == 4) {
                    this.zeigeKategorieKometen(n);
                } else if (this.objektkat.getSelectedIndex() == 5) {
                    this.setSize(620, 530);
                    this.tabpane.setBounds(10, 100, 590, 230);
                    this.lname.setText(this.i18n.getString("db_m129") + ":");
                    this.objekttyp.setSelectedItem("Krater");
                    this.zeigeDurchmesserSwingElemente(n, this.i18n.getString("db_m229"));
                    n = 20;
                    this.zeigeBildUndNotizSwingElemente(n);
                } else if (this.objektkat.getSelectedIndex() == 1) {
                    this.zeigeKategorieBrauneZwerge(n);
                } else if (this.objektkat.getSelectedIndex() == 10) {
                    this.zeigeKategorieSterne(n);
                } else if (this.objektkat.getSelectedIndex() == 11) {
                    this.zeigeKategorieSternhaufen(n);
                } else if (this.objektkat.getSelectedIndex() == 2) {
                    this.zeigeKategorieGalaxienUndNebel(n);
                } else if (this.objektkat.getSelectedIndex() == 3) {
                    this.setSize(620, 550);
                    this.tabpane.setBounds(10, 100, 590, 250);
                    this.lname.setText(this.i18n.getString("db_m129") + ":");
                    this.objekttyp.setSelectedIndex(0);
                    this.zeigeSternbildRaUndDeclSwingElemente(n);
                    this.zeigeEntfernungSwingElemente(n += 60, this.i18n.getString("db_m216"));
                    this.entfernungUmrechnen.setBounds(370, n, 100, 24);
                    this.entfernungUmrechnen.setVisible(true);
                    this.zeigeDurchmesserSwingElemente(n += 20, this.i18n.getString("db_m239"));
                    this.zeigeScheinbareHelligkeitSwingElemente(n += 20, this.i18n.getString("db_m108") + ":");
                    this.zeigeFlaechenhelligkeitSwingElemente(n += 20);
                    n = 20;
                    this.zeigeBildUndNotizSwingElemente(n);
                } else if (this.objektkat.getSelectedIndex() == 8) {
                    this.setSize(620, 580);
                    this.tabpane.setBounds(10, 100, 590, 280);
                    this.lname.setText(this.i18n.getString("db_m129") + ":");
                    this.lobjekttyp.setText(this.i18n.getString("db_m71") + ":");
                    this.lobjekttyp.setVisible(true);
                    this.objekttyp.setVisible(true);
                    this.zeigeSternbildRaUndDeclSwingElemente(n);
                    this.zeigeEntfernungSwingElemente(n += 60, this.i18n.getString("db_m216"));
                    this.entfernungUmrechnen.setBounds(370, n, 100, 24);
                    this.entfernungUmrechnen.setVisible(true);
                    this.zeigeDurchmesserSwingElemente(n += 20, this.i18n.getString("db_m239"));
                    this.zeigeScheinbareHelligkeitSwingElemente(n += 20, this.i18n.getString("db_m108") + ":");
                    this.zeigeFlaechenhelligkeitSwingElemente(n += 20);
                    n = 20;
                    this.zeigeBildUndNotizSwingElemente(n);
                }
                this.optionjpanel.setBounds(10, this.tabpane.getY() + this.tabpane.getHeight() + 10, 590, 130);
                this.stern.setSelectedItem(this.i18n.getString(KEINER));
                this.planet.setSelectedItem(this.i18n.getString(KEINER));
                this.semaphor = 0;
                if (this.objekt.getItemCount() > 0) {
                    this.objekt.setSelectedIndex(0);
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("db_f16") + " " + exception.toString(), this.i18n.getString(FEHLERMELDUNG_TITEL), 0);
        }
    }

    private void zeigeSwingLabelUndTextfeld(JLabel jLabel, JTextField jTextField, int n) {
        jLabel.setBounds(10, n, 230, 24);
        jLabel.setVisible(true);
        jTextField.setBounds(250, n, 120, 24);
        jTextField.setVisible(true);
    }

    public FilterkonfigurationDto getFilterbedingungen() {
        return this.filterbedingungen;
    }

    public PlanetensucheObjektPruefer getPlanetensucheObjekt() {
        return this.ob;
    }

    private void zeigeMetallizitaetSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lmetal, this.metal, n);
    }

    private void zeigeAlterSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lalter, this.alter, n);
    }

    private void zeigeGeschwindigkeitSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lgeschwindigkeit, this.geschwindigkeit, n);
    }

    private void zeigeAbsoluteHelligkeitUndBVSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lah, this.ah, n);
        this.zeigeSwingLabelUndTextfeld(this.lbv, this.bv, n + 20);
    }

    private void zeigeScheinbareHelligkeitSwingElemente(int n, String string) {
        this.lsh.setText(string);
        this.zeigeSwingLabelUndTextfeld(this.lsh, this.sh, n);
    }

    private void zeigeTemperaturSwingElemente(int n, String string) {
        this.ltemperatur.setText(string);
        this.zeigeSwingLabelUndTextfeld(this.ltemperatur, this.temperaturTextfeld, n);
    }

    private void zeigeFlaechenhelligkeitSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lflaechenhelligkeit, this.flaechenhelligkeit, n);
    }

    private void zeigeEntdeckungsmethodeSwingElemente(int n) {
        this.lentdeckungsmethode.setBounds(10, n, 200, 24);
        this.lentdeckungsmethode.setVisible(true);
        this.entdeckungsmethode.setBounds(250, n, 220, 24);
        this.entdeckungsmethode.setVisible(true);
    }

    private void zeigeEntdeckungsdatumUndEntdeckerSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lentdeckungsdatum, this.entdeckungsdatum, n);
        this.zeigeSwingLabelUndTextfeld(this.lentdecker, this.entdecker, n + 20);
        this.entdeckerAdd.setBounds(370, n + 20, 120, 24);
        this.entdeckerAdd.setVisible(true);
        this.entfernen.setBounds(490, n + 20, 90, 24);
        this.entfernen.setVisible(true);
    }

    private void zeigeBildUndNotizSwingElemente(int n) {
        this.lbild.setBounds(10, n, 120, 24);
        this.bild.setBounds(250, n, 120, 24);
        this.bildAdd.setBounds(370, n, 120, 24);
        this.bildentfernen.setBounds(490, n, 90, 24);
        this.lnotiz.setBounds(10, n + 20, 200, 24);
        this.rnotiz.setBounds(250, n + 20, 330, 150);
    }

    private void zeigeSternbildRaUndDeclSwingElemente(int n) {
        this.lsternbild.setBounds(10, n, 250, 24);
        this.lsternbild.setVisible(true);
        this.sternbild.setBounds(250, n, 220, 24);
        this.sternbild.setVisible(true);
        this.koords.setBounds(10, n + 20, 250, 24);
        this.koords.setVisible(true);
        this.ra.setBounds(250, n + 20, 120, 24);
        this.ra.setVisible(true);
        this.raUmrechnen.setBounds(370, n + 20, 100, 24);
        this.raUmrechnen.setVisible(true);
        this.decl.setBounds(250, n + 40, 120, 24);
        this.decl.setVisible(true);
        this.declUmrechnen.setBounds(370, n + 40, 100, 24);
        this.declUmrechnen.setVisible(true);
    }

    private void zeigeAlbedoSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lalbedo, this.albedo, n);
    }

    private void zeigeEntfernungSwingElemente(int n, String string) {
        this.lentfernung.setText(string);
        this.zeigeSwingLabelUndTextfeld(this.lentfernung, this.entfernung, n);
    }

    private void zeigeMasseSwingElemente(int n, String string) {
        this.lmasse.setText(string);
        this.zeigeSwingLabelUndTextfeld(this.lmasse, this.masse, n);
    }

    private void zeigeExzentritaetSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lexzentritaet, this.exzentritaet, n);
    }

    private void zeigeUmlaufszeitSwingElemente(int n) {
        this.zeigeSwingLabelUndTextfeld(this.lumlaufszeit, this.umlaufszeit, n);
    }

    private void zeigeDurchmesserSwingElemente(int n, String string) {
        this.ldurchmesser.setText(string);
        this.zeigeSwingLabelUndTextfeld(this.ldurchmesser, this.durchmesser, n);
    }

    public JButton getJumpToButton() {
        return this.jumpTo;
    }

    public JComboBox<String> getObjektkatListBox() {
        return this.objektkat;
    }

    public JComboBox<String> getPlanetListBox() {
        return this.planet;
    }

    public JButton getSpringeZuObjektButton() {
        return this.springeZuObjekt;
    }

    public JButton getSpeichernButton() {
        return this.speichernButton;
    }

    public JTextField getNameTextfield() {
        return this.name;
    }

    public JComboBox<String> getObjekttypListbox() {
        return this.objekttyp;
    }

    public JTextArea getNotizTextarea() {
        return this.notiz;
    }

    public JTextField getAutorTextfield() {
        return this.autor;
    }

    public JRadioButton getSaveInXMLdatei() {
        return this.saveInXMLdatei;
    }

    private void bildentfernenActionPerformed(ActionEvent actionEvent) {
        this.bild.setText("");
    }

    private void zeigeEntdeckungBestaetigtSwingElemente(int n) {
        this.lentdeckungBestaetigt.setBounds(10, n, 200, 24);
        this.lentdeckungBestaetigt.setVisible(true);
        this.entdeckungBestaetigt.setBounds(250, n, 220, 24);
        this.entdeckungBestaetigt.setVisible(true);
    }
}

