/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.formulare.objektbearbeiten;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.api.Temperatur;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.berechnungen.EntfernungenUtil;
import de.planetensuche.datenbank.berechnungen.KoordinatenUtil;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.datenbank.dbmodel.api.IObjektnamenFilterDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.threads.ExportthreadXML;
import de.planetensuche.datenbank.guis.formulare.objektbearbeiten.EingabePlanetensucheObjektDialog;
import de.planetensuche.datenbank.guis.formulare.objektbearbeiten.EingabenamenDialog;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankBeobachter;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;

public final class EingabePlanetensucheObjektDialogControler
implements IDatenbankBeobachter {
    private static final String FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL = "db_f70_titel";
    private final EingabePlanetensucheObjektDialog dialog;
    private final ParameterDto parameter;
    private final ISprachcontainer i18n;
    private final FilterkonfigurationDto filterbedingungen;
    private final ILogging logging;
    private final IDatenbankService datenbankService;
    private String bildpfad = "";
    private final IObjektnamenFilterDAO objektnamenFilterDAO;
    private final INotizenService notizRepository;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private String vorherigesObjekt;
    private final IKategorienRepository kategorienRepository;
    private final IEntdeckerRepository entdeckerRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final InjectionDto injectionDto;
    private final KonfigurationDTO globaleKonfig;

    public EingabePlanetensucheObjektDialogControler(ParameterDto parameterDto, FilterkonfigurationDto filterkonfigurationDto, IObjektnamenFilterDAO iObjektnamenFilterDAO, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        this.parameter = parameterDto;
        this.i18n = parameterDto.getSprache();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.injectionDto = injectionDto;
        this.datenbankService = injectionDto.getDatenbankService();
        this.objektnamenFilterDAO = iObjektnamenFilterDAO;
        this.filterbedingungen = filterkonfigurationDto;
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.kategorienRepository = injectionDto.getKategorienRepository();
        this.entdeckerRepository = injectionDto.getEntdeckerRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.notizRepository = injectionDto.getNotizenService();
        this.globaleKonfig = konfigurationDTO;
        this.dialog = new EingabePlanetensucheObjektDialog(this.filterbedingungen, this.objektnamenFilterDAO, injectionDto);
        this.addActionListeners();
    }

    private void addActionListeners() {
        this.dialog.getRaUmrechnen().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.reakzentationUmrechnen();
            }
        });
        this.dialog.getDeclUmrechnen().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.deklinationUmrechnen();
            }
        });
        this.dialog.getEntfernungUmrechnen().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.entfernungVonParsecInLyUmrechnen();
            }
        });
        this.dialog.getNameAdd().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.fuegeNeuenNamenHinzu();
            }
        });
        this.dialog.getEntdeckerAdd().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.fuegeNeuenEntdeckerHinzu();
            }
        });
        this.dialog.getTemperaturBerechnen().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.berechneTemperatur();
            }
        });
        this.dialog.getLeerenButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.dialog.leereAlleFelder();
            }
        });
        this.dialog.getSpringeZuObjektButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.springeZuObjekt(EingabePlanetensucheObjektDialogControler.this.dialog.getObjektListBox());
            }
        });
        this.dialog.getJumpToButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.springeZuObjekt(EingabePlanetensucheObjektDialogControler.this.dialog.getSternListBox());
            }
        });
        this.dialog.getLoeschenButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EingabePlanetensucheObjektDialogControler.this.loescheObjekt();
            }
        });
        this.dialog.getBildAdd().addActionListener(this.createAddBildActionListener());
        this.dialog.getSpeichernButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EingabePlanetensucheObjektDialogControler.this.speichereObjekt();
                }
                catch (SQLException sQLException) {
                    EingabePlanetensucheObjektDialogControler.this.logging.error(sQLException);
                }
            }
        });
    }

    private void speichereObjekt() throws SQLException {
        if (this.dialog.getNameTextfield().getText().length() < 3) {
            this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f56"), IconPoolDefault.STOP);
            return;
        }
        if (this.dialog.getObjektkatListBox().getSelectedIndex() == 9) {
            return;
        }
        boolean bl = true;
        if (this.dialog.getObjektkatListBox().getSelectedIndex() == 7) {
            if (this.dialog.getSternListBox().getSelectedItem().toString().equals(this.i18n.getString("db_keiner"))) {
                bl = false;
                this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f57"), IconPoolDefault.STOP);
            }
        } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 1) {
            if (this.dialog.getSternListBox().getSelectedItem().toString().equals(this.i18n.getString("db_keiner")) && "Brauner Zwerg".equals(this.dialog.getObjekttypListbox().getSelectedItem().toString())) {
                bl = false;
                this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f58"), IconPoolDefault.STOP);
            }
        } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 6 && this.dialog.getPlanetListBox().getSelectedItem().toString().equals(this.i18n.getString("db_keiner"))) {
            bl = false;
            this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f59"), IconPoolDefault.STOP);
        }
        if (!this.dialog.getNotizTextarea().getText().isEmpty()) {
            int n = this.dialog.getNotizTextarea().getText().indexOf(60);
            int n2 = this.dialog.getNotizTextarea().getText().indexOf(62);
            int n3 = this.dialog.getNotizTextarea().getText().indexOf(38);
            if (n > -1 || n2 > -1 || n3 > -1) {
                bl = false;
                this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f60"), IconPoolDefault.STOP);
            }
        }
        if (bl) {
            int n;
            String[] stringArray = this.dialog.getNameTextfield().getText().split(";");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            StringBuilder stringBuilder = new StringBuilder(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringArray[n].trim();
                if (stringArray[n].length() <= 1) continue;
                arrayList.add(stringArray[n]);
                stringBuilder.append(stringArray[n]);
                stringBuilder.append(";");
            }
            this.dialog.getNameTextfield().setText(stringBuilder.substring(0, stringBuilder.length() - 1));
            n = this.objektnamenRepository.gehoertZuEinerDatenid(arrayList) ? 1 : 0;
            if (n == 0) {
                this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f61"), IconPoolDefault.STOP);
            } else {
                try {
                    if (this.objektnamenRepository.countNamen(arrayList) > 0) {
                        String string = this.kategorienRepository.getKategorieFuerObjekt((String)arrayList.get(0));
                        int n4 = JOptionPane.showConfirmDialog(this.dialog, "<html>" + this.i18n.getString("db_m204_1") + (String)arrayList.get(0) + this.i18n.getString("db_m204_2") + " " + string + this.i18n.getString("db_m204_3") + "</html>", this.i18n.getString("db_m204_titel"), 0, 3);
                        if (n4 == 0) {
                            this.save();
                        }
                    } else {
                        this.save();
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.dialog.showMessageOnMessageBar(runtimeException.toString(), IconPoolDefault.STOP);
                    this.logging.error(runtimeException);
                }
            }
        }
    }

    private void loescheObjekt() {
        block6: {
            try {
                if (this.dialog.getObjektListBox().getSelectedIndex() != -1 && this.dialog.getObjektkatListBox().getSelectedIndex() != 9) {
                    int n = JOptionPane.showConfirmDialog(this.dialog, this.i18n.getString("db_m206_1") + this.dialog.getObjektListBox().getSelectedItem().toString() + this.i18n.getString("db_m206_2"), this.i18n.getString("db_m206_titel"), 0, 3);
                    if (n != 0) break block6;
                    this.planetensucheObjektRepository.delete(this.dialog.getPlanetensucheObjekt().getDatenid());
                    try {
                        List<String> list = this.objektnamenFilterDAO.getNamenFuerKategorie(this.dialog.getObjektkatListBox().getSelectedIndex(), false, this.dialog.getFilterbedingungen());
                        this.dialog.getObjektListBox().removeAllItems();
                        for (int i = 0; i < list.size(); ++i) {
                            this.dialog.getObjektListBox().addItem(list.get(i));
                        }
                    }
                    catch (Exception exception) {
                        this.logging.error(exception);
                        JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f64") + "\n" + exception.toString(), this.i18n.getString("db_f9_titel"), 0);
                    }
                    JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_m207"), this.i18n.getString("db_m203"), 1);
                    break block6;
                }
                JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_m208"), this.i18n.getString("db_f4_titel"), 2);
            }
            catch (Exception exception) {
                this.logging.error(exception);
                JOptionPane.showMessageDialog(this.dialog, "Fehler beim Loeschen des Objektes: " + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
            }
        }
    }

    private void reakzentationUmrechnen() {
        try {
            String string = JOptionPane.showInputDialog(this.i18n.getString("db_m212"));
            if (string != null) {
                string = string.replaceAll(",", ".").trim();
                double d = KoordinatenUtil.konvertiereHhmmssInStunden(string);
                this.dialog.getRa().setText(Double.toString(d));
                this.dialog.getRa().setCaretPosition(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f68") + "\n" + numberFormatException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void deklinationUmrechnen() {
        try {
            String string = JOptionPane.showInputDialog(this.i18n.getString("db_m213"));
            if (string != null) {
                string = string.replaceAll(",", ".").trim();
                double d = KoordinatenUtil.konvertiereHhmmssInStunden(string);
                this.dialog.getDecl().setText(Double.toString(d));
                this.dialog.getDecl().setCaretPosition(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f69") + "\n" + numberFormatException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void springeZuObjekt(JComboBox jComboBox) {
        try {
            String string = JOptionPane.showInputDialog(this.dialog, this.i18n.getString("db_m243"), this.i18n.getString("db_m243_titel"), 3);
            if (string != null && string.trim().length() > 1) {
                Integer n = this.objektnamenRepository.getIDFuerNamen(string = string.trim(), false);
                if (n == null) {
                    JOptionPane.showMessageDialog(this.dialog, string + " " + this.i18n.getString("db_m310"), this.i18n.getString("db_f4_titel"), 0);
                    return;
                }
                String string2 = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
                String string3 = this.kategorienRepository.getKategorieFuerObjekt(n);
                Object object = this.dialog.getObjektkatListBox().getSelectedItem();
                if (object == null) {
                    this.dialog.getObjektkatListBox().setSelectedItem(string3);
                    jComboBox.setSelectedItem(string2);
                } else if (object.equals(string3) || jComboBox.equals(this.dialog.getSternListBox()) || jComboBox.equals(this.dialog.getPlanetListBox())) {
                    jComboBox.setSelectedItem(string2);
                } else if (jComboBox.equals(this.dialog.getObjektListBox())) {
                    this.dialog.getObjektkatListBox().setSelectedItem(string3);
                    this.dialog.getObjektListBox().setSelectedItem(string2);
                }
            }
        }
        catch (Exception exception) {
            this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f16") + " " + exception.toString(), IconPoolDefault.STOP);
            this.logging.error(exception);
        }
    }

    private void entfernungVonParsecInLyUmrechnen() {
        try {
            String string = JOptionPane.showInputDialog(this.i18n.getString("db_m211"));
            if (string != null) {
                string = string.replace(',', '.').trim();
                double d = EntfernungenUtil.parsecInLyUmrechnen(string);
                this.dialog.getEntfernung().setText(Double.toString(d));
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f67") + "\n" + numberFormatException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void fuegeNeuenNamenHinzu() {
        try {
            EingabenamenDialog eingabenamenDialog = new EingabenamenDialog(this.dialog, this.parameter);
            eingabenamenDialog.setVisible(true);
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f16") + ":\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void fuegeNeuenEntdeckerHinzu() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            List<Entdecker> list = this.entdeckerRepository.getEntdecker();
            Object[] objectArray = new Object[list.size()];
            int n = 0;
            for (Entdecker stringArray : list) {
                String string = stringArray.getNachname();
                String string2 = stringArray.getVorname();
                String string3 = stringArray.getFachgebiet();
                objectArray[n] = string3 != null && !"".equals(string3) ? string + ", " + string2 + " (" + string3 + ")" : string + ", " + string2 + " (-)";
                hashMap.put(string, string2);
                ++n;
            }
            Object object = JOptionPane.showInputDialog(this.dialog, this.i18n.getString("db_m205"), this.i18n.getString("db_m205_titel"), -1, null, objectArray, null);
            if (object != null) {
                String[] stringArray = object.toString().split(", ");
                this.dialog.getEntdecker().setText(this.dialog.getEntdecker().getText() + stringArray[0] + ";");
                this.dialog.getAusgewaehlteEntdeckerNachnameVorname().put(stringArray[0], (String)hashMap.get(stringArray[0]));
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f63") + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void berechneTemperatur() {
        try {
            if (this.dialog.getSpektraltyp().getSelectedItem().toString().equals(this.i18n.getString("db_unbekannt"))) {
                JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f62"), this.i18n.getString("db_f62_titel"), 2);
            } else {
                Temperatur temperatur = new Temperatur();
                String string = this.dialog.getSpektraltyp().getSelectedItem().toString();
                String string2 = this.dialog.getSpektraltyp2().getSelectedItem().toString();
                double d = Double.parseDouble(string2);
                double d2 = temperatur.getTemperaturFuerStern(string, d);
                this.dialog.getTemperaturTextfeld().setText(Double.toString(d2));
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f16") + ":\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private ActionListener createAddBildActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setSize(250, 250);
                jFileChooser.setVisible(true);
                jFileChooser.setDialogTitle(EingabePlanetensucheObjektDialogControler.this.i18n.getString("db_m209"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setCurrentDirectory(new File(EingabePlanetensucheObjektDialogControler.this.bildpfad));
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".bmp") || file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".gif");
                    }

                    @Override
                    public String getDescription() {
                        return EingabePlanetensucheObjektDialogControler.this.i18n.getString("db_m210");
                    }
                });
                int n = jFileChooser.showOpenDialog(EingabePlanetensucheObjektDialogControler.this.dialog);
                if (n == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    EingabePlanetensucheObjektDialogControler.this.bildpfad = fileArray[0].getPath();
                    for (int i = 0; i < fileArray.length; ++i) {
                        try {
                            File file = new File("pics" + File.separator + fileArray[i].getName());
                            if (!file.getAbsolutePath().equals(fileArray[i].getAbsolutePath())) {
                                if (file.exists()) {
                                    if (file.length() == fileArray[i].length()) {
                                        EingabePlanetensucheObjektDialogControler.this.dialog.getBild().setText(EingabePlanetensucheObjektDialogControler.this.dialog.getBild().getText() + fileArray[i].getName() + ";");
                                        continue;
                                    }
                                    int n2 = 2;
                                    while (n2 > -1) {
                                        String string;
                                        String string2 = fileArray[i].getName().substring(0, fileArray[i].getName().length() - 4);
                                        file = new File("pics" + File.separator + string2 + "-" + n2 + (string = fileArray[i].getName().substring(fileArray[i].getName().length() - 4, fileArray[i].getName().length())));
                                        if (file.exists()) continue;
                                        FileUtils.copyFile(fileArray[i], file);
                                        EingabePlanetensucheObjektDialogControler.this.dialog.getBild().setText(EingabePlanetensucheObjektDialogControler.this.dialog.getBild().getText() + file.getName() + ";");
                                        n2 = -2;
                                    }
                                    continue;
                                }
                                FileUtils.copyFile(fileArray[i], file);
                                EingabePlanetensucheObjektDialogControler.this.dialog.getBild().setText(EingabePlanetensucheObjektDialogControler.this.dialog.getBild().getText() + fileArray[i].getName() + ";");
                                continue;
                            }
                            EingabePlanetensucheObjektDialogControler.this.dialog.getBild().setText(EingabePlanetensucheObjektDialogControler.this.dialog.getBild().getText() + fileArray[i].getName() + ";");
                            continue;
                        }
                        catch (Exception exception) {
                            EingabePlanetensucheObjektDialogControler.this.logging.error(exception);
                            JOptionPane.showMessageDialog(EingabePlanetensucheObjektDialogControler.this.dialog, EingabePlanetensucheObjektDialogControler.this.i18n.getString("db_f66") + " " + exception.toString(), EingabePlanetensucheObjektDialogControler.this.i18n.getString("db_f4_titel"), 0);
                        }
                    }
                }
            }
        };
    }

    public void save() {
        this.dialog.sperreGUI(true);
        try {
            Object object;
            this.dialog.korrigiere();
            String[] stringArray = this.dialog.getNameTextfield().getText().split(";");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            HashSet<String> hashSet = new HashSet<String>(arrayList);
            IPlanetensucheObjekt iPlanetensucheObjekt = null;
            for (String object32 : hashSet) {
                object = this.objektnamenRepository.getIDFuerNamen(object32, true);
                if (object == null) continue;
                IPlanetensucheObjekt iPlanetensucheObjekt2 = this.planetensucheObjektRepository.read((Integer)object);
                iPlanetensucheObjekt = new PlanetensucheObjektPruefer(BeanFactory.getInstanceDaoHigh(), iPlanetensucheObjekt2);
                break;
            }
            if (iPlanetensucheObjekt == null) {
                iPlanetensucheObjekt = new PlanetensucheObjektPruefer(BeanFactory.getInstanceDaoHigh());
            }
            iPlanetensucheObjekt.setObjektNamen(hashSet);
            this.vorherigesObjekt = (String)arrayList.get(0);
            iPlanetensucheObjekt.setKategorie(this.kategorienRepository.getKategorien().get(this.dialog.getObjektkatListBox().getSelectedIndex()));
            if (!this.i18n.isAktuelleSpracheDeutsch()) {
                iPlanetensucheObjekt.setObjekttyp(this.i18n.getUebersetzungEnglischInDeutsch(this.dialog.getObjekttypListbox().getSelectedItem().toString()));
            } else {
                iPlanetensucheObjekt.setObjekttyp(this.dialog.getObjekttypListbox().getSelectedItem().toString());
            }
            if ("Other".equals(this.dialog.getObjekttypListbox().getSelectedItem().toString())) {
                iPlanetensucheObjekt.setObjekttyp("sonstiges");
            }
            int n = this.setztePruefeEingabenUndHauptdaten((IPlanetensucheObjektPruefer)iPlanetensucheObjekt);
            if (!this.dialog.entdecker.getText().isEmpty()) {
                String[] stringArray2 = this.dialog.entdecker.getText().split(";");
                object = new HashMap(stringArray2.length);
                if (stringArray2.length > 0) {
                    for (String string : stringArray2) {
                        object.put(string, this.dialog.ausgewaehlteEntdeckerNachnameVorname.get(string));
                    }
                }
                iPlanetensucheObjekt.setEntdeckerMitNachnamenVornamen((Map<String, String>)object);
            }
            if (this.dialog.getObjektkatListBox().getSelectedIndex() == 7 || this.dialog.getObjektkatListBox().getSelectedIndex() == 1 || this.dialog.getObjektkatListBox().getSelectedIndex() == 10 || this.dialog.getObjektkatListBox().getSelectedIndex() == 11 || this.dialog.getObjekttypListbox().getSelectedItem().toString().equals(this.i18n.getString("ps_ot_galaxie"))) {
                if (!this.dialog.getSternListBox().getSelectedItem().toString().equals(this.i18n.getString("db_keiner"))) {
                    iPlanetensucheObjekt.setUmkreistObjekt(this.dialog.getSternListBox().getSelectedItem().toString());
                }
            } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 6) {
                iPlanetensucheObjekt.setUmkreistObjekt(this.dialog.getPlanetListBox().getSelectedItem().toString());
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            if (this.dialog.bild.getText().length() > 0 && ((String[])(object = this.dialog.bild.getText().split(";"))).length > 0) {
                hashSet2.addAll(Arrays.asList(object));
            }
            iPlanetensucheObjekt.setBilder(hashSet2);
            iPlanetensucheObjekt.setNotiz("");
            this.dialog.getNotizTextarea().setText(this.dialog.getNotizTextarea().getText().trim());
            if (this.dialog.getNotizTextarea().getText().length() > 1) {
                this.notizRepository.saveNotiz(iPlanetensucheObjekt, this.dialog.getNotizTextarea().getText());
            }
            if (n > 0) {
                object = this.i18n.getString("db_f89_4");
                if (n == 1) {
                    object = this.i18n.getString("db_f89_3");
                }
                JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f89_1") + " " + n + " " + this.i18n.getString("db_f89_2") + " " + (String)object + ".", this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 0);
            } else {
                iPlanetensucheObjekt.setAutor(this.dialog.getAutorTextfield().getText());
                object = Calendar.getInstance();
                Timestamp timestamp = new Timestamp(((Calendar)object).getTimeInMillis());
                iPlanetensucheObjekt.setStamp(timestamp);
                iPlanetensucheObjekt.setAbsoluteHelligkeit(-100.0);
                if (iPlanetensucheObjekt.getDatenid() == null) {
                    this.planetensucheObjektRepository.create((IPlanetensucheObjektPruefer)iPlanetensucheObjekt, true, this.injectionDto.getKatalogerkenner());
                } else {
                    this.planetensucheObjektRepository.update((IPlanetensucheObjektPruefer)iPlanetensucheObjekt, true, this.injectionDto.getKatalogerkenner());
                }
                this.nachBatchEnde(null, true, iPlanetensucheObjekt.getObjektNamen().get(0));
            }
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f93") + "\n" + exception.toString(), this.i18n.getString("db_f4_titel"), 0);
            this.nachBatchEnde(null, false, "?");
        }
        this.dialog.sperreGUI(false);
    }

    @Override
    public void nachBatchEnde(SQLException sQLException, boolean bl, String string) {
        if (bl) {
            Object object;
            Object object2;
            if (this.dialog.getSaveInXMLdatei().isSelected()) {
                object2 = new JFileChooser();
                ((JFileChooser)object2).setDialogTitle(this.i18n.getString("db_m195"));
                ((JFileChooser)object2).setCurrentDirectory(new File(""));
                ((JFileChooser)object2).setFileSelectionMode(2);
                ((JFileChooser)object2).setMultiSelectionEnabled(false);
                ((JFileChooser)object2).setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return EingabePlanetensucheObjektDialogControler.this.i18n.getString("db_m167");
                    }
                });
                ((Component)object2).setSize(250, 250);
                int n = ((JFileChooser)object2).showSaveDialog(this.dialog);
                if (n == 0) {
                    object = ((JFileChooser)object2).getSelectedFile();
                    if (!((File)object).getName().endsWith(".xml")) {
                        object = new File(((File)object).getAbsolutePath() + ".xml");
                    }
                    ExportthreadXML exportthreadXML = new ExportthreadXML((File)object, null, this.parameter, this.injectionDto, this.globaleKonfig);
                    exportthreadXML.exportiereXMLMitJDOM(1, this.dialog.ob.getObjektNamen().get(0));
                }
            }
            try {
                this.dialog.semaphor = 1;
                object2 = this.objektnamenFilterDAO.getNamenFuerKategorie(this.dialog.getObjektkatListBox().getSelectedIndex(), false, this.filterbedingungen);
                this.dialog.getObjektListBox().removeAllItems();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    this.dialog.getObjektListBox().addItem((String)object);
                }
                object2 = null;
                this.dialog.semaphor = 0;
                this.dialog.getObjektListBox().setSelectedItem(this.vorherigesObjekt);
            }
            catch (Exception exception) {
                this.dialog.semaphor = 0;
                this.logging.error(exception);
                JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f91") + "\n" + exception.toString(), this.i18n.getString("db_f9_titel"), 0);
            }
            this.dialog.showMessageOnMessageBar(this.i18n.getString("db_m214_1") + this.vorherigesObjekt + this.i18n.getString("db_m214_2"), IconPoolDefault.INFO);
        } else {
            if (sQLException != null) {
                this.logging.error(sQLException);
            }
            this.dialog.showMessageOnMessageBar(this.i18n.getString("db_f92"), IconPoolDefault.STOP);
        }
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    private int setztePruefeEingabenUndHauptdaten(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer) throws SQLException {
        double d;
        Object object;
        int n = 0;
        boolean bl = false;
        if (this.dialog.albedo.isVisible() && !this.dialog.albedo.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setAlbedo(this.i18n.parseDouble(this.dialog.albedo.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f70"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.bv.isVisible() && !this.dialog.bv.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setBV(this.i18n.parseDouble(this.dialog.bv.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f71"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.decl.isVisible() && !this.dialog.decl.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setDECL(this.i18n.parseDouble(this.dialog.decl.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f72"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.sternbild.isVisible()) {
            object = this.datenbankService.getSternbildsprache();
            if (SternbildSprache.DEUTSCH.equals(object)) {
                iPlanetensucheObjektPruefer.setSternbildDTBezeichnung(this.dialog.sternbild.getSelectedItem().toString());
            } else if (SternbildSprache.LATEINISCH.equals(object)) {
                iPlanetensucheObjektPruefer.setSternbildLATBezeichnung(this.dialog.sternbild.getSelectedItem().toString());
            } else {
                iPlanetensucheObjektPruefer.setSternbildENGBezeichnung(this.dialog.sternbild.getSelectedItem().toString());
            }
        }
        if (this.dialog.durchmesser.isVisible() && !this.dialog.durchmesser.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setDurchmesser(this.i18n.parseDouble(this.dialog.durchmesser.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f73"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.durchmesser2.isVisible() && !this.dialog.durchmesser2.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setGalaxienDurchmesserInLy(this.i18n.parseDouble(this.dialog.durchmesser2.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f74"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.entdeckungsdatum.isVisible() && !this.dialog.entdeckungsdatum.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setEntdeckungsdatum(this.dialog.entdeckungsdatum.getText()))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f75"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.entdeckungsmethode.isVisible()) {
            if (!this.i18n.isAktuelleSpracheDeutsch()) {
                iPlanetensucheObjektPruefer.setEntdeckungsmethode(this.i18n.getUebersetzungEnglischInDeutsch(this.dialog.entdeckungsmethode.getSelectedItem().toString()));
            } else {
                iPlanetensucheObjektPruefer.setEntdeckungsmethode(this.dialog.entdeckungsmethode.getSelectedItem().toString());
            }
        }
        if (this.dialog.entdeckungBestaetigt.isVisible()) {
            iPlanetensucheObjektPruefer.setEntdeckungBestaetigt(this.dialog.entdeckungBestaetigt.isSelected());
        }
        if (this.dialog.entfernung.isVisible() && !this.dialog.entfernung.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setEntfernung(this.i18n.parseDouble(this.dialog.entfernung.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f76"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.exzentritaet.isVisible() && !this.dialog.exzentritaet.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setExzentritaet(this.i18n.parseDouble(this.dialog.exzentritaet.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f77"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.spektraltyp.isVisible()) {
            object = this.dialog.spektraltyp.getSelectedItem().toString();
            if (!this.i18n.isAktuelleSpracheDeutsch()) {
                object = this.i18n.getUebersetzungEnglischInDeutsch(this.dialog.spektraltyp.getSelectedItem().toString());
            }
            if (this.dialog.getObjekttypListbox().getSelectedItem().toString().equals(this.i18n.getString("ps_ot_galaxie"))) {
                iPlanetensucheObjektPruefer.setGalaxienart((String)object);
            } else {
                iPlanetensucheObjektPruefer.setSpektralklasse((String)object);
            }
        }
        if (this.dialog.spektraltyp2.isVisible()) {
            iPlanetensucheObjektPruefer.setSpektralklasse2(this.i18n.parseDouble(this.dialog.spektraltyp2.getSelectedItem().toString()));
        }
        if (this.dialog.lumi.isVisible()) {
            if (!this.i18n.isAktuelleSpracheDeutsch()) {
                if (this.dialog.getObjekttypListbox().getSelectedItem().toString().equals(this.i18n.getString("ps_ot_galaxie"))) {
                    iPlanetensucheObjektPruefer.setGalaxienform(this.i18n.getUebersetzungEnglischInDeutsch(this.dialog.lumi.getSelectedItem().toString()));
                } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 11) {
                    iPlanetensucheObjektPruefer.setSternhaufenform(this.i18n.getUebersetzungEnglischInDeutsch(this.dialog.lumi.getSelectedItem().toString()));
                } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 2) {
                    iPlanetensucheObjektPruefer.setNebelform(this.i18n.getUebersetzungEnglischInDeutsch(this.dialog.lumi.getSelectedItem().toString()));
                } else {
                    iPlanetensucheObjektPruefer.setLeuchtkraftklasse(this.dialog.lumi.getSelectedItem().toString());
                }
            } else if ("Galaxie".equals(this.dialog.getObjekttypListbox().getSelectedItem().toString())) {
                iPlanetensucheObjektPruefer.setGalaxienform(this.dialog.lumi.getSelectedItem().toString());
            } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 11) {
                iPlanetensucheObjektPruefer.setSternhaufenform(this.dialog.lumi.getSelectedItem().toString());
            } else if (this.dialog.getObjektkatListBox().getSelectedIndex() == 2) {
                iPlanetensucheObjektPruefer.setNebelform(this.dialog.lumi.getSelectedItem().toString());
            } else {
                iPlanetensucheObjektPruefer.setLeuchtkraftklasse(this.dialog.lumi.getSelectedItem().toString());
            }
        }
        if (this.dialog.geschwindigkeit.isVisible() && !this.dialog.geschwindigkeit.getText().isEmpty()) {
            iPlanetensucheObjektPruefer.setGeschwindigkeit(this.i18n.parseDouble(this.dialog.geschwindigkeit.getText()));
        }
        if (this.dialog.masse.isVisible() && !this.dialog.masse.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setMasse(this.i18n.parseDouble(this.dialog.masse.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f78"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.metal.isVisible() && !this.dialog.metal.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setMetallizitaet(this.i18n.parseDouble(this.dialog.metal.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f79"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.ra.isVisible() && !this.dialog.ra.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setRA(this.i18n.parseDouble(this.dialog.ra.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f80"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.sh.isVisible() && !this.dialog.sh.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setScheinbareHelligkeit(this.i18n.parseDouble(this.dialog.sh.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f81"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.flaechenhelligkeit.isVisible() && !this.dialog.flaechenhelligkeit.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setFlaechenhelligkeit(this.i18n.parseDouble(this.dialog.flaechenhelligkeit.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f82"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.temperaturTextfeld.isVisible() && !this.dialog.temperaturTextfeld.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setTemperatur(this.i18n.parseDouble(this.dialog.temperaturTextfeld.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f83"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.umlaufszeit.isVisible() && !this.dialog.umlaufszeit.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setUmlaufszeit(this.i18n.parseDouble(this.dialog.umlaufszeit.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f84"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.sternentstehung.isVisible() && !this.dialog.sternentstehung.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setSternentstehung((int)this.i18n.parseDouble(this.dialog.sternentstehung.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f85"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.rotverschiebung.isVisible() && !this.dialog.rotverschiebung.getText().isEmpty() && !(bl = iPlanetensucheObjektPruefer.setRotverschiebung(this.i18n.parseDouble(this.dialog.rotverschiebung.getText())))) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f86"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        if (this.dialog.alter.isVisible() && !this.dialog.alter.getText().isEmpty() && !(bl = (d = this.i18n.parseDouble(this.dialog.alter.getText())) >= 0.0 ? iPlanetensucheObjektPruefer.setAlterInMrdJahre(d) : false)) {
            ++n;
            JOptionPane.showMessageDialog(this.dialog, this.i18n.getString("db_f87"), this.i18n.getString(FEHLERMELDUNG_FEHLERHAFTE_EINGABE_TITEL), 2);
        }
        return n;
    }
}

