/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.gaia;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.gaia.main.GaiaDataRelease;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataDto;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataService;
import de.planetensuche.datenbank.guis.gaia.GaiaStellarDataDialog;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class GaiaStellarDataDialogController {
    private static final String I18N_KEY_NO_DATA = "db_m488";
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final GaiaStellarDataDialog dialog = new GaiaStellarDataDialog();
    private final GaiaStellarDataService dataService = new GaiaStellarDataService();

    public void showDialog() {
        EventQueue.invokeLater(() -> {
            this.addButtonListener();
            this.dialog.setVisible(true);
        });
    }

    public void disposeDialog() {
        this.dialog.dispose();
    }

    private void addButtonListener() {
        this.dialog.getButtonQuery().addActionListener(actionEvent -> Executors.newSingleThreadExecutor().submit(() -> {
            this.clearAllOutputFields();
            this.startScan(this.dialog.getGaiaDataReleaseComboBox().getSelectedItem().toString(), this.dialog.getTextFieldGaiaSourceId().getText().trim());
        }));
        this.dialog.getButtonCopy().addActionListener(actionEvent -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getI18n("db_gui190")).append("\n");
            stringBuilder.append("---------------------------------------------\n");
            stringBuilder.append("Gaia ").append(this.dialog.getGaiaDataReleaseComboBox().getSelectedItem()).append(" source id:").append(" ").append(this.dialog.getTextFieldGaiaSourceId().getText()).append("\n");
            stringBuilder.append("Gaia DR3 source id:").append(" ").append(this.dialog.getTextFieldGaiaDr3SourceId().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui192")).append(" ").append(this.dialog.getTextFieldTeffGspphot().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui193")).append(" ").append(this.dialog.getTextFieldTeffGspspec().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui194")).append(" ").append(this.dialog.getTextFieldDistance().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui195")).append(" ").append(this.dialog.getTextFieldSptyp().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui196")).append(" ").append(this.dialog.getTextFieldRadiusGspphot().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui197")).append(" ").append(this.dialog.getTextFieldRadiusFlame().getText()).append("\n");
            stringBuilder.append(this.getI18n("db_gui198")).append(" ").append(this.dialog.getTextFieldMass().getText()).append("\n");
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
        });
    }

    private void clearAllOutputFields() {
        this.dialog.getTextFieldGaiaDr3SourceId().setText("");
        this.dialog.getTextFieldDistance().setText("");
        this.dialog.getTextFieldMass().setText("");
        this.dialog.getTextFieldRadiusFlame().setText("");
        this.dialog.getTextFieldRadiusGspphot().setText("");
        this.dialog.getTextFieldSptyp().setText("");
        this.dialog.getTextFieldTeffGspphot().setText("");
        this.dialog.getTextFieldTeffGspspec().setText("");
    }

    boolean startScan(String string, String string2) {
        long l;
        if (Check.isEmpty(string2)) {
            String string3 = this.dialog.getI18n().getString("db_m499");
            String string4 = this.dialog.getI18n().getString("db_m486");
            JOptionPane.showMessageDialog(this.dialog, string3, string4, 1);
            return false;
        }
        try {
            l = Long.parseLong(string2);
            if (l < 1L) {
                String string5 = this.dialog.getI18n().getString("db_f124");
                String string6 = this.dialog.getI18n().getString("db_f124_titel");
                JOptionPane.showMessageDialog(this.dialog, string5, string6, 2);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string7 = this.dialog.getI18n().getString("db_f124");
            String string8 = this.dialog.getI18n().getString("db_f124_titel");
            JOptionPane.showMessageDialog(this.dialog, string7, string8, 2);
            return false;
        }
        this.dialog.getButtonQuery().setEnabled(false);
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        try {
            GaiaDataRelease gaiaDataRelease = GaiaDataRelease.valueOf(string);
            Optional<GaiaStellarDataDto> optional = this.dataService.queryGaia(gaiaDataRelease, l);
            if (optional.isEmpty()) {
                this.dialog.getTextFieldGaiaDr3SourceId().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
                this.enableQueryButton();
                return false;
            }
            GaiaStellarDataDto gaiaStellarDataDto = optional.get();
            this.dialog.getTextFieldGaiaDr3SourceId().setText(gaiaStellarDataDto.gaiaDr3SourceId());
            this.showValue(gaiaStellarDataDto.teffGspphot(), gaiaStellarDataDto.teffGspphotLower(), gaiaStellarDataDto.teffGspphotUpper(), this.dialog.getTextFieldTeffGspphot());
            this.showValue(gaiaStellarDataDto.teffGspspec(), gaiaStellarDataDto.teffGspspecLower(), gaiaStellarDataDto.teffGspspecUpper(), this.dialog.getTextFieldTeffGspspec());
            this.showValue(gaiaStellarDataDto.distanceGspphotInPc(), gaiaStellarDataDto.distanceGspphotLower(), gaiaStellarDataDto.distanceGspphotUpper(), this.dialog.getTextFieldDistance());
            this.showValue(gaiaStellarDataDto.massFlame(), gaiaStellarDataDto.massFlameLower(), gaiaStellarDataDto.massFlameUpper(), this.dialog.getTextFieldMass());
            this.showValue(gaiaStellarDataDto.radiusFlame(), gaiaStellarDataDto.radiusFlameLower(), gaiaStellarDataDto.radiusFlameUpper(), this.dialog.getTextFieldRadiusFlame());
            this.showValue(gaiaStellarDataDto.radiusGspphot(), gaiaStellarDataDto.radiusGspphotLower(), gaiaStellarDataDto.radiusGspphotUpper(), this.dialog.getTextFieldRadiusGspphot());
            if (Check.isEmpty(gaiaStellarDataDto.spectraltypeEsphs())) {
                this.dialog.getTextFieldSptyp().setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
            } else {
                this.dialog.getTextFieldSptyp().setText(gaiaStellarDataDto.spectraltypeEsphs());
            }
            this.enableQueryButton();
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            this.enableQueryButton();
            JOptionPane.showMessageDialog(this.dialog, this.getI18n("db_m450"), this.getI18n("db_m144"), 2);
            return false;
        }
        catch (IOException iOException) {
            this.logger.error("gaia DR2 source id = " + string2, iOException);
            this.enableQueryButton();
            return false;
        }
    }

    private void enableQueryButton() {
        this.dialog.setCursor(Cursor.getDefaultCursor());
        this.dialog.getButtonQuery().setEnabled(true);
    }

    private String getI18n(String string) {
        return this.dialog.getSprachcontainer().getString(string);
    }

    private String formatValue(double d) {
        if (d == 0.0) {
            return this.dialog.getI18n().getString(I18N_KEY_NO_DATA);
        }
        return this.dialog.getI18n().toLocalisedDouble(d);
    }

    private void showValue(double d, double d2, double d3, JTextField jTextField) {
        if (d == 0.0) {
            jTextField.setText(this.dialog.getI18n().getString(I18N_KEY_NO_DATA));
        } else {
            jTextField.setText(this.formatValue(d) + " (" + this.formatValue(d2) + " - " + this.formatValue(d3) + ")");
        }
    }
}

