/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.menuextras;

import de.planetensuche.core.Check;
import de.planetensuche.datenbank.guis.TabellenBasisdialog;
import de.planetensuche.datenbankkern.api.kategorien.ExoplanetOverviewDto;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExoplanetenEntdeckungsdatumControllerAndDialog
extends TabellenBasisdialog {
    private final IPlanetenRepository planetenRepository;
    private final JComboBox entdecker;
    private final JCheckBox onlyConfirmedPlanets;
    private final AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor;

    public ExoplanetenEntdeckungsdatumControllerAndDialog(IPlanetenRepository iPlanetenRepository) {
        super(BasisdialogId.DATENBANK_EXOPLANETEN_ENTDECKUNGSDATUM);
        this.planetenRepository = iPlanetenRepository;
        this.asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        JPanel jPanel = new JPanel();
        jPanel.setMaximumSize(new Dimension(900, 30));
        super.add((Component)jPanel, 1);
        this.entdecker = new JComboBox();
        this.entdecker.setSize(300, 24);
        this.entdecker.setMaximumSize(new Dimension(300, 25));
        this.entdecker.setVisible(true);
        this.entdecker.setEnabled(false);
        this.entdecker.addItem("");
        jPanel.add(this.entdecker);
        this.entdecker.addItemListener(itemEvent -> {
            if (Check.isFilled(itemEvent.getItem())) {
                this.refreshTableData();
            }
        });
        this.onlyConfirmedPlanets = new JCheckBox(this.i18n.getString("db_gui136"));
        this.onlyConfirmedPlanets.setMaximumSize(new Dimension(300, 25));
        this.onlyConfirmedPlanets.setVisible(true);
        this.onlyConfirmedPlanets.setEnabled(true);
        this.onlyConfirmedPlanets.setSelected(true);
        jPanel.add(this.onlyConfirmedPlanets);
        this.onlyConfirmedPlanets.addActionListener(actionEvent -> this.refreshTableData());
    }

    private void refreshTableData() {
        this.asyncLoadingScreenCallbackExecutor.execute(this, () -> {
            this.loadExoplanetTable();
            this.fireTableDataChanged();
            this.ausgabe.resizeColumnWidth();
        });
    }

    @Override
    public void showDialog() {
        try {
            this.entdecker.setSelectedIndex(-1);
            List<String> list = this.planetenRepository.findExoplanetenEntdecker();
            for (String string : list) {
                this.entdecker.addItem(string);
            }
            this.entdecker.setSelectedIndex(-1);
            this.entdecker.setEnabled(true);
            this.loadExoplanetTable();
            this.setSize(900, 600);
            super.showDialog();
            this.ausgabe.disableDragColumns();
            this.ausgabe.disableEditMode();
            this.ausgabe.setAutoResizeMode(0);
            this.ausgabe.resizeColumnWidth();
        }
        catch (RuntimeException | SQLException exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, this.getSprachcontainer().getString("db_f7") + "\n" + exception.toString(), this.getSprachcontainer().getString("db_f4_titel"), 0);
        }
    }

    private void loadExoplanetTable() {
        try {
            List<Object> list;
            Optional<String> optional = this.getSelectedDiscoverer();
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = 0;
            for (int i = 1989; i <= gregorianCalendar.get(1); ++i) {
                list = this.planetenRepository.getExoplanetenProJahr(i, this.onlyConfirmedPlanets.isSelected(), optional);
                if (list.isEmpty()) continue;
                for (ExoplanetOverviewDto exoplanetOverviewDto : list) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(exoplanetOverviewDto.getPlanetName());
                    arrayList2.add(this.getSprachcontainer().toLocalisedDate(exoplanetOverviewDto.getDiscoveryDate()));
                    if (exoplanetOverviewDto.isConfirmed()) {
                        arrayList2.add("x");
                    } else {
                        arrayList2.add("");
                    }
                    arrayList2.add(exoplanetOverviewDto.getDiscoverer());
                    arrayList.add(arrayList2);
                }
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add("");
                arrayList3.add("");
                arrayList3.add("");
                arrayList3.add("");
                arrayList.add(arrayList3);
                ++n;
            }
            List<ExoplanetOverviewDto> list2 = this.planetenRepository.getExoplanetenProJahr(null, this.onlyConfirmedPlanets.isSelected(), optional);
            for (ExoplanetOverviewDto exoplanetOverviewDto : list2) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add(exoplanetOverviewDto.getPlanetName());
                arrayList3.add("?");
                if (exoplanetOverviewDto.isConfirmed()) {
                    arrayList3.add("x");
                } else {
                    arrayList3.add("");
                }
                arrayList3.add(exoplanetOverviewDto.getDiscoverer());
                arrayList.add(arrayList3);
            }
            super.setTabellenDaten(arrayList);
            list = new ArrayList<String>();
            list.add(this.getSprachcontainer().getString("db_m3"));
            list.add(this.getSprachcontainer().getString("db_m127"));
            list.add(this.getSprachcontainer().getString("db_m451"));
            list.add(this.getSprachcontainer().getString("db_m128"));
            super.setTabellenUeberschriften(list);
            super.setTitle(arrayList.size() - n + " " + this.getSprachcontainer().getString("db_m3"));
        }
        catch (RuntimeException | SQLException exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(null, this.getSprachcontainer().getString("db_f7") + "\n" + exception.toString(), this.getSprachcontainer().getString("db_f4_titel"), 0);
        }
    }

    private Optional<String> getSelectedDiscoverer() {
        if (this.entdecker.getSelectedIndex() == -1 || Check.isEmpty(this.entdecker.getSelectedItem())) {
            return Optional.empty();
        }
        String string = this.entdecker.getSelectedItem().toString();
        if (string.contains(", ")) {
            string = string.substring(0, string.indexOf(", "));
        }
        return Optional.of(string);
    }
}

