/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.menuextras;

import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.guis.menuextras.NamenlisteOption;
import de.planetensuche.datenbank.guis.menuextras.NamenslisteDialog;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import java.util.List;
import javax.swing.JFrame;

public final class NamenslisteThread
extends Thread {
    private final ParameterDto parameter;
    private final NamenlisteOption option;
    private final JFrame mainDialog;
    private final IObjektnamenRepository objektnamenRepository;

    public NamenslisteThread(JFrame jFrame, ParameterDto parameterDto, NamenlisteOption namenlisteOption, IObjektnamenRepository iObjektnamenRepository) {
        this.parameter = parameterDto;
        this.option = namenlisteOption;
        this.mainDialog = jFrame;
        this.objektnamenRepository = iObjektnamenRepository;
    }

    @Override
    public void run() {
        if (null == this.option) {
            throw new UnsupportedOperationException("unbekannte Auswahl " + String.valueOf((Object)this.option));
        }
        List<String> list = switch (this.option) {
            case NamenlisteOption.STERNE -> this.objektnamenRepository.findCommonNames(ObjektKategorie.STERNE);
            case NamenlisteOption.STERNHAUFEN -> this.objektnamenRepository.findCommonNames(ObjektKategorie.STERNHAUFEN);
            case NamenlisteOption.DEEP_SKY -> this.objektnamenRepository.findCommonNames(ObjektKategorie.GALAXIE_NEBEL, ObjektKategorie.GALAXIENHAUFEN);
            case NamenlisteOption.PLANETEN -> this.objektnamenRepository.findCommonNames(ObjektKategorie.PLANETEN);
            default -> throw new UnsupportedOperationException("unbekannte Auswahl " + String.valueOf((Object)this.option));
        };
        NamenslisteDialog namenslisteDialog = new NamenslisteDialog(this.mainDialog, this.parameter);
        namenslisteDialog.showDialog(list, this.option);
    }
}

