/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.guis.menuextras;

import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.IRekordeDAOObserver;
import de.planetensuche.datenbank.dbmodel.menuextras.rekorde.RekordeDAOFabrik;
import de.planetensuche.datenbank.guis.TabellenBasisdialog;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallback;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class RekordeDialog
extends TabellenBasisdialog
implements IRekordeDAOObserver {
    private static final int ANZAHL_AUFRUFER = 12;
    private final JFrame datenbankGui;
    private int aufrufZaehler;
    private final Map<Integer, List<String>> zwischenErgebnisse;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IdCacheDAO cacheDao;
    private long startDatenHolen = 0L;

    public RekordeDialog(JFrame jFrame, IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, IDatenbankverbinder iDatenbankverbinder, IdCacheDAO idCacheDAO) {
        super(BasisdialogId.DATENBANK_REKORDE);
        this.datenbankGui = jFrame;
        this.datenbankverbinder = iDatenbankverbinder;
        this.cacheDao = idCacheDAO;
        this.aufrufZaehler = 0;
        this.zwischenErgebnisse = new HashMap<Integer, List<String>>(10);
        this.objektnamenRepository = iObjektnamenRepository;
        this.kategorienRepository = iKategorienRepository;
    }

    public void starteRekordzusammenstellung(JFrame jFrame) {
        AsyncLoadingScreenCallback asyncLoadingScreenCallback = () -> {
            try {
                RekordeDAOFabrik rekordeDAOFabrik = new RekordeDAOFabrik(this.getSprachcontainer());
                this.startDatenHolen = System.currentTimeMillis();
                rekordeDAOFabrik.starteRekordzusammenstellung(this, this.objektnamenRepository, this.kategorienRepository, this.datenbankverbinder, this.cacheDao);
            }
            catch (InterruptedException | RuntimeException exception) {
                this.getLogger().error(exception);
            }
        };
        new AsyncLoadingScreenCallbackExecutor().execute(this.datenbankGui, asyncLoadingScreenCallback);
    }

    private void zeigeFensterAn() {
        try {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < 12; ++i) {
                List<String> list = this.zwischenErgebnisse.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    String[] stringArray = list.get(j).split(";");
                    ArrayList<String> arrayList2 = new ArrayList<String>(3);
                    arrayList2.add(stringArray[0]);
                    arrayList2.add(stringArray[1]);
                    arrayList2.add(stringArray[2]);
                    arrayList.add(arrayList2);
                }
            }
            SwingUtilities.invokeLater(() -> {
                this.setTabellenDaten(arrayList);
                this.setSize(800, 600);
                ArrayList<String> arrayList = new ArrayList<String>(3);
                arrayList.add(this.getSprachcontainer().getString("db_m16"));
                arrayList.add(this.getSprachcontainer().getString("db_m5"));
                arrayList.add(this.getSprachcontainer().getString("db_m17"));
                this.setTabellenUeberschriften(arrayList);
                this.setTitle(this.getSprachcontainer().getString("db_m18"));
                super.showDialog();
            });
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this.datenbankGui, this.getSprachcontainer().getString("db_f13") + "\n" + exception.toString(), this.getSprachcontainer().getString("db_f4_titel"), 0);
        }
    }

    @Override
    public synchronized void addErgebnis(List<String> list, int n) {
        try {
            list.add(" ; ; ");
            this.zwischenErgebnisse.put(n, list);
            if (this.aufrufZaehler == 11) {
                long l = System.currentTimeMillis() - this.startDatenHolen;
                String string = "Daten laden f\u00fcr Rekorde-Dialog dauerte insgesamt " + l + " ms";
                if (l > 15000L) {
                    this.getLogger().warn(string);
                } else {
                    this.getLogger().debug(string);
                }
                this.zeigeFensterAn();
            }
            ++this.aufrufZaehler;
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
        }
    }
}

